package com.yonyou.uap.message.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yonyou.message.center.entity.UserMessageEntity;
import com.yonyou.message.center.entity.UserRecMsgEntity;
import com.yonyou.message.center.service.IMessageManageService;
import com.yonyou.uap.message.dao.UserMessageManageMapper;

@Service("messageManageService")
public class MessageManageServiceImpl implements IMessageManageService {
	@Autowired
	private UserMessageManageMapper messageManageMapper;
	
	@Override
	public List<UserMessageEntity> queryAllSendMsgs(Map<String, Object> dataMap) {
		return messageManageMapper.queryAllSendMsgs(dataMap);
	}

	@Override
	public List<UserMessageEntity> queryAllDelMsgs(Map<String, Object> dataMap) {
		return messageManageMapper.queryAllDelMsgs(dataMap);
	}

	@Override
	public List<UserMessageEntity> queryAllRecdMsgs(Map<String, Object> dataMap) {
		return messageManageMapper.queryAllRecdMsgs(dataMap);
	}

	@Override
	public List<UserMessageEntity> queryMsgByIdArr(Map<String, Object> dataMap) {
		return messageManageMapper.queryMsgByIdArr(dataMap);
	}

	@Override
	public List<UserRecMsgEntity> queryMsgReceiverByIds(Map<String, Object> dataMap) {
		return messageManageMapper.queryMsgReceiverByIds(dataMap);
	}

	@Override
	public Integer queryAllRecdMsgsNum(Map<String, Object> dataMap) {
		return messageManageMapper.queryAllRecdMsgsNum(dataMap);
	}

	@Override
	public Integer queryAllDelMsgsNum(Map<String, Object> dataMap) {
		return messageManageMapper.queryAllDelMsgsNum(dataMap);
	}

	@Override
	public Integer queryAllSendMsgsNum(Map<String, Object> dataMap) {
		return messageManageMapper.queryAllSendMsgsNum(dataMap);
	}

	@Override
	public void updateUserMsgHandleState(UserMessageEntity ue) {
		messageManageMapper.updateUserMsgHandleState(ue);
	}

	@Override
	public void updateUserRecMsgHandleState(UserRecMsgEntity mre) {
		messageManageMapper.updateUserRecMsgHandleState(mre);
	}

	@Override
	public UserMessageEntity getById(String messageId) {
		return messageManageMapper.getById(messageId);
	}
	
}
