package com.yonyou.uap.message.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yonyou.uap.msg.persistence.exception.MessageException;

public class MsgConfigUtil {
	private static MsgConfigUtil msgConfigUtil = new MsgConfigUtil();
	private Properties prop;
	private Logger logger = LoggerFactory.getLogger(MsgConfigUtil.class);

	public static String getPropertity(String key) throws MessageException {
		Properties Properties = msgConfigUtil.getConfig();
		String value = Properties.getProperty(key);
		return value;
	}

	private Properties getConfig() throws MessageException {
		if (this.prop == null) {
			synchronized (msgConfigUtil) {
				if (this.prop == null) {
					this.prop = new Properties();
					String filePath = System.getProperty("msgConfig-filePath");
					if (filePath == null) {
						filePath = (String) System.getenv().get("msgConfig-filePath");
					}
					if (filePath == null)
						try {
							this.prop.load(
									MsgConfigUtil.class.getResourceAsStream("/msgcenter-ServerConfig.properties"));
						} catch (IOException e) {
							this.logger.error(e.getMessage(), e);
							throw new MessageException("未找到配置文件:msgcenter-ServerConfig.properties");
						}
					else {
						try {
							this.prop.load(new FileInputStream(filePath));
						} catch (IOException e) {
							this.logger.error(e.getMessage(), e);
							throw new MessageException("未找到配置文件" + filePath);
						}
					}
				}
			}
		}

		return this.prop;
	}
}