package com.yonyou.uap.msg.template.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;

import com.yonyou.uap.msg.template.service.IMsgTemplateDataSource;
import com.yonyou.uap.msg.template.service.IMsgTemplateParser;

@Service
public class MsgTemplateParserImpl implements IMsgTemplateParser {
	private static final String SPLIT_WORLD_PREFIX = " \\[";
	private static final String SPLIT_WORLD_SUFFIX = "] ";

	public String parse(String pattern, IMsgTemplateDataSource busiDataSource) {
		StringBuilder patternSB = new StringBuilder();

		String[] patternWithSuffixArray = pattern.split(SPLIT_WORLD_PREFIX);

		for (String patternWithSuffix : patternWithSuffixArray) {
			if (patternWithSuffix.contains(SPLIT_WORLD_SUFFIX)) {
				String express = patternWithSuffix.substring(0, patternWithSuffix.indexOf(SPLIT_WORLD_SUFFIX));

				List<String> expressValueList = busiDataSource.getExpressValue(express);

				String patternWithExpressValue = patternWithSuffix.replaceAll(
						new StringBuilder().append(express).append(SPLIT_WORLD_SUFFIX).toString(), (String) expressValueList.get(0));

				patternSB.append(patternWithExpressValue);
			} else {
				patternSB.append(patternWithSuffix);
			}

		}

		return patternSB.toString();
	}

	public static void main(String[] args) {
		String pattern = "<p>批准<span style=\"color:red;font-weight:bold;\"> [TIME] </span><span style=\"color:red;font-weight:bold;\"> [iform_user.RelationEntity2] </span><span style=\"color:red;font-weight:bold;\"> [iform_user.RelationEntity2.r2_name] </span></p>";
		String[] patternWithSuffixArray = pattern.split(SPLIT_WORLD_PREFIX);

		StringBuilder patternSB = new StringBuilder();

		for (String patternWithSuffix : patternWithSuffixArray) {
			if (patternWithSuffix.contains(SPLIT_WORLD_SUFFIX)) {
				String express = patternWithSuffix.substring(0, patternWithSuffix.indexOf(SPLIT_WORLD_SUFFIX));

				String patternWithExpressValue = patternWithSuffix
						.replaceAll(new StringBuilder().append(express).append(SPLIT_WORLD_SUFFIX).toString(), "业务数据");
				patternSB.append(patternWithExpressValue);
			} else {
				patternSB.append(patternWithSuffix);
			}
		}

		System.out.println(patternSB.toString());
	}
}