package com.yonyou.uap.wb.sign;

import com.yonyou.iuap.security.rest.api.Verifier;
import com.yonyou.iuap.security.rest.common.Credential;
import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.digest.core.HMACDigestUtils;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import com.yonyou.uap.wb.utils.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WBDigestVerifier implements Verifier {
	private static final Logger log = LoggerFactory.getLogger(WBDigestVerifier.class);
	private Credential credential;

	public WBDigestVerifier(Credential credential) {
		this.credential = credential;
	}

	public boolean verify(String sign, SignProp prop) throws UAPSecurityException {
		String a = null;
		try {
			a = PropertiesUtil.getLocalProperty("UAP.KDF.PRF");
		} catch (Exception e) {
			log.error("", e);
		}
		return (sign != null) && (sign.equals(HMACDigestUtils.hmac(prop, this.credential.getKey(), a)));
	}
}