/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.message.center.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import com.yonyou.message.center.service.MessageSendSdk;
import com.yonyou.uap.msg.template.service.IMsgTemplateCreate;
import com.yonyou.uap.msg.template.service.IMsgTemplateDataSource;
import com.yonyou.uap.msg.template.service.impl.MsgTemplateDefaultBusiVarImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message/"})
public class MessagePush {
    private static final Logger logger = LoggerFactory.getLogger(MessagePush.class);
    @Autowired
    private IMsgTemplateCreate msgTemplateCreate;
    @Autowired
    private MessageSendSdk messageSendSdk;

    @RequestMapping(value={"/getMessageByTemplate"})
    @ResponseBody
    public Object getMessageByTemplate(String data) {
        Map dataMap = null;
        try {
            dataMap = (Map)new ObjectMapper().readValue(data, HashMap.class);
        }
        catch (IOException e) {
            logger.error("JSON\u8f6c\u6362\u6210Map\u65f6\u51fa\u9519\uff0cjsonString : " + data, (Throwable)e);
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("msg", "\u4f20\u5165\u7684\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u662f\u4e00\u4e2a\u6807\u51c6\u7684JSON\u5b57\u7b26\u4e32\u3002Parameter : " + data);
            returnMap.put("status", 0);
            return returnMap;
        }
        String templateCode = (String)dataMap.get("templateCode");
        if (StringUtils.isEmpty((String)templateCode)) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("msg", "\u65e0\u6a21\u677f\u7f16\u7801\u53c2\u6570\u3002Parameter : " + data);
            returnMap.put("status", 0);
            return returnMap;
        }
        Map busiDataMap = (Map)dataMap.get("busiData");
        try {
            return this.msgTemplateCreate.createMessageByCode(templateCode, (IMsgTemplateDataSource)new MsgTemplateDefaultBusiVarImpl(busiDataMap));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6d88\u606f\u5931\u8d25", (Throwable)e);
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("msg", "\u521b\u5efa\u6d88\u606f\u5931\u8d25\u3002busiData : " + dataMap.get("busiData"));
            returnMap.put("status", 0);
            return returnMap;
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/pushTemplateMessage"})
    @ResponseBody
    public Object pushTemplateMessage(HttpServletRequest request, HttpServletResponse response, @RequestBody String json) {
        String tenantid;
        Map<String, Integer> returnMap = new HashMap();
        String jsonString = request.getParameter("data");
        if (StringUtils.isBlank((String)jsonString)) {
            jsonString = JSONObject.fromObject((Object)json).getString("data");
        }
        if (StringUtils.isBlank((String)(tenantid = InvocationInfoProxyAdapter.getTenantid()))) {
            try {
                Map dataMap = (Map)new ObjectMapper().readValue(jsonString, HashMap.class);
                String pushTenantid = dataMap.get("tenantid").toString();
                if (StringUtils.isBlank((String)pushTenantid)) {
                    returnMap.put("msg", (Integer)((Object)"\u79df\u6237\u662f\u5fc5\u4f20\u5b57\u6bb5"));
                    returnMap.put("status", 0);
                    return returnMap;
                }
                InvocationInfoProxyAdapter.setTenantid((String)pushTenantid);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        returnMap = this.messageSendSdk.pushTemplateMessage(jsonString);
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/pushTextMessage"})
    @ResponseBody
    public Object pushTextMessage(HttpServletRequest request, HttpServletResponse response, @RequestBody String json) {
        String tenantid;
        Map<String, Integer> returnMap = new HashMap();
        String jsonString = request.getParameter("data");
        System.out.println(jsonString);
        if (StringUtils.isBlank((String)jsonString)) {
            jsonString = JSONObject.fromObject((Object)json).getString("data");
        }
        if (StringUtils.isBlank((String)(tenantid = InvocationInfoProxyAdapter.getTenantid()))) {
            try {
                Map dataMap = (Map)new ObjectMapper().readValue(jsonString, HashMap.class);
                String pushTenantid = dataMap.get("tenantid").toString();
                if (StringUtils.isBlank((String)pushTenantid)) {
                    returnMap.put("msg", (Integer)((Object)"\u79df\u6237\u662f\u5fc5\u4f20\u5b57\u6bb5"));
                    returnMap.put("status", 0);
                    return returnMap;
                }
                InvocationInfoProxyAdapter.setTenantid((String)pushTenantid);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        returnMap = this.messageSendSdk.pushTextMessage(jsonString);
        return returnMap;
    }
}

