/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.message.center.service;

import com.alibaba.fastjson.JSON;
import com.yonyou.message.center.entity.EasemobContent;
import com.yonyou.message.center.util.ContextUtils;
import com.yonyou.uap.entity.content.MessageContent;
import com.yonyou.uap.entity.response.MessageResponse;
import com.yonyou.uap.msg.persistence.service.IMsgTypeService;
import com.yonyou.uap.msg.persistence.service.impl.MsgTypeServiceImpl;
import com.yonyou.uap.service.IMessageSendChannelExt;
import com.yonyou.uap.util.JsonHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class EasemobSend
implements IMessageSendChannelExt {
    private static Logger logger = LoggerFactory.getLogger(EasemobSend.class);

    public List<MessageResponse> send(Map<String, Object> senderInfoMap, Object receiver, Object content) {
        logger.info("senderInfoMap=" + senderInfoMap);
        logger.info("receiver=" + JSON.toJSONString((Object)receiver));
        logger.info("content=" + JSON.toJSONString((Object)content));
        ArrayList<MessageResponse> messageResponseList = new ArrayList<MessageResponse>();
        String returnMsg = null;
        if (!CollectionUtils.isEmpty(senderInfoMap)) {
            String serviceURL = String.valueOf(senderInfoMap.get("serviceURL"));
            logger.info("serviceURL=" + serviceURL);
            if (content instanceof MessageContent) {
                MessageContent messageContent = (MessageContent)content;
                EasemobContent easemobContent = new EasemobContent(messageContent.getTitle(), messageContent.getContent());
                Map origin = messageContent.getOrigin();
                if (origin != null) {
                    ArrayList target = new ArrayList();
                    IMsgTypeService msgTypeService = (IMsgTypeService)ContextUtils.getBeanByClass(MsgTypeServiceImpl.class);
                    logger.info("msgTypeService=" + msgTypeService);
                    String from = String.valueOf(origin.get("sendman"));
                    Map userCodeMap = (Map)origin.get("userCodeMap");
                    Set entryseSet = userCodeMap.entrySet();
                    for (Map.Entry entry : entryseSet) {
                        target.add(entry.getValue());
                    }
                    Map params = (Map)origin.get("params");
                    this.setEasemobContentExt(params, easemobContent);
                    easemobContent.setFrom(from);
                    easemobContent.setTarget(target);
                }
                String json = this.combineJSON(easemobContent);
                logger.info("json=" + json);
                returnMsg = this.sendHttpPost(serviceURL, json);
            }
        }
        String flag = JsonHelper.getAttributeValue(returnMsg, (String)"flag");
        String desc = JsonHelper.getAttributeValue(returnMsg, (String)"desc");
        MessageResponse response = new MessageResponse("0".equals(flag) ? "1" : "0", desc);
        messageResponseList.add(response);
        return messageResponseList;
    }

    private String combineJSON(EasemobContent easemobContent) {
        JSONObject httpJson = new JSONObject();
        try {
            httpJson.put("msg", easemobContent.getContent());
            httpJson.put("from", (Object)easemobContent.getFrom());
            JSONArray jArr = new JSONArray(Arrays.toString(easemobContent.getTarget().toArray()));
            httpJson.put("target", (Object)jArr);
            httpJson.put("appid", (Object)easemobContent.getAppid());
            httpJson.put("redirect", (Object)easemobContent.getRedirect());
            httpJson.put("msgtype", (Object)easemobContent.getMsgtype());
            httpJson.put("target_type", (Object)easemobContent.getTarget_type());
            httpJson.put("url", (Object)easemobContent.getUrl());
            if (!StringUtils.isEmpty((Object)easemobContent.getFileContent())) {
                httpJson.put("fileContent", (Object)easemobContent.getFileContent());
            }
            if (!StringUtils.isEmpty((Object)easemobContent.getPicdesc())) {
                httpJson.put("picdesc", (Object)easemobContent.getPicdesc());
            }
            if (!StringUtils.isEmpty((Object)easemobContent.getWidth())) {
                httpJson.put("width", (Object)easemobContent.getWidth());
            }
            if (!StringUtils.isEmpty((Object)easemobContent.getHeight())) {
                httpJson.put("height", (Object)easemobContent.getHeight());
            }
            if (CollectionUtils.isEmpty((Map)easemobContent.getExt())) {
                Map map = easemobContent.getExt();
                JSONObject jsonObejct = new JSONObject(map);
                httpJson.put("ext", (Object)jsonObejct);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String json = httpJson.toString();
        return json;
    }

    private String sendHttpPost(String serviceURL, String json) {
        String callback = null;
        try {
            HttpPost httpPost = new HttpPost(serviceURL);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            list.add(new BasicNameValuePair("params", json));
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(list, "UTF-8");
            httpPost.setEntity((HttpEntity)postEntity);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            callback = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            int status = response.getStatusLine().getStatusCode();
            logger.info("callback=" + callback);
            logger.info("status=" + status);
            if (status != 200) {
                logger.info("\u53d1\u9001\u79fb\u52a8\u6d88\u606f\u63d0\u9192\u5931\u8d25\uff01");
            } else {
                logger.info("\u53d1\u9001\u79fb\u52a8\u6d88\u606f\u63d0\u9192\u6210\u529f\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return callback;
    }

    private void setEasemobContentExt(Map<String, Object> params, EasemobContent easemobContent) {
        if (CollectionUtils.isEmpty(params)) {
            params = new HashMap<String, Object>();
        }
        if (params.get("msgtype") != null) {
            easemobContent.setMsgtype(String.valueOf(params.get("msgtype")));
        } else {
            easemobContent.setMsgtype("0");
        }
        if (params.get("target_type") != null) {
            easemobContent.setTarget_type(String.valueOf(params.get("target_type")));
        } else {
            easemobContent.setTarget_type("users");
        }
        if (params.get("appid") != null) {
            easemobContent.setAppid(String.valueOf(params.get("appid")));
        } else {
            easemobContent.setAppid("xyd");
        }
        if (params.get("redirect") != null) {
            easemobContent.setRedirect(String.valueOf(params.get("redirect")));
        } else {
            easemobContent.setRedirect("1");
        }
        if (params.get("url") != null) {
            easemobContent.setUrl(String.valueOf(params.get("url")));
        }
        if (params.get("fileContent") != null) {
            easemobContent.setFileContent(String.valueOf(params.get("fileContent")));
        }
        if (params.get("picdesc") != null) {
            easemobContent.setPicdesc(String.valueOf(params.get("picdesc")));
        }
        if (params.get("width") != null) {
            easemobContent.setWidth(String.valueOf(params.get("width")));
        }
        if (params.get("height") != null) {
            easemobContent.setHeight(String.valueOf(params.get("height")));
        }
        if (params.get("ext") != null) {
            Map map = (Map)params.get("ext");
            easemobContent.setExt(map);
        }
    }
}

