/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.message.center.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.message.center.entity.AutoSendMsgParameter;
import com.yonyou.message.center.service.AutoSendMsgService;
import com.yonyou.message.center.service.SendType;
import com.yyjz.icop.mq.common.MqMessage;
import com.yyjz.icop.mq.sender.MsgSender;
import com.yyjz.icop.permission.role.service.UserRelationRoleService;
import com.yyjz.icop.share.api.bo.MsgTplMsgVO;
import com.yyjz.icop.share.api.service.MsgTplAPIService;
import com.yyjz.icop.usercenter.service.IUserService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="autoSendMsgService")
public class AutoSendMsgServiceImpl
implements AutoSendMsgService {
    private static Logger logger = LoggerFactory.getLogger(AutoSendMsgServiceImpl.class);
    private static final String message_queue_name = "icop-message-queue-auto";
    @Autowired
    private MsgSender msgSender;
    @Autowired
    private MsgTplAPIService msgTplAPIService;
    @Autowired
    private IUserService userService;
    @Autowired
    private UserRelationRoleService userRelationRoleService;

    public String pushMessage(AutoSendMsgParameter msgParameter) {
        logger.debug("msgParameter: {}", (Object)JSONObject.toJSONString((Object)msgParameter));
        String userIds = null;
        try {
            String roleIds;
            String orgIds;
            if (msgParameter.getSendType().equals((Object)SendType.COMPANY_ROLE)) {
                orgIds = msgParameter.getCompanyId();
                roleIds = msgParameter.getRoleIds();
            } else {
                String msgCode = msgParameter.getMsgCode();
                String msgTplCode = msgParameter.getMsgTplCode();
                String companyId = msgParameter.getCompanyId();
                MsgTplMsgVO msgVO = this.msgTplAPIService.getMsgByCode(msgTplCode, msgCode);
                if (msgVO == null) {
                    return "{\"success\":false}";
                }
                logger.debug("msgVO: {}", (Object)JSONObject.toJSONString((Object)msgVO));
                orgIds = StringUtils.isEmpty((Object)companyId) ? msgVO.getDef1() : companyId;
                roleIds = msgVO.getDef2();
                userIds = msgVO.getDef3();
            }
            if (StringUtils.isEmpty(userIds)) {
                String roleUserIds;
                String orgUserIds;
                HashSet<Object> orgUserIdList = new HashSet();
                HashSet<Object> roleUserIdList = new HashSet();
                if (!StringUtils.isEmpty((Object)orgIds) && !StringUtils.isEmpty((Object)(orgUserIds = this.getUserIdsByOrgIds(orgIds)))) {
                    orgUserIdList = new HashSet<String>(Arrays.asList(orgUserIds.split(",")));
                }
                if (!StringUtils.isEmpty((Object)roleIds) && !StringUtils.isEmpty((Object)(roleUserIds = this.getUserIdsByRoleIds(roleIds)))) {
                    roleUserIdList = new HashSet<String>(Arrays.asList(roleUserIds.split(",")));
                }
                roleUserIdList.retainAll(orgUserIdList);
                userIds = StringUtils.collectionToCommaDelimitedString(roleUserIdList);
                if (StringUtils.isEmpty((Object)userIds) && (roleUserIdList.size() > 0 || orgUserIdList.size() > 0)) {
                    logger.error("\u7528\u6237id\u4e3a\u7a7a\uff1a\u7ec4\u7ec7\u548c\u89d2\u8272\u4e0b\u4eba\u5458\u53bb\u4ea4\u96c6\uff0c\u7528\u6237\u4e3a\u7a7a");
                    return "{\"success\":false,\"msg\":\"\u7528\u6237id\u4e3a\u7a7a\uff1a\u7ec4\u7ec7\u548c\u89d2\u8272\u4e0b\u4eba\u5458\u53d6\u4ea4\u96c6\uff0c\u7528\u6237\u4e3a\u7a7a\"}";
                }
            }
            logger.debug("userIds: {}", userIds);
            if (StringUtils.isEmpty(userIds)) {
                logger.error("\u7528\u6237id\u4e3a\u7a7a\uff1a");
                return "{\"success\":false,\"msg\":\"\u7528\u6237id\u4e3a\u7a7a\"}";
            }
            msgParameter.setRecevier(StringUtils.commaDelimitedListToStringArray(userIds));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)msgParameter);
            this.msgSender.sendMessage(mqMessage, message_queue_name);
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff1a", (Throwable)e);
            return "{\"success\":false,\"msg\":\"" + e.getMessage() + "\"}";
        }
        return "{\"success\":true,\"data\":\"" + userIds + "\"}";
    }

    private String getUserIdsByOrgIds(String orgIds) {
        if (StringUtils.isEmpty((Object)orgIds)) {
            return null;
        }
        List userIds = this.userService.findByCompanyId(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)orgIds)));
        logger.debug("query userIds by orgIds: {}", (Object)userIds);
        return StringUtils.arrayToCommaDelimitedString((Object[])userIds.toArray());
    }

    private String getUserIdsByRoleIds(String roleIds) {
        if (StringUtils.isEmpty((Object)roleIds)) {
            return null;
        }
        List userIds = this.userRelationRoleService.findPowerRoleIds(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)roleIds)));
        logger.debug("query userIds by roleIds: {}", (Object)userIds);
        return StringUtils.arrayToCommaDelimitedString((Object[])userIds.toArray());
    }
}

