/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.sms.util;

import com.yonyou.sms.util.JsonHelper;
import com.yonyou.sms.util.MessageResponse;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleParseXML {
    private static Logger logger = LoggerFactory.getLogger(SimpleParseXML.class);

    public List<Element> getMSConfig(String elementName) {
        String configFilePath = "msconfig.xml";
        Element root = this.getDocument(configFilePath).getRootElement();
        return root.elements(elementName);
    }

    public Map<String, String> getErrorCodeDescription(String pushType) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String errorFilePath = "ReturnCodeDescription.xml";
        Element root = this.getDocument(errorFilePath).getRootElement();
        Element pushTypeNode = (Element)root.elements(pushType).get(0);
        Iterator iterator = pushTypeNode.elementIterator();
        while (iterator.hasNext()) {
            Element descriptionElement = (Element)iterator.next();
            returnMap.put(descriptionElement.attributeValue("code"), descriptionElement.attributeValue("content"));
        }
        return returnMap;
    }

    public MessageResponse getMessageResponseByCode(String pushType, String responseJSON) {
        String code = JsonHelper.getAttributeValue((String)responseJSON, (String)"code");
        Map returnMap = new SimpleParseXML().getErrorCodeDescription(pushType);
        String content = (String)returnMap.get(code);
        MessageResponse response = new MessageResponse(code, content);
        return response;
    }

    private Document getDocument(String filePath) {
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            doc = reader.read(in);
        }
        catch (DocumentException e) {
            logger.error("\u6307\u5b9a\u6587\u4ef6\u8def\u5f84\uff1a" + filePath + "\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
        return doc;
    }

    public static void main(String[] args) {
        Map returnMap = new SimpleParseXML().getErrorCodeDescription("messagepush");
        System.out.println(returnMap);
    }
}

