/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.message.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.uap.message.dao.MsgChannelMapper;
import com.yonyou.uap.message.entity.MsgChannel;
import com.yonyou.uap.message.service.IMessageChannel;
import com.yonyou.uap.util.SimpleParseXML;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/message/"})
public class MessageChannelController {
    @Autowired
    private IMessageChannel massageChannel;
    @Autowired
    private MsgChannelMapper msgChannelMapper;

    @RequestMapping(method={RequestMethod.GET}, value={"/data/{id}"})
    @ResponseBody
    public Object queryMsgChannel(@PathVariable(value="id") String id) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)id)) {
            returnMap.put("msg", "\u6d88\u606f\u901a\u9053Id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u52a0\u8f7d\u6d88\u606f\u901a\u9053\u5185\u5bb9");
            returnMap.put("status", 0);
            return returnMap;
        }
        MsgChannel channel = this.massageChannel.queryMsgChannelById(id);
        returnMap.put("data", channel);
        returnMap.put("msg", "\u67e5\u8be2\u6210\u529f!");
        returnMap.put("status", 1);
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"updateMsgChannel"})
    @ResponseBody
    public Map<String, Object> updateMsgChannel(HttpServletRequest request, HttpServletResponse response) throws JsonParseException, JsonMappingException, IOException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String jsonString = request.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        Map dataMap = (Map)mapper.readValue(jsonString, HashMap.class);
        String id = (String)dataMap.get("id");
        Map configMap = (Map)dataMap.get("configinfo");
        JSONObject jsonObj = JSONObject.fromObject((Object)configMap);
        String configJson = jsonObj.toString();
        MsgChannel channel = this.msgChannelMapper.selectByPrimaryKey(id);
        if (channel == null) {
            returnMap.put("msg", "\u6570\u636e\u5df2\u88ab\u5220\u9664");
            returnMap.put("status", 0);
        } else {
            channel.setConfiginfo(configJson);
            this.massageChannel.update(channel);
            returnMap.put("msg", "\u4fee\u6539\u6210\u529f");
            returnMap.put("status", 1);
        }
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/queryAllMsgChannel"})
    @ResponseBody
    public Object queryAllMsgChannel() {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List channelList = this.massageChannel.queryAllMsgChannel();
        JSONObject keyNameObj = SimpleParseXML.getInstance().getChannelName();
        returnMap.put("data", channelList);
        returnMap.put("nameData", keyNameObj);
        returnMap.put("msg", "\u67e5\u8be2\u6210\u529f!");
        returnMap.put("status", 1);
        return returnMap;
    }
}

