/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.message.persistence.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.message.center.entity.PushMsgParameter;
import com.yonyou.message.center.entity.UserMessageEntity;
import com.yonyou.message.center.entity.UserRecMsgEntity;
import com.yonyou.message.center.service.IMessageManageService;
import com.yonyou.message.center.service.PushMsgService;
import com.yonyou.uap.message.utils.CommonUtils;
import com.yonyou.uap.msg.persistence.entity.MessageEntity;
import com.yonyou.uap.msg.persistence.entity.MsgReceiverEntity;
import com.yonyou.uap.msg.persistence.entity.MsgTypeEntity;
import com.yonyou.uap.msg.persistence.entity.MsgUserEntity;
import com.yonyou.uap.msg.persistence.sdk.MessageServiceSdk;
import com.yonyou.uap.msg.persistence.service.IMessageService;
import com.yonyou.uap.msg.persistence.service.IMsgReceiverService;
import com.yonyou.uap.msg.persistence.service.IMsgTypeService;
import com.yonyou.uap.msg.persistence.service.IUserInfoService;
import com.yyjz.icop.usercenter.service.IUserService;
import com.yyjz.icop.usercenter.vo.UserBaseVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/message"})
public class MsgPersistenceController {
    @Autowired
    private IMessageService msgService;
    @Autowired
    private IMsgReceiverService receiverService;
    @Autowired
    private IMsgTypeService msgTypeService;
    @Autowired
    private IUserInfoService userInfoService;
    @Autowired
    private IMessageManageService messageManageService;
    @Autowired
    private IUserService userService;
    @Autowired
    private MessageServiceSdk messageServiceSdk;
    @Autowired
    private PushMsgService pushMsgService;
    private Logger logger = LoggerFactory.getLogger(MsgPersistenceController.class);

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/getMessage"})
    public Map<String, Object> getMessage(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String jsonString = request.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        Map dataMap = null;
        try {
            dataMap = (Map)mapper.readValue(jsonString, HashMap.class);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("data", "");
            returnMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u51fa\u9519");
            returnMap.put("status", "0");
            return returnMap;
        }
        HashMap<String, List> returnDataMap = new HashMap<String, List>();
        String receiver = this.getReceiver(dataMap);
        List msgTypeList = this.msgTypeService.queryAllMsgType();
        ArrayList list = new ArrayList();
        List msgTypeNumMapList = this.msgService.queryMsgTypeNumber(receiver);
        for (MsgTypeEntity msgType : msgTypeList) {
            HashMap<String, Object> msgTypeMap = new HashMap<String, Object>();
            msgTypeMap.put("typecode", msgType.getTypecode());
            msgTypeMap.put("typename", msgType.getTypename());
            int msgNum = 0;
            for (Map map : msgTypeNumMapList) {
                if (map.get("msgtype") == null || !msgType.getTypecode().equals(map.get("msgtype"))) continue;
                msgNum = ((Number)map.get("count")).intValue();
            }
            msgTypeMap.put("num", msgNum);
            list.add(msgTypeMap);
        }
        returnDataMap.put("msgtype", list);
        Map searchMap = this.buildSearchMap(dataMap, request);
        List msgList = this.getMessageList(searchMap);
        this.transMessageList(msgList);
        returnDataMap.put("message", msgList);
        returnMap.put("data", returnDataMap);
        returnMap.put("status", 1);
        returnMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u6210\u529f");
        return returnMap;
    }

    private String getReceiver(Map<String, Object> dataMap) {
        String receiver = InvocationInfoProxy.getUserid();
        if (org.springframework.util.StringUtils.isEmpty((Object)receiver)) {
            receiver = (String)dataMap.get("receiver");
        }
        return receiver;
    }

    private String getTenantId() {
        return InvocationInfoProxy.getTenantid();
    }

    private String getUserId() {
        return InvocationInfoProxy.getUserid();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/getMessageforMainView"})
    public Map<String, Object> getMessageInfo(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Map dataMap = null;
        try {
            dataMap = this.getRequestData(request);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("data", "");
            returnMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u51fa\u9519");
            returnMap.put("status", "0");
            return returnMap;
        }
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
        Map searchMap = this.buildSearchMap(dataMap, request);
        List msgTypeList = this.msgTypeService.queryAllMsgType();
        List msgList = this.getMessageList(searchMap);
        this.transMessageList(msgList);
        ArrayList msgNumList = new ArrayList();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("read");
        statusList.add("unread");
        for (String statuskey : statusList) {
            HashMap<String, Object> msgNumMap = new HashMap<String, Object>();
            int readNum = 0;
            if (statuskey.equals("read")) {
                searchMap.put("status", "1");
                msgNumMap.put("status", "read");
                readNum = this.msgService.getMessageNum(searchMap);
            } else if (statuskey.equals("unread")) {
                searchMap.put("status", "0");
                msgNumMap.put("status", "unread");
                readNum = this.msgService.getUnReadMessageNum(searchMap);
            }
            msgNumMap.put("num", readNum);
            msgNumList.add(msgNumMap);
        }
        String tenantid = this.getTenantId();
        String receiver = this.getReceiver(dataMap);
        int count = this.getUnreadMsgNums(receiver, tenantid);
        returnDataMap.put("totalUnreadNum", count);
        returnDataMap.put("msgtype", msgTypeList);
        returnDataMap.put("message", msgList);
        returnDataMap.put("msgnum", msgNumList);
        returnDataMap.put("current", String.valueOf(dataMap.get("pagenum")));
        returnMap.put("data", returnDataMap);
        returnMap.put("status", 1);
        returnMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u6210\u529f");
        return returnMap;
    }

    private void transMessageList(List<MessageEntity> msgList) {
        ArrayList<String> userIdList = new ArrayList<String>();
        for (MessageEntity entity : msgList) {
            String userId = entity.getSender();
            if (!StringUtils.isNotBlank((String)userId)) continue;
            userIdList.add(userId);
        }
        List userList = this.userInfoService.getUsersByIds(userIdList.toArray(new String[0]));
        for (MessageEntity entity : msgList) {
            String userId;
            String userName = userId = entity.getSender();
            if (org.springframework.util.StringUtils.isEmpty((Object)userId)) continue;
            for (MsgUserEntity user : userList) {
                if (!user.getId().equals(userId)) continue;
                userName = user.getName();
                break;
            }
            entity.setSender(userName);
        }
    }

    private Map<String, Object> buildSearchMap(Map<String, Object> dataMap, HttpServletRequest request) {
        String tenantId;
        String currentPageStr = String.valueOf(dataMap.get("pagenum"));
        String pageSizeStr = String.valueOf(dataMap.get("pagesize"));
        String msgtype = (String)dataMap.get("msgtype");
        String status = (String)dataMap.get("status");
        String receiver = this.getReceiver(dataMap);
        String startTime = (String)dataMap.get("starttime");
        String endTime = (String)dataMap.get("endtime");
        String search = (String)dataMap.get("search");
        int currentPage = 0;
        int pageSize = 0;
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        currentPage = org.springframework.util.StringUtils.isEmpty((Object)currentPageStr) ? 1 : Integer.valueOf(currentPageStr);
        pageSize = org.springframework.util.StringUtils.isEmpty((Object)pageSizeStr) ? 10 : Integer.valueOf(pageSizeStr);
        if (!org.springframework.util.StringUtils.isEmpty((Object)msgtype) && !msgtype.equals("all")) {
            searchMap.put("msgtype", msgtype);
        }
        int startIndex = (currentPage - 1) * pageSize;
        searchMap.put("startIndex", startIndex);
        searchMap.put("pageSize", pageSize);
        searchMap.put("receiver", receiver);
        if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
            searchMap.put("status", status);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)startTime)) {
            searchMap.put("starttime", startTime);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)endTime)) {
            searchMap.put("endtime", endTime);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)search)) {
            String searchContent = "%" + search + "%";
            searchMap.put("search", searchContent);
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)(tenantId = this.getTenantId()))) {
            searchMap.put("tenantid", dataMap.get("tenantid"));
        } else {
            searchMap.put("tenantid", tenantId);
        }
        return searchMap;
    }

    private List<MessageEntity> getMessageList(Map<String, Object> searchMap) {
        List msgList = null;
        msgList = !org.springframework.util.StringUtils.isEmpty((Object)searchMap.get("status")) && searchMap.get("status").equals("0") ? this.msgService.getUnReadMessage(searchMap) : this.msgService.getMessage(searchMap);
        return msgList;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/updatestatus"})
    public Map<String, Object> updatestatus(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            MsgReceiverEntity receiverEntity;
            Map dataMap = this.getRequestData(request);
            String msgid = (String)dataMap.get("id");
            String status = (String)dataMap.get("status");
            String receiver = null;
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("userId")) continue;
                    receiver = cookie.getValue();
                }
            }
            if (org.springframework.util.StringUtils.isEmpty(receiver)) {
                receiver = InvocationInfoProxy.getUserid();
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)(receiverEntity = this.receiverService.queryReceiverByMsgIdAndReceiver(msgid, receiver)))) {
                returnMap.put("msg", "\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u4e0d\u5b58\u5728");
                returnMap.put("status", 0);
                return returnMap;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)status)) {
                receiverEntity.setStatus(status);
            }
            this.messageServiceSdk.updateStatus(receiverEntity);
            returnMap.put("msg", "\u6d88\u606f\u72b6\u6001\u56de\u5199\u6210\u529f");
            returnMap.put("status", 1);
            return returnMap;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("msg", "\u4fee\u6539\u6570\u636e\u51fa\u9519");
            returnMap.put("status", 0);
            return returnMap;
        }
    }

    private Map<String, Object> getRequestData(HttpServletRequest request) throws IOException {
        Map dataMap;
        String jsonString = request.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        if (StringUtils.isBlank((String)jsonString)) {
            ServletInputStream inputStream = request.getInputStream();
            jsonString = IOUtils.toString((InputStream)inputStream);
            dataMap = (Map)mapper.readValue(jsonString, HashMap.class);
            dataMap = (Map)dataMap.get("data");
        } else {
            dataMap = (Map)mapper.readValue(jsonString, HashMap.class);
        }
        return dataMap;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/getUnReadMsg"})
    public Map<String, Object> getUnReadMsg(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String receiver = request.getParameter("receiver");
        if (StringUtils.isBlank((String)receiver)) {
            receiver = InvocationInfoProxy.getUserid();
        }
        if (StringUtils.isBlank((String)receiver)) {
            returnMap.put("msg", "\u6d88\u606f\u63a5\u53d7\u4eba\u4e0d\u5b58\u5728");
            returnMap.put("status", "0");
            return returnMap;
        }
        String tenantid = this.getTenantId();
        int count = this.getUnreadMsgNums(receiver, tenantid);
        returnMap.put("unReadNum", count);
        returnMap.put("status", "1");
        return returnMap;
    }

    private int getUnreadMsgNums(String receiver, String tenantid) {
        int count = 0;
        ArrayList<String> receiverList = new ArrayList<String>();
        receiverList.add(receiver);
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)tenantid)) {
            searchMap.put("tenantid", tenantid);
        }
        searchMap.put("receiverList", receiverList);
        List unreadMsgNumMap = this.msgService.getUnReadMsgNumBatch(searchMap);
        if (null != unreadMsgNumMap) {
            for (Map msgNumMap : unreadMsgNumMap) {
                count = Integer.valueOf(String.valueOf(msgNumMap.get("count")));
            }
        }
        return count;
    }

    @RequestMapping(value={"/allMsgs"})
    @ResponseBody
    public Map<String, Object> getAllMsgs(HttpServletRequest request, HttpServletResponse response) {
        Map dataMap = null;
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        try {
            dataMap = this.getRequestData(request);
            String queryType = String.valueOf(dataMap.get("type"));
            if ("1".equals(queryType)) {
                return this.getAllSendMsgs(dataMap);
            }
            if ("2".equals(queryType)) {
                return this.getAlldelMsgsByProperties(dataMap);
            }
            return this.getAllRecMsgsByProperties(dataMap);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            respMap.put("data", "");
            respMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u51fa\u9519");
            respMap.put("status", "0");
            return respMap;
        }
    }

    public Map<String, Object> getAllSendMsgs(Map<String, Object> dataMap) {
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        String tenantId = this.getTenantId();
        String userId = this.getUserId();
        try {
            if (StringUtils.isNotBlank((String)tenantId)) {
                dataMap.put("tenantid", tenantId);
            }
            String pageSize = null != dataMap.get("pagesize") ? dataMap.get("pagesize").toString() : "10";
            String currentPage = null == dataMap.get("pagenum") ? "1" : dataMap.get("pagenum").toString();
            int startIndex = (Integer.valueOf(currentPage) - 1) * Integer.valueOf(pageSize);
            dataMap.put("status", "0");
            dataMap.put("startIndex", startIndex);
            dataMap.put("pageSize", Integer.valueOf(pageSize));
            dataMap.put("sender", userId);
            List userSendMsgsList = this.messageManageService.queryAllSendMsgs(dataMap);
            Integer totalDataNums = this.messageManageService.queryAllSendMsgsNum(dataMap);
            ArrayList msgNumList = new ArrayList();
            HashMap<String, Integer> numMap = new HashMap<String, Integer>();
            numMap.put("num", totalDataNums != null ? totalDataNums : 0);
            msgNumList.add(new HashMap());
            msgNumList.add(numMap);
            msgNumList.add(new HashMap());
            this.getMsgReceiverInfo(userSendMsgsList);
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            List msgTypeList = this.msgTypeService.queryAllMsgType();
            respMap.put("msgtype", msgTypeList);
            respMap.put("current", currentPage);
            respMap.put("message", userSendMsgsList);
            respMap.put("status", 1);
            respMap.put("msgnum", msgNumList);
            returnMap.put("data", respMap);
            returnMap.put("status", 1);
            returnMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u6210\u529f");
            return returnMap;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            respMap.put("data", "");
            respMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u51fa\u9519");
            respMap.put("status", "0");
            return respMap;
        }
    }

    public Map<String, Object> getAlldelMsgsByProperties(Map<String, Object> dataMap) {
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        String tenantId = this.getTenantId();
        String uid = this.getUserId();
        try {
            if (StringUtils.isNotBlank((String)tenantId)) {
                dataMap.put("tenantid", tenantId);
            }
            String pageSize = null != dataMap.get("pagesize") ? dataMap.get("pagesize").toString() : "10";
            String currentPage = null == dataMap.get("pagenum") ? "1" : dataMap.get("pagenum").toString();
            int startIndex = (Integer.valueOf(currentPage) - 1) * Integer.valueOf(pageSize);
            dataMap.put("startIndex", startIndex);
            dataMap.put("pageSize", Integer.valueOf(pageSize));
            dataMap.put("receiver", uid);
            dataMap.put("sender", uid);
            dataMap.put("status2", new String[]{"1"});
            dataMap.put("status1", new String[]{"0", "1", "2"});
            dataMap.put("recMsgDr", "1");
            List userSendMsgsList = this.messageManageService.queryAllDelMsgs(dataMap);
            this.getMsgReceiverInfo(userSendMsgsList);
            this.getMsgSenderInfo(userSendMsgsList);
            Integer totalDataNums = this.messageManageService.queryAllDelMsgsNum(dataMap);
            ArrayList msgNumList = new ArrayList();
            HashMap<String, Integer> numMap = new HashMap<String, Integer>();
            numMap.put("num", totalDataNums != null ? totalDataNums : 0);
            msgNumList.add(new HashMap());
            msgNumList.add(numMap);
            msgNumList.add(new HashMap());
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            List msgTypeList = this.msgTypeService.queryAllMsgType();
            respMap.put("msgtype", msgTypeList);
            respMap.put("current", currentPage);
            respMap.put("message", userSendMsgsList);
            respMap.put("status", 1);
            respMap.put("msgnum", msgNumList);
            returnMap.put("data", respMap);
            returnMap.put("status", 1);
            returnMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u6210\u529f");
            return returnMap;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            respMap.put("data", "");
            respMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u51fa\u9519");
            respMap.put("status", "0");
            return respMap;
        }
    }

    private void getMsgReceiverInfo(List<UserMessageEntity> userSendMsgsList) {
        ArrayList<String> uids = new ArrayList<String>();
        HashMap<String, String[]> msgRecers = new HashMap<String, String[]>();
        ArrayList receiversList = new ArrayList();
        if (CollectionUtils.isNotEmpty(userSendMsgsList)) {
            for (UserMessageEntity ue : userSendMsgsList) {
                String[] uidArr = null;
                if (StringUtils.isBlank((String)ue.getReceiver())) continue;
                for (String uid : uidArr = ue.getReceiver().split(",")) {
                    if (uids.contains(uid)) continue;
                    uids.add(uid);
                }
                msgRecers.put(ue.getId(), uidArr);
            }
            Map usersMap = this.userService.getAllUserMapByUid(uids);
            StringBuffer recNames = null;
            for (UserMessageEntity ue : userSendMsgsList) {
                recNames = new StringBuffer();
                String[] uidArr = (String[])msgRecers.get(ue.getId());
                if (StringUtils.isBlank((String)ue.getReceiver())) continue;
                for (String uid : uidArr = ue.getReceiver().split(",")) {
                    HashMap<String, String> recer = new HashMap<String, String>();
                    UserBaseVO vo = (UserBaseVO)usersMap.get(uid);
                    if (null == vo || StringUtils.isBlank((String)vo.getUserName())) continue;
                    recNames.append(vo.getUserName()).append(",");
                    recer.put("id", vo.getUserId());
                    recer.put("name", vo.getUserName());
                    receiversList.add(recer);
                }
                if (!StringUtils.isNotBlank((String)recNames.toString())) continue;
                ue.setReceverName(recNames.toString().substring(0, recNames.lastIndexOf(",")));
                ue.setReceivers(receiversList);
            }
        }
    }

    private void getMsgSenderInfo(List<UserMessageEntity> userSendMsgsList) {
        ArrayList<String> uids = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(userSendMsgsList)) {
            for (UserMessageEntity ue : userSendMsgsList) {
                if (uids.contains(ue.getSender()) || !StringUtils.isNotBlank((String)ue.getSender())) continue;
                uids.add(ue.getSender());
            }
            if (CollectionUtils.isNotEmpty(uids)) {
                Map usersMap = this.userService.getAllUserMapByUid(uids);
                for (UserMessageEntity ue : userSendMsgsList) {
                    UserBaseVO vo = (UserBaseVO)usersMap.get(ue.getSender());
                    if (null == vo || StringUtils.isBlank((String)vo.getUserName())) continue;
                    ue.setSenderName(vo.getUserName());
                }
            }
        }
    }

    public Map<String, Object> getAllRecMsgsByProperties(Map<String, Object> dataMap) {
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        String userName = null;
        String tenantId = this.getTenantId();
        String uid = this.getUserId();
        try {
            if (StringUtils.isNotBlank((String)tenantId)) {
                dataMap.put("tenantid", tenantId);
            }
            String readStatus = null == dataMap.get("status") ? "0" : dataMap.get("status").toString();
            String pageSize = null != dataMap.get("pagesize") ? dataMap.get("pagesize").toString() : "10";
            String currentPage = null == dataMap.get("pagenum") ? "1" : dataMap.get("pagenum").toString();
            int startIndex = (Integer.valueOf(currentPage) - 1) * Integer.valueOf(pageSize);
            dataMap.put("startIndex", startIndex);
            dataMap.put("pageSize", Integer.valueOf(pageSize));
            dataMap.put("status", new String[]{"0", "1", "2"});
            dataMap.put("readStatus", new String[]{readStatus});
            dataMap.put("recMsgDr", new String[]{"0"});
            List userSendMsgsList = this.messageManageService.queryAllRecdMsgs(dataMap);
            UserBaseVO vo = this.userService.findUserById(uid);
            if (null != vo) {
                userName = vo.getUserName();
            }
            Integer totalDataNums = this.messageManageService.queryAllRecdMsgsNum(dataMap);
            if (StringUtils.isNotBlank((String)userName)) {
                for (UserMessageEntity ue : userSendMsgsList) {
                    ue.setReceverName(userName);
                }
            }
            this.getMsgSenderInfo(userSendMsgsList);
            ArrayList msgNumList = new ArrayList();
            HashMap<String, Integer> numMap = new HashMap<String, Integer>();
            numMap.put("num", totalDataNums != null ? totalDataNums : 0);
            msgNumList.add(new HashMap());
            msgNumList.add(numMap);
            msgNumList.add(new HashMap());
            List msgTypeList = this.msgTypeService.queryAllMsgType();
            respMap.put("msgtype", msgTypeList);
            respMap.put("current", currentPage);
            respMap.put("message", userSendMsgsList);
            respMap.put("status", 1);
            respMap.put("msgnum", msgNumList);
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("data", respMap);
            returnMap.put("status", 1);
            returnMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u6210\u529f");
            return returnMap;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            respMap.put("data", "");
            respMap.put("msg", "\u6d88\u606f\u67e5\u8be2\u51fa\u9519");
            respMap.put("status", "0");
            return respMap;
        }
    }

    @RequestMapping(value={"/delMsgs"})
    @ResponseBody
    public Map<String, Object> updateMesgsStatus(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String tenantId = this.getTenantId();
        try {
            Map dataMap = this.getRequestData(request);
            if (StringUtils.isNotBlank((String)tenantId)) {
                dataMap.put("tenantid", tenantId);
            }
            List sendMsgIds = (List)dataMap.get("sendIds");
            List recMsgIds = (List)dataMap.get("recIds");
            String handleState = String.valueOf(dataMap.get("handleState"));
            if ("null".equals(handleState) || StringUtils.isBlank((String)handleState)) {
                this.logger.error("\u53c2\u6570\u9519\u8bef\uff0c\u6d88\u606f\u5220\u9664\u5931\u8d25\u3002");
                returnMap.put("msg", "\u53c2\u6570\u9519\u8bef\uff0c\u6d88\u606f\u5220\u9664\u5931\u8d25\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            String userId = null;
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("userId")) continue;
                    userId = cookie.getValue();
                }
            }
            if (org.springframework.util.StringUtils.isEmpty(userId)) {
                userId = this.getUserId();
            }
            if (CollectionUtils.isNotEmpty((Collection)sendMsgIds)) {
                dataMap.put("sendMsgIdArr", sendMsgIds.toArray(new String[sendMsgIds.size()]));
                dataMap.put("senderUid", userId);
                List msgList = this.messageManageService.queryMsgByIdArr(dataMap);
                if (CollectionUtils.isNotEmpty((Collection)msgList)) {
                    for (UserMessageEntity ue : msgList) {
                        ue.setStatus(handleState);
                        this.messageManageService.updateUserMsgHandleState(ue);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)recMsgIds)) {
                dataMap.put("receiverUid", userId);
                dataMap.put("recMsgIdArr", recMsgIds.toArray(new String[recMsgIds.size()]));
                dataMap.put("recevierUid", userId);
                List recMsgList = this.messageManageService.queryMsgReceiverByIds(dataMap);
                if (CollectionUtils.isNotEmpty((Collection)recMsgList)) {
                    for (UserRecMsgEntity mre : recMsgList) {
                        mre.setDr(handleState);
                        this.messageManageService.updateUserRecMsgHandleState(mre);
                    }
                }
            }
            returnMap.put("msg", "\u6d88\u606f\u5220\u9664\u6210\u529f\u3002");
            returnMap.put("status", 1);
            return returnMap;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("msg", "\u670d\u52a1\u5f02\u5e38\uff0c\u6d88\u606f\u5220\u9664\u5931\u8d25\u3002");
            returnMap.put("status", 0);
            return returnMap;
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/newMessage"})
    @ResponseBody
    public Map<String, Object> addNewMessage(HttpServletRequest request) {
        Map dataMap = new HashMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        PushMsgParameter pmp = new PushMsgParameter();
        ObjectMapper mapper = new ObjectMapper();
        String sendman = null;
        String msgType = null;
        String subject = null;
        String content = null;
        try {
            request.setCharacterEncoding("UTF-8");
            dataMap = this.getRequestData(request);
            this.logger.info(this.getClass() + "-\u65b0\u5efa\u6d88\u606f\uff1a" + request.getParameter("data"));
            sendman = (String)dataMap.get("sendman");
            if (StringUtils.isBlank((String)sendman)) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u53d1\u9001\u4eba\u4e3a\u7a7a\u3002");
                returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u53d1\u9001\u4eba\u4e3a\u7a7a\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            List receivers = (List)dataMap.get("receiver");
            if (CollectionUtils.isEmpty((Collection)receivers)) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002");
                returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u63a5\u6536\u4eba\u4e3a\u7a7a\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            msgType = (String)dataMap.get("msgtype");
            if (StringUtils.isBlank((String)msgType)) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\u3002");
                returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            subject = (String)dataMap.get("subject");
            if (StringUtils.isBlank((String)subject)) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u4e3b\u9898\u4e3a\u7a7a\u3002");
                returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u4e3b\u9898\u4e3a\u7a7a\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            if (CommonUtils.getStrLength((String)subject) > 200) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u4e3b\u9898\u957f\u5ea6\u8d85\u51fa\u957f\u5ea6\uff08\u4e2d\u6587\u6700\u591a100\u5b57\uff09\u3002");
                returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u4e3b\u9898\u957f\u5ea6\u8d85\u51fa\u957f\u5ea6\uff08\u4e2d\u6587\u6700\u591a100\u5b57\uff09\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            content = (String)dataMap.get("content");
            if (StringUtils.isBlank((String)content)) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a\u3002");
                returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            if (CommonUtils.getStrLength((String)content) > 10000) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9\u957f\u5ea6\u8d85\u51fa\u957f\u5ea6\uff08\u4e2d\u6587\u6700\u591a5000\u5b57\uff09\u3002");
                returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9\u957f\u5ea6\u8d85\u51fa\u957f\u5ea6\uff08\u4e2d\u6587\u6700\u591a5000\u5b57\uff09\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            pmp.setChannel(new String[]{"sys"});
            String tenantId = this.getTenantId();
            if (StringUtils.isNotBlank((String)tenantId)) {
                pmp.setTenantid(tenantId);
            }
            pmp.setSendman(sendman);
            pmp.setRecevier(receivers.toArray(new String[receivers.size()]));
            pmp.setMsgtype(msgType);
            pmp.setSubject(subject);
            pmp.setContent(content);
            pmp.setQueueName("icop-messageCenter-queue");
            String jsonString = this.pushMsgService.pushMessage(pmp);
            Map respMap = (Map)mapper.readValue(jsonString, HashMap.class);
            if (null != respMap.get("success") && ((Boolean)respMap.get("success")).booleanValue()) {
                returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u6210\u529f");
                returnMap.put("status", 1);
            } else {
                returnMap.put("msg", "\u670d\u52a1\u5f02\u5e38\uff0c\u53d1\u9001\u6d88\u606f\u5931\u8d25");
                returnMap.put("status", 0);
            }
            return returnMap;
        }
        catch (Exception e) {
            returnMap.put("msg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u670d\u52a1\u5f02\u5e38\u3002");
            returnMap.put("status", 0);
            this.logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u670d\u52a1\u5f02\u5e38\u3002", (Throwable)e);
            return returnMap;
        }
    }

    @RequestMapping(value={"/messageInfo"})
    @ResponseBody
    public Map<String, Object> getMessage(@RequestParam(required=true, value="msgId") String messageId) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            UserMessageEntity ume = this.messageManageService.getById(messageId);
            ArrayList<UserMessageEntity> list = new ArrayList<UserMessageEntity>();
            list.add(ume);
            this.getMsgReceiverInfo(list);
            this.getMsgSenderInfo(list);
            returnMap.put("message", ume);
            returnMap.put("msg", "\u83b7\u53d6\u6d88\u606f\u6210\u529f\u3002");
            returnMap.put("status", 1);
            return returnMap;
        }
        catch (Exception e) {
            returnMap.put("msg", "\u670d\u52a1\u5f02\u5e38\uff0c\u67e5\u8be2\u6d88\u606f\u5931\u8d25\u3002");
            returnMap.put("status", 0);
            this.logger.error("\u670d\u52a1\u5f02\u5e38\uff0c\u67e5\u8be2\u6d88\u606f\u5931\u8d25\u3002", (Throwable)e);
            return returnMap;
        }
    }
}

