/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.message.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.uap.message.entity.MsgChannel;
import com.yonyou.uap.message.service.IMessageChannel;
import com.yonyou.uap.service.ISenderInfoFetch;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SenderInfoFetchByDB
implements ISenderInfoFetch {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMessageChannel messageChannel;

    public Map<String, Object> getSenderInfo(String channel) {
        Map<String, String> sendTypeInfoMap = null;
        MsgChannel msgChannel = this.messageChannel.queryMsgByCode(channel);
        if (msgChannel != null) {
            String sendType = msgChannel.getType();
            String configInfo = msgChannel.getConfiginfo();
            JSONObject jsonObject = JSONObject.fromObject((Object)configInfo);
            if (jsonObject != null) {
                sendTypeInfoMap = new HashMap<String, String>();
                if (sendType.equals("mail")) {
                    String userName = jsonObject.getString("userName");
                    String userPwd = jsonObject.getString("userPwd");
                    String hostName = jsonObject.getString("hostName");
                    sendTypeInfoMap.put("userName", userName);
                    sendTypeInfoMap.put("userPwd", userPwd);
                    sendTypeInfoMap.put("hostName", hostName);
                    sendTypeInfoMap.put("type", "mail");
                } else if (sendType.equals("messagepush")) {
                    String userName = jsonObject.getString("userName");
                    String userKey = jsonObject.getString("userKey");
                    String url = jsonObject.getString("url");
                    sendTypeInfoMap.put("userName", userName);
                    sendTypeInfoMap.put("userKey", userKey);
                    sendTypeInfoMap.put("url", url);
                    sendTypeInfoMap.put("type", "messagepush");
                } else if (sendType.equals("sms")) {
                    String corpId = jsonObject.getString("corpId");
                    String secretKey = jsonObject.getString("secretKey");
                    String url = jsonObject.getString("url");
                    sendTypeInfoMap.put("corpId", corpId);
                    sendTypeInfoMap.put("secretKey", secretKey);
                    sendTypeInfoMap.put("url", url);
                    sendTypeInfoMap.put("type", "sms");
                } else {
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        sendTypeInfoMap = (Map)mapper.readValue(jsonObject.toString(), Map.class);
                    }
                    catch (IOException e) {
                        this.logger.error("\u6d88\u606f\u901a\u9053\u53c2\u6570\u914d\u7f6e\u89e3\u6790\u9519\u8bef", (Throwable)e);
                    }
                    sendTypeInfoMap.put("type", sendType);
                }
            }
        }
        return sendTypeInfoMap;
    }
}

