/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.msg.template.service.impl;

import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import com.yonyou.uap.msg.template.dao.MsgTemplateMapper;
import com.yonyou.uap.msg.template.entity.MsgTemplateEntity;
import com.yonyou.uap.msg.template.service.IMsgTemplateService;
import com.yonyou.uap.msgtemplate.exception.MsgBusinessException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgTemplateServiceImpl
implements IMsgTemplateService {
    @Autowired
    private MsgTemplateMapper templateMapper;

    public MsgTemplateEntity queryMsgTemplateById(String id) throws MsgBusinessException {
        return this.templateMapper.queryMsgTemplateById(id);
    }

    public void save(MsgTemplateEntity msgTemplateEntity) throws MsgBusinessException {
        if (StringUtils.isEmpty((String)msgTemplateEntity.getId())) {
            msgTemplateEntity.setId(UUID.randomUUID().toString());
            String tenantid = InvocationInfoProxyAdapter.getTenantid();
            msgTemplateEntity.setTenantid(tenantid);
            this.templateMapper.insert(msgTemplateEntity);
        } else {
            this.templateMapper.update(msgTemplateEntity);
        }
    }

    public MsgTemplateEntity queryMsgTemplateByCode(String code) throws MsgBusinessException {
        String tenantid = InvocationInfoProxyAdapter.getTenantid();
        return this.templateMapper.queryMsgTemplateByCode(tenantid, code);
    }

    public List<MsgTemplateEntity> queryTempsBySearchMap(Map<String, Object> searchMap) throws MsgBusinessException {
        String tenantid = InvocationInfoProxyAdapter.getTenantid();
        if (StringUtils.isNotEmpty((String)tenantid)) {
            searchMap.put("tenantid", tenantid);
        }
        return this.templateMapper.queryTempsBySearchMap(searchMap);
    }

    public int queryMsgTempNumbers(Map<String, Object> searchMap) {
        String tenantid = InvocationInfoProxyAdapter.getTenantid();
        if (StringUtils.isNotEmpty((String)tenantid)) {
            searchMap.put("tenantid", tenantid);
        }
        return this.templateMapper.queryMsgTempNumbers(searchMap);
    }

    public void deleteById(String id) throws MsgBusinessException {
        this.templateMapper.delete(id);
    }
}

