
$(function(){
	var msgTemplate={
		titleFocus:null,
		id:1,
		data:{},
		busiObj:{}
	};
	
	var msgTemplateCode=$(".msg-template-code");
	var msgTemplateNote=$(".msg-template-note");
	var msgTemplateName=$(".msg-template-name");
	var msgTitle=$(".template-title-textarea");
	
	//根据tempId初始化界面，若是没有tempId，则打开一个空界面
	window.onload=function(){
		var locationpram=new UrlSearch(); //实例化
		var tempData={
			id:locationpram.id,
			tempgroup:locationpram.tempgroup

		};
		if(msgTemplate.id){
			$.ajax({
				type: "POST",
				url: "message/template/data",
				dataType: "json",
				async:false,
				data:{data:JSON.stringify(tempData)},
				success: function(data) {
					if(data.status==0){
						alert(data.msg);
						return;
					}
					var tempData = data.data.template;
					msgTemplate.busiObj = data.data.busiObj;
					if(!tempData || tempData==null){
						return;
					}
					msgTemplate.data = tempData;
					msgTemplateCode.val(msgTemplate.data.code);
					msgTemplateNote.val(msgTemplate.data.note);
					msgTemplateName.val(msgTemplate.data.name);
					msgTitle.val(msgTemplate.data.title);
					ue.addListener("ready", function () {
						ue.setContent(msgTemplate.data.data);
					});
				},
				error: function(data) {
					alert(data.msg);
				}
			});
		}
		$(".system-variables").addClass("system-variables-click");
	};
	
	//点击保存按钮
	$(document).on("click",".message-template-save",function(){
		var code=msgTemplateCode.val();
		var note=msgTemplateNote.val();
		var name=msgTemplateName.val();
		var title=msgTitle.val();

		var data=ue.getContent();

		
		var tempData={
			id:msgTemplate.id,
			template:{
				"code":code,
		        "name":name,
		        "title":title,
				"note":note,
		        "data":data,
				"tempgroup":msgTemplate.tempgroup
			}
		}
		$.ajax({
			type: "POST",
			url: "message/template/updateMsgTemplate",
			dataType: "json",
			data:{
				data:JSON.stringify(tempData)
				},
			success: function(data) {
				alert("数据保存成功!")
			},
			error: function(data) {
				alert("数据保存失败!");
			}
		})
	});
	
	//点击清除按钮
	$(document).on("click",".message-template-clear",function(){
		msgTemplateCode.val("");
		msgTemplateNote.val("");
		msgTemplateName.val("");
		msgTitle.val("");
		ue.addListener("ready", function () {
			ue.setContent("");
		});
	});
	
	//判断标题是否选中内容
	$(document).on("focus",".template-title-textarea",function(){
		msgTemplate.titleFocus = true;
	});
	
	$(document).on("dblclick",".system-variables-table .select",function(){
		var value = $(this).find(":nth-child(2)").text();
		if(msgTemplate.titleFocus){
			valueText = ' [' + value +'] ';
			$(".template-title-textarea").insert(valueText);
		}else{
			valueText = '<span style="color: rgb(0,0,0);"><strong> [' + value +'] </strong></span>';
			ue.execCommand('inserthtml',valueText);
		}
	});

	$(document).on("dblclick","#business-object-tree li a",function(){
		var value = $(this).find("span:last-child").attr("nodecode");
		
		if(msgTemplate.titleFocus){
			valueText = ' [' + value +'] ';
			$(".template-title-textarea").insert(valueText);
		}else{
			valueText = '<span style="color: rgb(0,0,0);"><strong> [' + value +'] </strong></span>';
			ue.execCommand('inserthtml',valueText);
		}

    });
	
	//给ueditor增加foucus监听
	ue.addListener("focus", function(type, event) {
		msgTemplate.titleFocus=false;
    });
	
	//给ueditor增加click监听
	ue.addListener("click", function(type, event){
		msgTemplate.selectVariableByClick();
	}); 

	//点击到变量上的时候，选中整个变量
	msgTemplate.selectVariableByClick=function(){

		var pattern = /\s\[(.)*\]\s/;
		var range = ue.selection.getRange();
		var str = range.startContainer.data;
		if(pattern.test(str)){
			range=range.selectNode(range.startContainer);
			range.adjustmentBoundary();
			range.select();
		}
	};
	
	//给ueditor增加keyup事件
	ue.addListener("keyup",function(type,event){
		msgTemplate.selectVariable()
	});
	
	//鼠标移动到变量上的时候，选中整个变量
	msgTemplate.selectVariable=function(){

		var pattern = /\s\[(.)*\]\s/;
		var range = ue.selection.getRange();
		var str = range.startContainer.data;
		if(pattern.test(str)){
			range=range.selectNode(range.startContainer);
			range.adjustmentBoundary();
			range.select();
		}
	};
	//点击系统变量页签
	$(document).on("click",".system-variables",function(){
		$(".system-variables").addClass("system-variables-click");
		$(".business-object").removeClass("business-object-click");

		$(".system-variables-table").show();
		$(".business-object-table").hide();
	});
	
	//点击业务对象页签
	$(document).on("click",".business-object",function(){
		$(".system-variables").removeClass("system-variables-click");
		$(".business-object").addClass("business-object-click");
		$(".business-object-table").show();
		$(".system-variables-table").hide();
	    var treeData = msgTemplate.busiObj;
		msgTemplate.initTreeModel(treeData); //初始化业务对象树
	});
	
	//初始化业务对象树
	msgTemplate.initTreeModel = function(treeData){
		var treeDom = $('#business-object-tree');
		var TimeFn=null;
        var nodeClick = function (event, treeId, treeNode) {
			//单击展开树
			clearTimeout(TimeFn); //setTimeout用来屏蔽连续2次单击变成单击事件
			TimeFn = setTimeout(function() {
				var zTree = $.fn.zTree.getZTreeObj("business-object-tree");
				zTree.expandNode(treeNode,null, false,false,false);
				//根节点增加样式
				$("#business-object-tree").find("li .root_open").siblings("a").find("span:first-child").addClass("rootTreenode");
				$("#business-object-tree").find("li .root_close").siblings("a").find("span:first-child").addClass("rootTreenode");
				$("#business-object-tree").find("li .roots_open").siblings("a").find("span:first-child").addClass("rootTreenode");
				$("#business-object-tree").find("li .roots_close").siblings("a").find("span:first-child").addClass("rootTreenode");
	        }, 200);
        }
		//树的双击事件
		var nodeDblClick = function (event, treeId, treeNode) {
			clearTimeout(TimeFn);
    	}
		
        var setting = {
                data: {
                    simpleData: {
                        enable: true,
                        idKey: "id",
                        pIdKey: "pid"
                    }
                },
                callback: {
					onDblClick: nodeDblClick,
                    onClick: nodeClick,
                    //onMouseDown: zTreeOnDrag//拖动选中节点
                },
                view: {
                	showLine: true,
                	showIcon: true,
                    selectedMulti: true,
					dblClickExpand: false //屏蔽双击展开事件
                }
            };
        function zTreeOnDrag(event, treeId, treeNodes) {
        	var zTree = $.fn.zTree.getZTreeObj("business-object-tree");
        	if(treeNodes!=null && treeNodes.pid!=null){//非根节点拖拽
	        	 zTree.selectNode(treeNodes);
        	}else{
        		//zTree.cancelSelectedNode();
        	}
        };
        $.fn.zTree.init(treeDom, setting, treeData);
        var zTree = $.fn.zTree.getZTreeObj("business-object-tree");
        var nodes;
		if(zTree){
			nodes = zTree.transformToArray(zTree.getNodes());
		}
		zTree.expandAll();
		zTree.expandNode(nodes[0],true, false,false,false);
		
		$.each(nodes, function(index, value) { 
			var nodeName = value.name;
			var nodepk = value.id;
			var pid = value.pid;
			var ctrlType = value.ctrltype;
			var nodeCode = value.code;
			var entityId = value.entityId;
			var itemPk = value.pk;
			var itemselectType = value.select_type;
			var itemselectOptions = "";
			//JSON.stringify(value.select_options) != "{}"
			if(typeof value.select_options !='undefined' && value.select_options.length>0){
				itemselectOptions = JSON.stringify(value.select_options);
			}
			
			if($("#business-object-tree").find("li a[title='"+nodeName+"'] span:last-child").length>1){
				var count = $("#business-object-tree").find("li a[title='"+nodeName+"'] span:last-child[titleflag='flag']").length;
				$($("#business-object-tree").find("li a[title='"+nodeName+"'] span:first-child")[count]).attr({"componentType":ctrlType});
				$($("#business-object-tree").find("li a[title='"+nodeName+"'] span:last-child")[count]).attr({"itemselectType":itemselectType,"itemselectOptions":itemselectOptions,"ctrlType":ctrlType,"nodepk":nodepk,"nodeName":nodeName,"nodeCode":nodeCode,"pid":pid,"entityId":entityId,"itemPk":itemPk,"titleflag":"flag"});
				$($("#business-object-tree").find("li a[title='"+nodeName+"']")[count]).parent().attr({"title":nodeName});
			}else{
				$("#business-object-tree").find("li a[title='"+nodeName+"'] span:first-child").attr({"componentType":ctrlType});
				$("#business-object-tree").find("li a[title='"+nodeName+"'] span:last-child").attr({"itemselectType":itemselectType,"itemselectOptions":itemselectOptions,"ctrlType":ctrlType,"nodepk":nodepk,"nodeName":nodeName,"nodeCode":nodeCode,"pid":pid,"entityId":entityId,"itemPk":itemPk});
				$("#business-object-tree").find("li a[title='"+nodeName+"']").parent().attr({"title":nodeName});
			}
		}); 
		//根节点增加样式
		$("#business-object-tree").find("li .root_open").siblings("a").find("span:first-child").addClass("rootTreenode");
		$("#business-object-tree").find("li .root_close").siblings("a").find("span:first-child").addClass("rootTreenode");
		$("#business-object-tree").find("li .roots_open").siblings("a").find("span:first-child").addClass("rootTreenode");
		$("#business-object-tree").find("li .roots_close").siblings("a").find("span:first-child").addClass("rootTreenode");
//		msgTemplate.componentDraggableEvents();		
	}	
		
	$(document).on("dragstart","#business-object-tree li a",function(ev){
		
	})
	
	//拖放功能
	msgTemplate.allowDrop = function(ev){
	    ev.preventDefault();
	};

	msgTemplate.drag = function(ev){
	    ev.dataTransfer.setData("Text",ev.target.id);
	};

	msgTemplate.drop = function(ev){
	    ev.preventDefault();
	    var data=ev.dataTransfer.getData("Text");
	    ev.target.appendChild(document.getElementById(data));
	};
	
/*	msgTemplate.getTemplateId = function(){
		var param = window.location.search.substr(1);
//		var index = param.indexOf('=');
//		var name = param.substring(0,index);
//		var value = param.substring(index+1);//提取value
		return param;
	}*/

	function UrlSearch()
	{
		var name,value;
		var str=location.href; //取得整个地址栏
		var num=str.indexOf("?");
		str=str.substr(num+1); //取得所有参数

		var arr=str.split("&"); //各个参数放到数组里
		for(var i=0;i < arr.length;i++){
			num=arr[i].indexOf("=");
			if(num>0){
				name=arr[i].substring(0,num);
				value=arr[i].substr(num+1);
				this[name]=value;
			}
		}
	}


})