/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.message.center.filter;

import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import com.yonyou.iuap.security.rest.utils.PostParamsHelper;
import com.yonyou.iuap.security.rest.utils.SignPropGenerator;
import com.yonyou.message.center.filter.MessageSendFilter;
import java.net.MalformedURLException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSendFilter
extends AccessControlFilter {
    private static final long DEFAULT_EXPIRED = 3000000L;
    private Logger logger = LoggerFactory.getLogger(MessageSendFilter.class);

    protected boolean isAccessAllowed(ServletRequest paramServletRequest, ServletResponse paramServletResponse, Object paramObject) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest paramServletRequest, ServletResponse paramServletResponse) throws Exception {
        if (paramServletRequest instanceof HttpServletRequest) {
            boolean passed;
            HttpServletRequest httpReq = (HttpServletRequest)paramServletRequest;
            String sign = httpReq.getHeader("sign");
            String appid = httpReq.getHeader("appId");
            if (StringUtils.isEmpty((String)sign)) {
                sign = httpReq.getParameter("sign");
            }
            if (StringUtils.isEmpty((String)appid)) {
                appid = httpReq.getParameter("appId");
            }
            if (sign == null || appid == null) {
                HttpServletResponse rp = (HttpServletResponse)paramServletResponse;
                rp.setStatus(400);
                rp.addHeader("Send event message validate error", " 400 , method not allowed, please check called paramaters !");
                rp.getWriter().write("Method not allowed, please check called paramaters !");
                return false;
            }
            String ts = httpReq.getParameter("ts");
            if (StringUtils.isNumeric((String)ts)) {
                long sendTs = Long.parseLong(ts);
                if (System.currentTimeMillis() - sendTs > 3000000L) {
                    HttpServletResponse resp = (HttpServletResponse)paramServletResponse;
                    resp.setStatus(400);
                    resp.addHeader("send message validate error", " 400 ,\u8bf7\u6c42\u8d85\u65f6");
                    resp.getWriter().write(" over time");
                    return false;
                }
            }
            if (!(passed = this.ValidatorUrl(httpReq))) {
                HttpServletResponse rp = (HttpServletResponse)paramServletResponse;
                rp.setStatus(400);
                rp.addHeader("Send event message validate error", " 400 , method not allowed, please check called paramaters !");
                rp.getWriter().write("Method not allowed, please check called paramaters !");
                return false;
            }
            return passed;
        }
        return false;
    }

    private boolean ValidatorUrl(HttpServletRequest httpReq) {
        String sign = httpReq.getHeader("sign");
        String appid = httpReq.getHeader("appId");
        if (StringUtils.isEmpty((String)sign)) {
            sign = httpReq.getParameter("sign");
        }
        if (StringUtils.isEmpty((String)appid)) {
            appid = httpReq.getParameter("appId");
        }
        if (StringUtils.isNotEmpty((String)sign) && StringUtils.isNotEmpty((String)appid)) {
            try {
                String url = httpReq.getRequestURL().toString();
                if (StringUtils.isNotBlank((String)httpReq.getQueryString())) {
                    url = String.valueOf(url) + "?" + httpReq.getQueryString();
                }
                String paramterStr = PostParamsHelper.genParamsStrByReqeust((HttpServletRequest)httpReq);
                SignProp prop = SignPropGenerator.genSignProp((String)url);
                prop.setPostParamsStr(paramterStr);
                prop.setContentLength((long)httpReq.getContentLength());
                MsgServerVirifyFactory factory = new MsgServerVirifyFactory(this);
                return factory.getVerifier(appid).verify(sign, prop);
            }
            catch (UAPSecurityException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (MalformedURLException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
            }
        }
        return false;
    }

    static /* synthetic */ Logger access$0(MessageSendFilter messageSendFilter) {
        return messageSendFilter.logger;
    }
}

