/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.message.center.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import com.yonyou.message.center.service.MsgPersisrenceSdk;
import com.yonyou.uap.entity.content.MessageContent;
import com.yonyou.uap.entity.receiver.MessageReceiver;
import com.yonyou.uap.entity.response.MessageResponse;
import com.yonyou.uap.exception.MessageSendException;
import com.yonyou.uap.message.entity.MsgChannel;
import com.yonyou.uap.message.service.IMessageChannel;
import com.yonyou.uap.message.utils.WebPushUtil;
import com.yonyou.uap.msg.persistence.service.IMessageService;
import com.yonyou.uap.msg.persistence.service.IUserInfoService;
import com.yonyou.uap.msg.template.entity.MessageEntity;
import com.yonyou.uap.msg.template.service.IMsgTemplateCreate;
import com.yonyou.uap.msg.template.service.IMsgTemplateDataSource;
import com.yonyou.uap.msg.template.service.impl.MsgTemplateDefaultBusiVarImpl;
import com.yonyou.uap.service.MessageSend;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageSendSdk {
    private static final Logger logger = LoggerFactory.getLogger(MessageSendSdk.class);
    @Autowired
    private IMsgTemplateCreate msgTemplateCreate;
    @Autowired
    private MsgPersisrenceSdk msgPersistenceSdk;
    @Autowired
    private IUserInfoService userInfoService;
    @Autowired
    private IMessageChannel msgChannelService;
    @Autowired
    private IMessageService msgService;

    public Map<String, Object> pushTemplateMessage(String jsonString) {
        Map<String, Object> returnMap = new HashMap<String, Object>();
        Map dataMap = null;
        String templateCode = null;
        try {
            dataMap = (Map)new ObjectMapper().readValue(jsonString, HashMap.class);
        }
        catch (IOException e) {
            logger.error("JSON\u8f6c\u6362\u6210Map\u65f6\u51fa\u9519\uff0cjsonString : " + jsonString, (Throwable)e);
            returnMap.put("msg", "\u4f20\u5165\u7684\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u662f\u4e00\u4e2a\u6807\u51c6\u7684JSON\u5b57\u7b26\u4e32\u3002Parameter : " + jsonString);
            returnMap.put("status", 0);
            return returnMap;
        }
        try {
            templateCode = dataMap.get("templateCode").toString();
        }
        catch (NullPointerException e) {
            logger.error("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570", (Throwable)e);
            returnMap.put("msg", "\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\u3002Parameter : " + jsonString);
            returnMap.put("status", 0);
            return returnMap;
        }
        MessageEntity msgEntity = null;
        try {
            Map busiDataMap = (Map)dataMap.get("busiData");
            msgEntity = this.msgTemplateCreate.createMessageByCode(templateCode, (IMsgTemplateDataSource)new MsgTemplateDefaultBusiVarImpl(busiDataMap));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6d88\u606f\u5b9e\u4f53\u5931\u8d25", (Throwable)e);
            returnMap.put("msg", "\u521b\u5efa\u6d88\u606f\u5b9e\u4f53\u5931\u8d25\u3002busiData : " + dataMap.get("busiData"));
            returnMap.put("status", 0);
            return returnMap;
        }
        MessageContent msgContent = new MessageContent(msgEntity.getMsgTitle(), (Object)msgEntity.getMsgContent(), dataMap);
        dataMap.put("subject", msgContent.getTitle());
        dataMap.put("content", msgContent.getContent());
        String tenantId = this.getTenantId();
        if (StringUtils.isNotBlank((String)tenantId)) {
            dataMap.put("tenantid", tenantId);
        }
        returnMap = this.sendAndSaveMessage(dataMap, msgContent);
        return returnMap;
    }

    public Map<String, Object> pushTextMessage(String jsonString) {
        Map<String, Object> returnMap = new HashMap<String, Object>();
        Map dataMap = null;
        String subject = null;
        String content = null;
        try {
            dataMap = (Map)new ObjectMapper().readValue(jsonString, HashMap.class);
        }
        catch (IOException e) {
            logger.error("JSON\u8f6c\u6362\u6210Map\u65f6\u51fa\u9519\uff0cjsonString : " + jsonString, (Throwable)e);
            returnMap.put("msg", "\u4f20\u5165\u7684\u53c2\u6570\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u662f\u4e00\u4e2a\u6807\u51c6\u7684JSON\u5b57\u7b26\u4e32\u3002Parameter : " + jsonString);
            returnMap.put("status", 0);
            return returnMap;
        }
        try {
            subject = dataMap.get("subject").toString();
            content = dataMap.get("content").toString();
        }
        catch (NullPointerException e) {
            logger.error("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570", (Throwable)e);
            returnMap.put("msg", "\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\u3002Parameter : " + jsonString);
            returnMap.put("status", 0);
            return returnMap;
        }
        MessageContent msgContent = new MessageContent(subject, (Object)content, dataMap);
        String tenantId = this.getTenantId();
        if (StringUtils.isNotBlank((String)tenantId)) {
            dataMap.put("tenantid", tenantId);
        }
        returnMap = this.sendAndSaveMessage(dataMap, msgContent);
        return returnMap;
    }

    private Map<String, Object> sendAndSaveMessage(Map<String, Object> dataMap, MessageContent msgContent) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List channelCodeList = (List)dataMap.get("channel");
        List channelList = this.msgChannelService.queryMsgChannelByCodes(channelCodeList);
        ArrayList receiversArr = (ArrayList)dataMap.get("recevier");
        Boolean isOnlySys = true;
        for (String str : channelCodeList) {
            if ("sys".equals(str)) continue;
            isOnlySys = false;
        }
        Map map = null;
        if (receiversArr != null && receiversArr.size() > 0) {
            List allReceiver = this.mergeAllReceiver(receiversArr, dataMap);
            try {
                map = this.userInfoService.getUserMobileEmailMap(allReceiver.toArray(new String[0]));
                Map userMobileMap = (Map)map.get("userMobileMap");
                Map userEmailMap = (Map)map.get("userEmailMap");
                Map userCodeMap = (Map)map.get("userCodeMap");
                dataMap.put("userCodeMap", userCodeMap);
                dataMap.put("userMobileMap", userMobileMap);
                dataMap.put("userEmailMap", userEmailMap);
            }
            catch (Throwable e) {
                logger.error("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5f02\u5e38", e);
                if (!isOnlySys.booleanValue()) {
                    e.printStackTrace();
                }
            }
        } else {
            dataMap.put("recevier", new ArrayList());
            dataMap.put("userMobileMap", new HashMap());
            dataMap.put("userEmailMap", new HashMap());
        }
        String messageId = this.msgPersistenceSdk.saveMessage(dataMap);
        ArrayList responseAllList = new ArrayList();
        for (MsgChannel msgChannel : channelList) {
            this.msgPersistenceSdk.saveReceivers(messageId, msgChannel.getType(), dataMap);
            if (!"sys".equals(msgChannel.getType())) {
                Map emailUserMap;
                String receiversStr = this.buildReceiverString(msgChannel, receiversArr, map, dataMap);
                MessageReceiver msgReceiver = new MessageReceiver(receiversStr);
                List responseList = null;
                try {
                    responseList = new MessageSend(msgReceiver, msgContent, msgChannel.getCode()).send();
                }
                catch (MessageSendException e) {
                    logger.error("\u6d88\u606f\u53d1\u9001\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
                    returnMap.put("msg", "\u6d88\u606f\u53d1\u9001\u65f6\u53d1\u751f\u5f02\u5e38\u3002");
                    returnMap.put("status", 0);
                    return returnMap;
                }
                List receiverList = new ArrayList();
                if ("mail".equals(msgChannel.getType()) && map != null && (receiverList = this.buildUserList(responseList, emailUserMap = (Map)map.get("emailUserMap"))) != null && receiverList.size() > 0) {
                    receiverList = this.buildMailUserList(receiverList, dataMap);
                }
                if ("sms".equals(msgChannel.getType()) && map != null) {
                    Map mobileUserMap = (Map)map.get("mobileUserMap");
                    receiverList = this.buildUserList(responseList, mobileUserMap);
                }
                if (receiverList != null && receiverList.size() > 0) {
                    this.msgPersistenceSdk.updateRecevierStatus(receiverList, messageId, "0");
                }
                List transResponseList = this.transLateResponse(responseList, msgChannel);
                responseAllList.addAll(transResponseList);
                continue;
            }
            String params = this.buildParams(dataMap);
            try {
                if (params == null) continue;
                WebPushUtil.webPush((String)params);
                returnMap.put("webpushMsg", "\u6d88\u606f\u63a8\u9001\u6210\u529f");
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                returnMap.put("webpushMsg", "\u6d88\u606f\u63a8\u9001\u5931\u8d25");
            }
        }
        returnMap.put("msgList", responseAllList);
        int status = this.calculateStatusByResponse(responseAllList);
        returnMap.put("status", status);
        String msg = null;
        msg = status == 0 ? "\u6d88\u606f\u53d1\u9001\u5931\u8d25" : (status == 1 ? "\u6d88\u606f\u53d1\u9001\u6210\u529f" : "\u6d88\u606f\u53d1\u9001\u90e8\u5206\u6210\u529f");
        returnMap.put("msg", msg);
        return returnMap;
    }

    private List<MessageResponse> transLateResponse(List<MessageResponse> responseList, MsgChannel msgChannel) {
        ArrayList<MessageResponse> list = new ArrayList<MessageResponse>();
        for (MessageResponse msgResponse : responseList) {
            String code = msgResponse.getResponseStatusCode();
            if ("mail".equals(msgChannel.getType()) || "sms".equals(msgChannel.getType())) {
                if ("0".equals(msgResponse.getResponseStatusCode())) {
                    code = "1";
                } else if ("1".equals(msgResponse.getResponseStatusCode())) {
                    code = "0";
                }
            }
            String content = msgResponse.getResponseContent();
            MessageResponse response = new MessageResponse(code, content);
            response.setReceiver(msgResponse.getReceiver());
            list.add(response);
        }
        return list;
    }

    private int calculateStatusByResponse(List<MessageResponse> responseAllList) {
        int status = 1;
        boolean hasSuccess = false;
        boolean hasFailed = false;
        boolean allSuccess = true;
        int successCount = 0;
        for (MessageResponse msgResponse : responseAllList) {
            if ("1".equals(msgResponse.getResponseStatusCode())) {
                hasSuccess = true;
                ++successCount;
                continue;
            }
            hasFailed = true;
        }
        if (successCount != responseAllList.size()) {
            allSuccess = false;
        }
        status = allSuccess ? 1 : (hasSuccess && hasFailed ? 2 : 0);
        return status;
    }

    private List<String> buildMailUserList(List<String> receiverList, Map<String, Object> dataMap) {
        List mailCcReceiver = (List)dataMap.get("mailCcIds");
        List mailBccReceiver = (List)dataMap.get("mailBccIds");
        if (mailCcReceiver != null && mailCcReceiver.size() > 0 && mailBccReceiver != null && mailBccReceiver.size() > 0) {
            mailCcReceiver.removeAll(mailBccReceiver);
        }
        if (mailCcReceiver != null && mailCcReceiver.size() > 0) {
            for (String receiver : mailCcReceiver) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)receiver)) continue;
                receiverList.add(receiver);
            }
        }
        if (mailBccReceiver != null && mailBccReceiver.size() > 0) {
            for (String receiver : mailBccReceiver) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)receiver)) continue;
                receiverList.add(receiver);
            }
        }
        String mailCcAddressReceiver = (String)dataMap.get("mailCc");
        String mailBccAddressReceiver = (String)dataMap.get("mailBcc");
        List<Object> mailCcAddressList = new ArrayList();
        List<Object> mailBccAddressList = new ArrayList();
        if (StringUtils.isNotBlank((String)mailCcAddressReceiver)) {
            mailCcAddressList = Arrays.asList(mailCcAddressReceiver.split(","));
        }
        if (StringUtils.isNotBlank((String)mailBccAddressReceiver)) {
            mailBccAddressList = Arrays.asList(mailBccAddressReceiver.split(","));
        }
        if (mailCcAddressList != null && mailCcAddressList.size() > 0 && mailBccAddressList != null && mailBccAddressList.size() > 0) {
            mailCcAddressList.removeAll(mailBccAddressList);
        }
        if (mailCcAddressList != null && mailCcAddressList.size() > 0) {
            for (String string : mailCcAddressList) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)string)) continue;
                receiverList.add(string);
            }
        }
        if (mailBccAddressList != null && mailBccAddressList.size() > 0) {
            for (String string : mailBccAddressList) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)string)) continue;
                receiverList.add(string);
            }
        }
        return receiverList;
    }

    private List<String> mergeAllReceiver(ArrayList<String> receiversArr, Map<String, Object> dataMap) {
        ArrayList<String> allReceiverList = new ArrayList<String>();
        List mailCcReceiver = (List)dataMap.get("mailCcIds");
        List mailBccReceiver = (List)dataMap.get("mailBccIds");
        if (receiversArr != null && receiversArr.size() > 0) {
            for (String receiver : receiversArr) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)receiver) || allReceiverList.contains(receiver)) continue;
                allReceiverList.add(receiver);
            }
        }
        if (mailCcReceiver != null && mailCcReceiver.size() > 0) {
            for (String receiver : mailCcReceiver) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)receiver) || allReceiverList.contains(receiver)) continue;
                allReceiverList.add(receiver);
            }
        }
        if (mailBccReceiver != null && mailBccReceiver.size() > 0) {
            for (String receiver : mailBccReceiver) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)receiver) || allReceiverList.contains(receiver)) continue;
                allReceiverList.add(receiver);
            }
        }
        return allReceiverList;
    }

    private String buildParams(Map<String, Object> dataMap) {
        Object tenantIdObj = dataMap.get("tenantid");
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        String tenantid = null;
        if (tenantIdObj != null) {
            tenantid = String.valueOf(tenantIdObj);
            searchMap.put("tenantid", tenantid);
        }
        ArrayList<String> userKeys = new ArrayList<String>();
        ArrayList<String> receiverList = new ArrayList<String>();
        ArrayList receiversArr = (ArrayList)dataMap.get("recevier");
        for (String receiver : receiversArr) {
            userKeys.add(String.valueOf(tenantid) + "_" + receiver);
            receiverList.add(receiver);
        }
        searchMap.put("receiverList", receiverList);
        if (userKeys.size() > 0) {
            List unreadMsgNumMap = this.msgService.getUnReadMsgNumBatch(searchMap);
            HashMap<String, Integer> receiverMap = new HashMap<String, Integer>();
            if (unreadMsgNumMap != null) {
                for (Map msgNumMap : unreadMsgNumMap) {
                    String receiver = (String)msgNumMap.get("receiver");
                    int count = Integer.valueOf(String.valueOf(msgNumMap.get("count")));
                    receiverMap.put(String.valueOf(tenantid) + "_" + receiver, count);
                }
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("identity", "server1001");
            paramMap.put("userkeys", userKeys);
            paramMap.put("message", receiverMap);
            JSONObject jsonObj = JSONObject.fromObject(paramMap);
            String params = jsonObj.toString();
            return params;
        }
        return null;
    }

    private List<String> buildUserList(List<MessageResponse> responseList, Map<String, String> userMap) {
        ArrayList<String> receiverList = new ArrayList<String>();
        for (MessageResponse msgResponse : responseList) {
            String address;
            if ("0".equals(msgResponse.getResponseStatusCode()) || !StringUtils.isNotBlank((String)(address = msgResponse.getReceiver()))) continue;
            String userId = userMap.get(address);
            if (StringUtils.isNotBlank((String)userId)) {
                receiverList.add(userId);
                continue;
            }
            receiverList.add(address);
        }
        return receiverList;
    }

    private String buildReceiverString(MsgChannel msgChannel, ArrayList<String> receiversArr, Map<String, Map<String, String>> map, Map<String, Object> params) {
        ArrayList externalReceiver;
        String channelType = msgChannel.getType();
        Map<String, String> mapUserInfo = null;
        if ("mail".equals(channelType)) {
            if (map != null) {
                mapUserInfo = map.get("userEmailMap");
            }
        } else if ("sms".equals(channelType)) {
            if (map != null) {
                mapUserInfo = map.get("userMobileMap");
            }
        } else {
            if (receiversArr != null && receiversArr.size() > 0) {
                return StringUtils.join(receiversArr, (String)",");
            }
            return null;
        }
        if ((externalReceiver = (ArrayList)params.get(String.valueOf(channelType) + "Receiver")) == null) {
            externalReceiver = new ArrayList();
        }
        if (mapUserInfo == null) {
            if (externalReceiver.size() == 0) {
                return null;
            }
            return StringUtils.join(externalReceiver, (String)",");
        }
        ArrayList<String> sysReceiver = new ArrayList<String>();
        int i = 0;
        while (i < receiversArr.size()) {
            String email = mapUserInfo.get(receiversArr.get(i));
            if (!StringUtils.isBlank((String)email)) {
                sysReceiver.add(email);
            }
            ++i;
        }
        externalReceiver.removeAll(sysReceiver);
        if (externalReceiver != null && externalReceiver.size() > 0) {
            for (String receiver : externalReceiver) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)receiver)) continue;
                sysReceiver.add(receiver);
            }
        }
        return StringUtils.join(sysReceiver, (String)",");
    }

    private String getTenantId() {
        String tenantId = null;
        if (StringUtils.isEmpty(tenantId)) {
            tenantId = InvocationInfoProxyAdapter.getTenantid();
        }
        return tenantId;
    }
}

