/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.message.center.service;

import com.yonyou.uap.msg.persistence.entity.MessageEntity;
import com.yonyou.uap.msg.persistence.entity.MsgReceiverEntity;
import com.yonyou.uap.msg.persistence.entity.OtherMsgReceiverEntity;
import com.yonyou.uap.msg.persistence.entity.UnReadMsgReceiverEntity;
import com.yonyou.uap.msg.persistence.sdk.MessageServiceSdk;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgPersisrenceSdk {
    @Autowired
    private MessageServiceSdk messageServiceSdk;

    public String saveMessage(Map<String, Object> dataMap) {
        String messageId = UUID.randomUUID().toString();
        MessageEntity msgEntity = this.buildMsgEntity(messageId, dataMap);
        this.messageServiceSdk.saveMessage(msgEntity);
        return messageId;
    }

    public String saveReceivers(String messageId, String channel, Map<String, Object> dataMap) {
        List msgReceiverList = this.buildMsgReceiver(messageId, channel, dataMap);
        if (channel != null && channel.equals("sys")) {
            List unReadMsgReceiverList = this.buildUnReadMsgReceiver(msgReceiverList);
            this.messageServiceSdk.saveWebMessage(msgReceiverList, unReadMsgReceiverList);
        } else {
            List otherMsgReceiverList = new ArrayList();
            otherMsgReceiverList = channel != null && channel.equals("mail") ? this.bulidAllOtherReceiver(messageId, channel, dataMap) : this.buildOtherReceiver(msgReceiverList);
            this.messageServiceSdk.saveOtherReadMessage(otherMsgReceiverList);
        }
        return messageId;
    }

    private List<OtherMsgReceiverEntity> bulidAllOtherReceiver(String messageId, String channel, Map<String, Object> dataMap) {
        List otherMsgReceiverList = this.buildMailRecevier("mailReceiver", "recevier", messageId, channel, dataMap);
        List mailCcReceiverList = this.buildMailRecevier("mailCc", "mailCcIds", messageId, channel, dataMap);
        List mailBccReceiverList = this.buildMailRecevier("mailBcc", "mailBccIds", messageId, channel, dataMap);
        ArrayList<OtherMsgReceiverEntity> allReceiver = new ArrayList<OtherMsgReceiverEntity>();
        allReceiver.addAll(otherMsgReceiverList);
        allReceiver.addAll(mailCcReceiverList);
        allReceiver.addAll(mailBccReceiverList);
        return allReceiver;
    }

    private List<OtherMsgReceiverEntity> buildMailRecevier(String mailAddress, String mailIds, String messageId, String channel, Map<String, Object> dataMap) {
        OtherMsgReceiverEntity receiverEntity;
        List receiversArr = (List)dataMap.get(mailIds);
        Map userEmailMap = (Map)dataMap.get("userEmailMap");
        List receiverAddressList = this.buildMailReceiverAddress(mailAddress, dataMap);
        ArrayList<OtherMsgReceiverEntity> msgReceiverList = new ArrayList<OtherMsgReceiverEntity>();
        if (receiversArr != null && receiversArr.size() > 0) {
            for (String receiver : receiversArr) {
                if (StringUtils.isBlank((String)receiver)) continue;
                receiverEntity = this.createOtherMsgReceiver(mailAddress, mailIds, receiver, messageId, channel, userEmailMap);
                msgReceiverList.add(receiverEntity);
            }
        }
        if (receiverAddressList != null && receiverAddressList.size() > 0) {
            for (String receiver : receiverAddressList) {
                if (StringUtils.isBlank((String)receiver)) continue;
                receiverEntity = this.createOtherMsgReceiver(mailAddress, mailIds, receiver, messageId, channel, userEmailMap);
                receiverEntity.setStatus("1");
                msgReceiverList.add(receiverEntity);
            }
        }
        return msgReceiverList;
    }

    private List<String> buildMailReceiverAddress(String mailAddress, Map<String, Object> dataMap) {
        List<Object> receiverAddressList = new ArrayList();
        if ("mailReceiver".equals(mailAddress)) {
            receiverAddressList = (List)dataMap.get("mailReceiver");
        } else {
            String[] address;
            String receiverAddress = (String)dataMap.get(mailAddress);
            if (!org.springframework.util.StringUtils.isEmpty((Object)receiverAddress) && (address = receiverAddress.split(",")) != null && address.length > 0) {
                receiverAddressList = Arrays.asList(address);
            }
        }
        return receiverAddressList;
    }

    private OtherMsgReceiverEntity createOtherMsgReceiver(String mailAddress, String mailIds, String receiver, String messageId, String channel, Map<String, String> userEmailMap) {
        OtherMsgReceiverEntity receiverEntity = new OtherMsgReceiverEntity();
        receiverEntity.setId(UUID.randomUUID().toString());
        receiverEntity.setReceiver(receiver);
        if (!org.springframework.util.StringUtils.isEmpty((Object)channel)) {
            receiverEntity.setMsgchannel(channel);
            String email = userEmailMap.get(receiver);
            if (org.springframework.util.StringUtils.isEmpty((Object)email)) {
                receiverEntity.setAddress(receiver);
                receiverEntity.setStatus("0");
            } else {
                receiverEntity.setAddress(email);
                receiverEntity.setStatus("1");
            }
        }
        if ("mailReceiver".equals(mailAddress)) {
            receiverEntity.setReceivertype("mailReceiver");
        } else if ("mailCc".equals(mailAddress)) {
            receiverEntity.setReceivertype("mailCc");
        } else if ("mailBcc".equals(mailAddress)) {
            receiverEntity.setReceivertype("mailBcc");
        }
        receiverEntity.setMsgid(messageId);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        receiverEntity.setTs(dataFormat.format(new Date()));
        return receiverEntity;
    }

    public void updateRecevierStatus(List<String> receiverList, String message, String status) {
        this.messageServiceSdk.updateRecevierStatus(receiverList, message, status);
    }

    private List<OtherMsgReceiverEntity> buildOtherReceiver(List<MsgReceiverEntity> msgReceiverList) {
        ArrayList<OtherMsgReceiverEntity> otherMsgReceiverList = new ArrayList<OtherMsgReceiverEntity>();
        for (MsgReceiverEntity receiver : msgReceiverList) {
            OtherMsgReceiverEntity otherReceiver = new OtherMsgReceiverEntity();
            otherReceiver.setId(receiver.getId());
            otherReceiver.setReceiver(receiver.getReceiver());
            otherReceiver.setAddress(receiver.getAddress());
            otherReceiver.setMsgchannel(receiver.getMsgchannel());
            if (StringUtils.isBlank((String)receiver.getAddress()) && ("mail".equals(receiver.getMsgchannel()) || "sms".equals(receiver.getMsgchannel()))) {
                otherReceiver.setStatus("0");
            } else {
                otherReceiver.setStatus("1");
            }
            if ("mail".equals(receiver.getMsgchannel())) {
                otherReceiver.setReceivertype("mail");
            }
            otherReceiver.setMsgid(receiver.getMsgid());
            otherReceiver.setTs(receiver.getTs());
            otherMsgReceiverList.add(otherReceiver);
        }
        return otherMsgReceiverList;
    }

    private List<UnReadMsgReceiverEntity> buildUnReadMsgReceiver(List<MsgReceiverEntity> msgReceiverList) {
        ArrayList<UnReadMsgReceiverEntity> unReadMsgReceiverList = new ArrayList<UnReadMsgReceiverEntity>();
        for (MsgReceiverEntity receiver : msgReceiverList) {
            UnReadMsgReceiverEntity unReadReceiver = new UnReadMsgReceiverEntity();
            unReadReceiver.setId(receiver.getId());
            unReadReceiver.setReceiver(receiver.getReceiver());
            unReadReceiver.setAddress(receiver.getAddress());
            unReadReceiver.setMsgchannel(receiver.getMsgchannel());
            unReadReceiver.setStatus(receiver.getStatus());
            unReadReceiver.setMsgid(receiver.getMsgid());
            unReadReceiver.setTs(receiver.getTs());
            unReadMsgReceiverList.add(unReadReceiver);
        }
        return unReadMsgReceiverList;
    }

    private MessageEntity buildMsgEntity(String messageId, Map<String, Object> dataMap) {
        Object exdetail03;
        Object exdetail02;
        Object exdetail01;
        Object exstatus03;
        Object exstatus02;
        Object exstatus01;
        Object busitype;
        Object billid;
        Object msgtype;
        Object sendman;
        Object content;
        MessageEntity msgEntity = new MessageEntity();
        msgEntity.setId(messageId);
        Object subject = dataMap.get("subject");
        if (!org.springframework.util.StringUtils.isEmpty((Object)subject)) {
            msgEntity.setSubject(String.valueOf(subject));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(content = dataMap.get("content")))) {
            msgEntity.setContent(String.valueOf(content));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(sendman = dataMap.get("sendman")))) {
            msgEntity.setSender(String.valueOf(sendman));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(msgtype = dataMap.get("msgtype")))) {
            msgEntity.setMsgtype(String.valueOf(msgtype));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(billid = dataMap.get("billid")))) {
            msgEntity.setBillid(String.valueOf(billid));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(busitype = dataMap.get("busitype")))) {
            msgEntity.setBusitype(String.valueOf(busitype));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(exstatus01 = dataMap.get("exstatus01")))) {
            msgEntity.setExstatus01(String.valueOf(exstatus01));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(exstatus02 = dataMap.get("exstatus02")))) {
            msgEntity.setExstatus02(String.valueOf(exstatus02));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(exstatus03 = dataMap.get("exstatus03")))) {
            msgEntity.setExstatus03(String.valueOf(exstatus03));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(exdetail01 = dataMap.get("exdetail01")))) {
            msgEntity.setExdetail01(String.valueOf(exdetail01));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(exdetail02 = dataMap.get("exdetail02")))) {
            msgEntity.setExdetail02(String.valueOf(exdetail02));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)(exdetail03 = dataMap.get("exdetail03")))) {
            msgEntity.setExdetail03(String.valueOf(exdetail03));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        msgEntity.setSendtime(dateFormat.format(new Date()));
        return msgEntity;
    }

    private List<MsgReceiverEntity> buildMsgReceiver(String messageId, String channel, Map<String, Object> dataMap) {
        List msgReceiverList = new ArrayList();
        msgReceiverList = !org.springframework.util.StringUtils.isEmpty((Object)channel) && channel.equals("sys") ? this.buildReceiverEntity(messageId, channel, true, dataMap) : this.buildReceiverEntity(messageId, channel, false, dataMap);
        return msgReceiverList;
    }

    private List<MsgReceiverEntity> buildReceiverEntity(String messageId, String channel, boolean isWeb, Map<String, Object> dataMap) {
        ArrayList receiversArr = (ArrayList)dataMap.get("recevier");
        Map userEmailMap = (Map)dataMap.get("userEmailMap");
        Map userMobileMap = (Map)dataMap.get("userMobileMap");
        ArrayList<MsgReceiverEntity> msgReceiverList = new ArrayList<MsgReceiverEntity>();
        for (String receiver : receiversArr) {
            MsgReceiverEntity receiverEntity = new MsgReceiverEntity();
            receiverEntity.setId(UUID.randomUUID().toString());
            receiverEntity.setReceiver(receiver);
            if (!org.springframework.util.StringUtils.isEmpty((Object)channel)) {
                receiverEntity.setMsgchannel(channel);
                if (channel.equals("mail")) {
                    String email = (String)userEmailMap.get(receiver);
                    if (org.springframework.util.StringUtils.isEmpty((Object)email)) {
                        receiverEntity.setAddress(receiver);
                    } else {
                        receiverEntity.setAddress(email);
                    }
                } else if (channel.equals("sms")) {
                    String mobile = (String)userMobileMap.get(receiver);
                    if (org.springframework.util.StringUtils.isEmpty((Object)mobile)) {
                        receiverEntity.setAddress(receiver);
                    } else {
                        receiverEntity.setAddress(mobile);
                    }
                }
            }
            receiverEntity.setMsgid(messageId);
            if (isWeb) {
                receiverEntity.setStatus("0");
            } else {
                receiverEntity.setStatus("1");
            }
            SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            receiverEntity.setTs(dataFormat.format(new Date()));
            msgReceiverList.add(receiverEntity);
        }
        return msgReceiverList;
    }
}

