/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.sms.action;

import com.google.gson.Gson;
import com.yonyou.sms.model.content.SMSContent;
import com.yonyou.sms.model.receiver.SMSReceiver;
import com.yonyou.sms.util.MessageContent;
import com.yonyou.sms.util.MessageReceiver;
import com.yonyou.sms.util.MessageResponse;
import com.yonyou.sms.util.MessageSend;
import com.yonyou.sms.util.ProduceNumber;
import com.yonyou.sms.util.Validate;
import com.yyjz.icop.base.response.ObjectResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springside.modules.nosql.redis.JedisTemplate;

@Controller
@RequestMapping(value={"/sms"})
public class SmsController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisTemplate jedis;

    @RequestMapping(value={"checkMessage"}, method={RequestMethod.POST})
    @ResponseBody
    public Object CheckMessage(@RequestBody(required=false) String param) {
        this.logger.debug("\u4f20\u8f93param\uff1a{}", (Object)param);
        ObjectResponse objectResponse = new ObjectResponse();
        try {
            Gson gson = new Gson();
            Map paramMap = (Map)gson.fromJson(param, Map.class);
            String phoneNum = (String)paramMap.get("phoneNum");
            String vali = (String)paramMap.get("validate");
            String ran = this.jedis.get(phoneNum);
            if (StringUtils.isEmpty((String)ran)) {
                objectResponse.setCode(false);
                objectResponse.setMsg("\u624b\u673a\u9a8c\u8bc1\u7801\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u77ed\u606f\u9a8c\u8bc1\u7801\uff01");
                return objectResponse;
            }
            if (vali.equals(ran)) {
                objectResponse.setCode(true);
                objectResponse.setMsg("\u77ed\u606f\u9a8c\u8bc1\u6210\u529f!");
            } else {
                objectResponse.setCode(false);
                objectResponse.setMsg("\u624b\u673a\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u4e4b\u540e\u91cd\u65b0\u8f93\u5165\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            objectResponse.setCode(false);
            objectResponse.setMsg("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2\u662f\u5426\u5408\u6cd5 , msg\uff1a" + e.getMessage());
        }
        return objectResponse;
    }

    @RequestMapping(value={"sendMessage"}, method={RequestMethod.GET})
    @ResponseBody
    public Object sendMessage(@RequestParam(required=false) String param, HttpServletRequest request) {
        this.logger.debug("\u4f20\u8f93param\uff1a{}", (Object)param);
        ObjectResponse objectResponse = new ObjectResponse();
        try {
            Date date = new Date();
            Gson gson = new Gson();
            Map paramMap = (Map)gson.fromJson(param, Map.class);
            String phoneNum = (String)paramMap.get("phone");
            String clientIp = this.getLocalIp(request);
            if (!this.validateIp(clientIp, date).booleanValue()) {
                objectResponse.setCode(false);
                objectResponse.setMsg("error");
                return objectResponse;
            }
            String timeStr = this.jedis.get(String.valueOf(phoneNum) + "time");
            if (StringUtils.isNotBlank((String)timeStr)) {
                long ltime = Long.parseLong(timeStr);
                if ((date.getTime() - ltime) / 1000L < 60L) {
                    this.jedis.setex(String.valueOf(phoneNum) + "time", String.valueOf(date.getTime()), 600);
                    objectResponse.setCode(false);
                    objectResponse.setMsg("\u4e00\u5206\u949f\u5185\u4e0d\u80fd\u91cd\u590d\u53d1\u9001\u9a8c\u8bc1\u7801");
                    return objectResponse;
                }
            }
            if (Validate.isMobile((String)phoneNum)) {
                SMSReceiver mr = new SMSReceiver(phoneNum);
                String rand = ProduceNumber.produce();
                String msg = " \u9a8c\u8bc1\u7801:" + rand + "\uff0c\u60a8\u6b63\u5728\u8fdb\u884c\u7528\u53cb\u4e91\u670d\u52a1\u7528\u6237\u6ce8\u518c\uff0c\uff08\u7528\u53cb\u5ba2\u670d\u7edd\u5bf9\u4e0d\u4f1a\u7d22\u8981\u8be5\u9a8c\u8bc1\u7801\uff0c\u5207\u52ff\u544a\u8bc9\u4ed6\u4eba\uff09\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301!";
                SMSContent mc = new SMSContent("\u77ed\u4fe1\u9a8c\u8bc1", msg, 0);
                try {
                    List snds = new MessageSend((MessageReceiver)mr, (MessageContent)mc).send();
                    this.jedis.setex(phoneNum, rand, 300);
                    this.jedis.setex(String.valueOf(phoneNum) + "time", String.valueOf(date.getTime()), 600);
                    objectResponse.setCode(true);
                    objectResponse.setMsg(((MessageResponse)snds.get(0)).getResponseContent());
                }
                catch (Exception e) {
                    objectResponse.setCode(false);
                    objectResponse.setMsg("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                    this.logger.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25", (Throwable)e);
                }
            } else {
                objectResponse.setCode(false);
                objectResponse.setMsg("\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u4e0d\u5408\u6cd5");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            objectResponse.setCode(false);
            objectResponse.setMsg("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2\u662f\u5426\u5408\u6cd5\uff0cmsg:" + e.getMessage());
        }
        return objectResponse;
    }

    public String getLocalIp(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        String forwarded = request.getHeader("X-Forwarded-For");
        String realIp = request.getHeader("X-Real-IP");
        String ip = null;
        if (realIp == null) {
            ip = forwarded == null ? remoteAddr : String.valueOf(remoteAddr) + "/" + forwarded.split(",")[0];
        } else if (realIp.equals(forwarded)) {
            ip = realIp;
        } else {
            if (forwarded != null) {
                forwarded = forwarded.split(",")[0];
            }
            ip = String.valueOf(realIp) + "/" + forwarded;
        }
        return ip;
    }

    public Boolean validateIp(String ip, Date date) {
        String times = this.jedis.get(ip);
        if (StringUtils.isBlank((String)times)) {
            this.jedis.setex(String.valueOf(ip) + "date", String.valueOf(date.getTime()), 60);
            times = "1";
            this.jedis.setex(ip, times, 60);
        } else {
            this.jedis.setex(ip, String.valueOf(Integer.parseInt(times) + 1), 60);
            times = String.valueOf(Integer.parseInt(times) + 1);
        }
        boolean flag = true;
        Long seconds = (date.getTime() - Long.parseLong(this.jedis.get(String.valueOf(ip) + "date"))) / 1000L;
        int t = Integer.parseInt(times);
        if (seconds < 60L && t > 5) {
            flag = false;
        }
        return flag;
    }
}

