/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.message.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import com.yonyou.iuap.security.rest.utils.PostParamsHelper;
import com.yonyou.iuap.security.rest.utils.SignPropGenerator;
import com.yonyou.uap.message.utils.MsgConfigUtil;
import com.yonyou.uap.msg.persistence.exception.MessageException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uap.web.utils.sign.ClientSignFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebPushUtil {
    private static Logger logger = LoggerFactory.getLogger(WebPushUtil.class);

    public static int webPush(String params) throws ClientProtocolException, IOException {
        long curr = System.currentTimeMillis();
        String address = null;
        try {
            address = MsgConfigUtil.getPropertity((String)"webpush.address");
        }
        catch (MessageException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
        if (StringUtils.isEmpty((String)address)) {
            return 0;
        }
        String url = "http://" + address + "/vi/message.send?ts=" + curr;
        PostMethod method = new PostMethod(url);
        SignProp signProp = null;
        int result = 0;
        try {
            Map paramsMap = WebPushUtil.parseJSON2Map((String)params);
            signProp = SignPropGenerator.genSignProp((String)url);
            signProp.setPostParamsStr(PostParamsHelper.genParamsStrByMap((Map)paramsMap));
            HttpClient client = new HttpClient();
            method.addParameter("paramjson", params);
            HttpMethodParams param = method.getParams();
            param.setContentCharset("UTF-8");
            String sign = "";
            try {
                sign = ClientSignFactory.getSigner((String)"vert").sign(signProp);
            }
            catch (UAPSecurityException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            Header head = new Header("sign", sign);
            method.addRequestHeader(head);
            result = client.executeMethod((HttpMethod)method);
            logger.debug(String.valueOf(result));
            InputStream stream = method.getResponseBodyAsStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            StringBuffer buf = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                buf.append(line).append("\n");
            }
            logger.debug(buf.toString());
            method.releaseConnection();
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static Map<String, Object> parseJSON2Map(String params) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(params, HashMap.class);
        return map;
    }
}

