/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.msg.template.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.uap.msg.template.entity.MessageEntity;
import com.yonyou.uap.msg.template.service.IMsgTemplateCreate;
import com.yonyou.uap.msg.template.service.IMsgTemplateDataSource;
import com.yonyou.uap.msg.template.service.impl.MsgTemplateDefaultBusiVarImpl;
import com.yonyou.uap.msgtemplate.exception.MsgBusinessException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message/template"})
public class MsgCreateController {
    private static final Logger logger = LoggerFactory.getLogger(MsgCreateController.class);
    @Autowired
    private IMsgTemplateCreate msgTemplateCreate;

    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    @ResponseBody
    public Object createMessage(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String jsonString = request.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        String templateCode = null;
        Map busiData = null;
        Map dataMap = null;
        try {
            dataMap = (Map)mapper.readValue(jsonString, HashMap.class);
            templateCode = String.valueOf(dataMap.get("templateCode"));
            busiData = (Map)dataMap.get("busiData");
        }
        catch (IOException e) {
            logger.error("JSON\u8f6c\u6362\u6210Map\u65f6\u51fa\u9519\uff0cjsonString : " + dataMap, (Throwable)e);
            returnMap.put("msg", "JSON\u8f6c\u6362\u6210Map\u65f6\u51fa\u9519\uff0cjsonString : " + dataMap);
            returnMap.put("status", 0);
            return returnMap;
        }
        catch (Exception e) {
            logger.error("\u4f20\u5165\u7684\u4e1a\u52a1\u53c2\u6570\u6709\u8bef\uff0cbusiData : " + dataMap, (Throwable)e);
            returnMap.put("msg", "\u4f20\u5165\u7684\u4e1a\u52a1\u53c2\u6570\u6709\u8bef\uff0cbusiData : " + dataMap);
            returnMap.put("status", 0);
            return returnMap;
        }
        if (dataMap != null) {
            MsgTemplateDefaultBusiVarImpl defaultBusiVarImpl = new MsgTemplateDefaultBusiVarImpl(busiData);
            MessageEntity messageEntity = null;
            try {
                messageEntity = this.msgTemplateCreate.createMessageByCode(templateCode, (IMsgTemplateDataSource)defaultBusiVarImpl);
            }
            catch (MsgBusinessException e) {
                logger.error("\u521b\u5efa\u4fe1\u606f\u6a21\u677f\u5931\u8d25\u3002", (Throwable)e);
                returnMap.put("msg", "\u521b\u5efa\u4fe1\u606f\u6a21\u677f\u5931\u8d25\u3002");
                returnMap.put("status", 0);
                return returnMap;
            }
            returnMap.put("msg", messageEntity);
            returnMap.put("status", 1);
        }
        return returnMap;
    }
}

