/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.msg.template.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.uap.msg.template.entity.MsgTemplateEntity;
import com.yonyou.uap.msg.template.entity.MsgTemplateManageEntity;
import com.yonyou.uap.msg.template.sdk.BusiObjectService;
import com.yonyou.uap.msg.template.service.IMsgTemplateManageService;
import com.yonyou.uap.msg.template.service.IMsgTemplateService;
import com.yonyou.uap.msgtemplate.exception.MsgBusinessException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/message/template"})
public class MsgTemplateController {
    private final Logger logger = LoggerFactory.getLogger(MsgTemplateController.class);
    @Autowired
    private IMsgTemplateService msgTemplateService;
    @Autowired
    private IMsgTemplateManageService msgTempManageService;
    @Autowired
    private BusiObjectService busiObjectService;

    @RequestMapping(method={RequestMethod.POST}, value={"/data"})
    @ResponseBody
    public Object queryMsgChannel(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String dataString = request.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        try {
            MsgTemplateManageEntity tempTypeEntity;
            String entityid;
            Map getDataMap = (Map)mapper.readValue(dataString, HashMap.class);
            Object idObj = getDataMap.get("id");
            Object tempGroupObj = getDataMap.get("tempgroup");
            String id = null;
            String tempManageId = null;
            MsgTemplateEntity template = new MsgTemplateEntity();
            if (!StringUtils.isEmpty(idObj) && (template = this.msgTemplateService.queryMsgTemplateById(id = String.valueOf(idObj))) != null) {
                tempManageId = template.getTempgroup();
            }
            if (!StringUtils.isEmpty(tempGroupObj)) {
                tempManageId = String.valueOf(tempGroupObj);
            }
            if (org.apache.commons.lang.StringUtils.isBlank((String)(entityid = (tempTypeEntity = this.msgTempManageService.queryMsgTempTypeById(tempManageId)).getEntityid()))) {
                returnMap.put("data", "");
                returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u4e1a\u52a1\u5bf9\u8c61\u67e5\u8be2\u5931\u8d25!");
                returnMap.put("status", 0);
                return returnMap;
            }
            List busiObjectList = this.busiObjectService.queryBusiObject(entityid);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("template", template);
            dataMap.put("busiObj", busiObjectList);
            returnMap.put("data", dataMap);
            returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u67e5\u8be2\u6210\u529f!");
            returnMap.put("status", 1);
        }
        catch (MsgBusinessException | IOException e) {
            returnMap.put("data", "");
            returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u67e5\u8be2\u5931\u8d25!");
            returnMap.put("status", 0);
            this.logger.error(e.getMessage(), e);
        }
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"updateMsgTemplate"})
    @ResponseBody
    public Map<String, Object> updateMsgTemplate(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String jsonString = request.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map dataMap = (Map)mapper.readValue(jsonString, HashMap.class);
            String id = (String)dataMap.get("id");
            Map templateMap = (Map)dataMap.get("template");
            MsgTemplateEntity template = new MsgTemplateEntity();
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)id)) {
                MsgTemplateEntity qtTemplate;
                template = this.msgTemplateService.queryMsgTemplateById(id);
                if (!template.getCode().equals(templateMap.get("code")) && (qtTemplate = this.msgTemplateService.queryMsgTemplateByCode((String)templateMap.get("code"))) != null) {
                    returnMap.put("msg", "\u6d88\u606f\u6a21\u7248\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                    returnMap.put("status", 0);
                    return returnMap;
                }
            } else {
                MsgTemplateEntity qTemplate = this.msgTemplateService.queryMsgTemplateByCode((String)templateMap.get("code"));
                if (qTemplate != null) {
                    returnMap.put("msg", "\u6d88\u606f\u6a21\u7248\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d");
                    returnMap.put("status", 0);
                    return returnMap;
                }
            }
            template.setCode((String)templateMap.get("code"));
            template.setName((String)templateMap.get("name"));
            template.setNote((String)templateMap.get("note"));
            template.setTitle((String)templateMap.get("title"));
            template.setData((String)templateMap.get("data"));
            template.setTempgroup((String)templateMap.get("tempgroup"));
            this.msgTemplateService.save(template);
            returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u4fdd\u5b58\u6210\u529f");
            returnMap.put("status", 1);
        }
        catch (MsgBusinessException | IOException e) {
            returnMap.put("data", "");
            returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u4fdd\u5b58\u5931\u8d25");
            returnMap.put("status", 0);
            this.logger.error(e.getMessage(), e);
        }
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"saveMsgTempManage"})
    @ResponseBody
    public Map<String, Object> saveMsgTempManage(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String jsonString = request.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        try {
            MsgTemplateEntity queryMsgTemplateByCode;
            Map dataMap = (Map)mapper.readValue(jsonString, HashMap.class);
            String id = (String)dataMap.get("id");
            Map tempTypeMap = (Map)dataMap.get("tempType");
            MsgTemplateManageEntity tempType = new MsgTemplateManageEntity();
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)id) && (tempType = this.msgTempManageService.queryMsgTempTypeById(id)) == null) {
                tempType = new MsgTemplateManageEntity();
            }
            if ((queryMsgTemplateByCode = this.msgTemplateService.queryMsgTemplateByCode((String)tempTypeMap.get("code"))) == null) {
                tempType.setCode((String)tempTypeMap.get("code"));
                tempType.setName((String)tempTypeMap.get("name"));
                tempType.setEntityid((String)tempTypeMap.get("entityid"));
                tempType.setFatherid((String)tempTypeMap.get("fatherid"));
                tempType.setIsdirectory((String)tempTypeMap.get("isdirectory"));
                tempType.setIsfixed((String)tempTypeMap.get("isfixed"));
                this.msgTempManageService.save(tempType);
                returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u5206\u7c7b\u4fdd\u5b58\u6210\u529f");
                returnMap.put("status", 1);
            } else {
                returnMap.put("msg", "\u6d88\u606f\u6a21\u7248\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d");
                returnMap.put("status", 0);
            }
        }
        catch (MsgBusinessException | IOException e) {
            returnMap.put("data", "");
            returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u5206\u7c7b\u4fdd\u5b58\u5931\u8d25");
            returnMap.put("status", 0);
            this.logger.error(e.getMessage(), e);
        }
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getTempTypes"})
    @ResponseBody
    public Map<String, Object> getTempTypes(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            List msgTempTypeList = this.msgTempManageService.queryAlltempTypes();
            returnMap.put("data", msgTempTypeList);
            returnMap.put("msg", "");
            returnMap.put("status", 1);
        }
        catch (MsgBusinessException e) {
            this.logger.error("\u6d88\u606f\u6a21\u677f\u5206\u7c7b\u67e5\u8be2\u51fa\u9519", (Throwable)e);
            returnMap.put("data", "");
            returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u5206\u7c7b\u67e5\u8be2\u51fa\u9519");
            returnMap.put("status", 1);
        }
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/getTempsByType"})
    @ResponseBody
    public Object getTempByTypeId(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String jsonString = request.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        Map dataMap = null;
        try {
            dataMap = (Map)mapper.readValue(jsonString, HashMap.class);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("data", "");
            returnMap.put("msg", "\u53c2\u6570\u8f6c\u6362\u51fa\u9519");
            returnMap.put("status", "0");
            return returnMap;
        }
        String groupId = (String)dataMap.get("groupId");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)groupId)) {
            returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u5206\u7c7b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u52a0\u8f7d\u6d88\u606f\u6a21\u677f\u6570\u636e");
            returnMap.put("status", 0);
            return returnMap;
        }
        try {
            Map searchMap = this.buildSearchMap(dataMap);
            List tempList = this.msgTemplateService.queryTempsBySearchMap(searchMap);
            Map queryAllNumberMap = this.buildAllNumberMap(dataMap);
            int numbers = this.msgTemplateService.queryMsgTempNumbers(queryAllNumberMap);
            HashMap<String, Object> tempDataMap = new HashMap<String, Object>();
            tempDataMap.put("tempList", tempList);
            tempDataMap.put("nums", numbers);
            returnMap.put("data", tempDataMap);
            returnMap.put("msg", "");
            returnMap.put("status", 1);
        }
        catch (MsgBusinessException e) {
            this.logger.error("\u6d88\u606f\u6a21\u677f\u67e5\u8be2\u51fa\u9519", (Throwable)e);
            returnMap.put("data", "");
            returnMap.put("msg", "\u6d88\u606f\u6a21\u677f\u67e5\u8be2\u51fa\u9519");
            returnMap.put("status", 1);
        }
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{id}"})
    @ResponseBody
    public Object deleteMsgTemplateById(@PathVariable(value="id") String id) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            this.msgTemplateService.deleteById(id);
            returnMap.put("msg", "\u6a21\u677f\u5220\u9664\u6210\u529f!");
            returnMap.put("status", "1");
        }
        catch (MsgBusinessException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            returnMap.put("msg", "\u6a21\u677f\u5220\u9664\u51fa\u9519\uff01");
            returnMap.put("status", "0");
        }
        return returnMap;
    }

    private Map<String, Object> buildAllNumberMap(Map<String, String> dataMap) {
        String search = dataMap.get("search");
        String tempgroup = dataMap.get("groupId");
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)search)) {
            String searchContent = "%" + search + "%";
            searchMap.put("search", searchContent);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)tempgroup) && !tempgroup.equals("all")) {
            searchMap.put("tempgroup", tempgroup);
        }
        return searchMap;
    }

    private Map<String, Object> buildSearchMap(Map<String, String> dataMap) {
        String currentPageStr = String.valueOf(dataMap.get("pagenum"));
        String pageSizeStr = String.valueOf(dataMap.get("pagesize"));
        String search = dataMap.get("search");
        String tempgroup = dataMap.get("groupId");
        int currentPage = 0;
        int pageSize = 0;
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        currentPage = org.apache.commons.lang.StringUtils.isEmpty((String)currentPageStr) ? 9 : Integer.valueOf(currentPageStr);
        int startIndex = (currentPage - 1) * (pageSize = org.apache.commons.lang.StringUtils.isEmpty((String)pageSizeStr) ? 1 : Integer.valueOf(pageSizeStr));
        if (startIndex < 0) {
            startIndex = 0;
        }
        searchMap.put("startIndex", startIndex);
        searchMap.put("pageSize", pageSize);
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)search)) {
            String searchContent = "%" + search + "%";
            searchMap.put("search", searchContent);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)tempgroup) && !tempgroup.equals("all")) {
            searchMap.put("tempgroup", tempgroup);
        }
        return searchMap;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getBusiObject"})
    @ResponseBody
    public Map<String, Object> queryMsgBusinessObject(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        return returnMap;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/test/{code}"})
    @ResponseBody
    public Object queryMsgTemplateChannel(@PathVariable(value="code") String code) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            MsgTemplateEntity template = this.msgTemplateService.queryMsgTemplateByCode(code);
            returnMap.put("data", template);
        }
        catch (MsgBusinessException e) {
            returnMap.put("msg", "\u67e5\u8be2\u51fa\u9519\uff01");
        }
        return returnMap;
    }
}

