/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.msg.template.service.impl;

import com.yonyou.uap.msg.template.service.IMsgTemplateDataSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class MsgTemplateDSSysVarImpl
implements IMsgTemplateDataSource {
    private IMsgTemplateDataSource busiObjDatasource = null;
    private static final List<String> SYS_VAR_NAME_LIST = new ArrayList();
    private static final String SYS_DATE_PATTERN = "yyyy-MM-dd";
    private static final TimeZone localTimeZone = TimeZone.getTimeZone("Asia/Shanghai");

    static {
        SYS_VAR_NAME_LIST.add("SYS_DATE");
        SYS_VAR_NAME_LIST.add("SYS_TIME");
    }

    private MsgTemplateDSSysVarImpl() {
    }

    public MsgTemplateDSSysVarImpl(IMsgTemplateDataSource busiObjDatasource) {
        this.busiObjDatasource = busiObjDatasource;
    }

    public List<String> getExpressValue(String express) {
        ArrayList<String> sysValueList = new ArrayList<String>();
        if (this.isSysParam(express)) {
            if (SYS_VAR_NAME_LIST.indexOf(express) == 0) {
                SimpleDateFormat sdf = new SimpleDateFormat(SYS_DATE_PATTERN);
                sysValueList.add(sdf.format(new Date()));
            } else if (SYS_VAR_NAME_LIST.indexOf(express) == 1) {
                Calendar localCalendar = Calendar.getInstance(localTimeZone);
                int hour = localCalendar.get(11);
                int minute = localCalendar.get(12);
                int second = localCalendar.get(13);
                sysValueList.add(String.valueOf(hour) + ":" + minute + ":" + second);
            }
            return sysValueList;
        }
        return this.busiObjDatasource.getExpressValue(express);
    }

    private boolean isSysParam(String express) {
        return SYS_VAR_NAME_LIST.contains(express);
    }

    public static void main(String[] args) {
        MsgTemplateDSSysVarImpl sysVarDataSource = new MsgTemplateDSSysVarImpl();
        System.out.println(sysVarDataSource.getExpressValue("SYS_DATE"));
        System.out.println(sysVarDataSource.getExpressValue("SYS_TIME"));
    }
}

