$(function(){
	
	var message = {
		json:{},
		selectId:null,
		msgIcon:{
			mail:"icon-mail",
			sms:"icon-duanxin",
			messagepush:"icon-jian"
		},
		configName:{},
		data:{}
	}
	
	//初始化左侧消息发送方式，以及右侧默认的消息发送方式
	window.onload=function(){
		var msgcontent = $(".message-left-content");
		$.ajax({
			type: "GET",
			url: "message/queryAllMsgChannel",
			dataType: "json",
			async:false,
			data:{},
			success: function(data) {
				if(!data || data==null){
					return;
				}
				message.data = data;
				message.configName = data.nameData;
				$.each(data.data,function(i,v){
					if(this.type!="sys"){
						var everyId = message.randomWord(false,20);
						var everyDiv = '<div id="'+ everyId +'" class="message-plugin"><span class="message-plugin-span"><i class="iconfont ' + message.msgIcon[this.type] + '"></i><label>'+this.name+'<label></span><hr class="message-hr"></div>';
						msgcontent.append(everyDiv);
						$("#"+everyId).attr("identity",this.id);	
					}
					if(i==0){
						message.clickMsgPlugin(this.id);
						$("#" + everyId).addClass("message-plugin-click");
						$("#" + everyId).find(".message-plugin-span").addClass("message-plugin-span-click");
					}
			    })
			}
		})
	}
	
	//点击左侧选项选择切换右侧内容
	$(document).on("click", ".message-plugin", function() {
		var id = $(this).attr("identity");
		$(".message-plugin").removeClass("message-plugin-click");
		$(".message-plugin-span").removeClass("message-plugin-span-click");
		$(this).addClass("message-plugin-click");
		$(this).find(".message-plugin-span").addClass("message-plugin-span-click");
		message.clickMsgPlugin(id);	
	});
	
	//点击确定按钮
	$(document).on("click", ".message-confirm", function() {
		var msgRightContent =$(".message-right-content :input");
        var configinfo = {};
		$.each(msgRightContent,function(i,v){
			configinfo[this.name] = this.value;
		});
		var msgData = {
			id:message.selectId,
			"configinfo":configinfo
		};
		$.ajax({
			type: "POST",
			url: "message/updateMsgChannel",
			dataType: "json",
			data:{
				data:JSON.stringify(msgData)
				},
			success: function(data) {
				alert("数据保存成功!")
			},
			error: function(data) {
				alert("数据保存失败!");
			}
		})
		
	});
	//点击取消按钮
	$(document).on("click", ".message-clear", function() {
		var msgRightContent =$(".message-right-content :input");
		$.each(msgRightContent,function(i,v){
			$(this).val("");
		})
	});

	message.clickMsgPlugin=function(id) {
		var msgRightContent =$(".message-right-content");
		var msgId = id;
		$.ajax({
			type: "GET",
			url: "message/data/" + msgId,
			dataType: "json",
			data:{},
			success: function(data) {
				if(!data || data==null){
					return;
				}
				var configinfo = data.data.configinfo;
				var type = data.data.type;
				configinfo = $.parseJSON(configinfo);
				msgRightContent.children().remove();
				message.addContent(msgId,type,configinfo,msgRightContent)
			}
		})
	};
	
	message.addContent = function(id,type,configinfo,msgRightContent){
		message.selectId = id;
		var nameMap = message.configName;
		var keyNameMap = nameMap[type];
		for(var key in keyNameMap){
			var Name = keyNameMap[key];
			var disType = Name["type"];
			var ifMust = Name["ifMust"];
			var content = '<div class="message-right-div"><span class="message-right-span">';
			var mustStr = '<a class="must-fill">*&nbsp;&nbsp;</a>'
			if(disType == "input"){
				if(ifMust == "true"){
					content += mustStr;
				}
				content += '<label>'+ Name["displayName"] +'：</label><input class="message-input" type="text" name="'+ key+'" value="'+ configinfo[key] + '"></span></div>';
			}else if(disType=="password"){
				if(ifMust == "true"){
					content += mustStr;
				}
				content += '<label>'+ Name["displayName"]+'：</label><input class="message-input" type="password" name="'+ key +'" value="' + configinfo[key]+'"></span></div>';
			}
			msgRightContent.append(content);
		}	
	};
	
	/*
	** randomWord 产生任意长度随机字母数字组合
	** randomFlag-是否任意长度 min-任意长度最小位[固定位数] max-任意长度最大位
	** xuanfeng 2014-08-28
	*/
	message.randomWord = function(randomFlag, min, max){
		var str = "",
			range = min,
			arr = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];

		// 随机产生
		if(randomFlag){
			range = Math.round(Math.random() * (max-min)) + min;
		}
		for(var i=0; i<range; i++){
			pos = Math.round(Math.random() * (arr.length-1));
			str += arr[pos];
		}
		return str;
	}
	
});