define(function (require, module, exports) {
    // 引入相关的功能插件或模块
    require('../workbc/requireConfig.js');
    require('../workbc/msgcenter-requireConfig.js');
    var html = require('text!../html/messagectn-workbc.html');
    require('css!../css/font-awesome.min.css');
    require('css!../fonts/ux_1469168218_9169986/iconfont.css');
    require('css!../fonts/ux_1467104466_938644/iconfont.css');
    require('css!../css/msgcenter_default.css');
    require('css!../css/messagectn.css');
    require('text!../html/ctntemplate_task.html');
    require('text!../html/ctntemplate_earlywarning.html');
    require('text!../html/ctntemplate_notice.html');
    require('text!../html/ctntemplate_meeting.html');
    return {
        init: function (content) {
            // 插入内容
            content.innerHTML = html;
            // 执行主逻辑
            var requiretmp={
                "earlywarning":'text!../html/ctntemplate_earlywarning.html',
                "notice":'text!../html/ctntemplate_notice.html',
                "meeting":'text!../html/ctntemplate_meeting.html',
                "dft":'text!../html/ctntemplate_notice.html',
                "task":'text!../html/ctntemplate_task.html'
            };//不同消息类型对应的消息模板
            var msgcontheight=70;//设置模板高度
            var pgnum=1;//页码
            var pgsize=3;//每页数目
            var msgtolcount=0;//总的未读消息数
            var lisno=0;
            var requesturl=window.msgbaseUrl+"message/getMessageforMainView";//消息获取地址
            var updatestatusurl=window.msgbaseUrl+"message/updatestatus";//消息状态更新地址
            var msgdata;//接收到的json数据
            var msgtypeshow=8;//可显示的消息种类
            /*获取打开页面时的时间*/
            var timsearch=[];//时间范围标签对应起始时间的数组
            timsearch.dateall="";//三天前的时间
            timsearch.threeday=getBeforeDate(3);//三天前的时间
            timsearch.aweek=getBeforeDate(7);//一周前的时间
            timsearch.amonth=getBeforeDate(30);//一个月前的时间
            timsearch.earlier=getBeforeDate(3650);//更早的时间
            var endtime;//目前时间
            endtime=getBeforeDate(0);
            var sttssearch=[];//状态标签对应的数组
            sttssearch.unread="0";//未读
            sttssearch.readed="1";//已读
            sttssearch.statusall="";//全部

            /*获取用户Id*/
            var str=document.cookie;                //获取cookie字符串
            var arr=str.split("; ");                //将多cookie切割为多个名/值对
            var userId="";                        //定义一个空字符串
            var s=0;                                //定义一个变量并赋值0
            while(s<arr.length)                    //遍历cookie数组，处理每个cookie对
            {
                var arrs=arr[s].split("=");    //用“=”将cookie的名与值分开
                if("userId"==arrs[0])                //找到名称为_A_P_userId的cookie，并返回它的值
                {
                    userId=arrs[1];            //将获取的值保存在变量userIndex中
                    break;                        //结束循环
                }
                s++;                            //变量i加1
            }
            var logusername=userId;
            var baidu=require('bdtpl');
            baidu.template.ESCAPE = false;
            var msgpara={
                "msgtype":"all",
                "pagenum":"1",
                "pagesize":pgsize,
                "receiver":logusername,
                "status":"0",
                "starttime":"",
                "endtime":endtime
            };//初始加载页面请求参数
            /*初始ajax请求数据并解析数据及DOM操作*/
            $.ajax({
                type: "POST",
                url: requesturl,
                dataType: "json",
                data:{
                    data:JSON.stringify(msgpara)
                },
                success: function(data) {
                    $(".m-dtllist").html("");
                    refreshdom(data);//更新消息状态栏以及消息列表dom
                    /*页面初始化-插入消息过滤标签*/
                    var msgtp_html;//直接显示的消息类别
                    var msgtpmore_html;//需隐藏的消息类别
                    msgtp_html="<div class='msgitem'><span class='m-item all' id='classifyall'>全部</span></div>";
                    msgtpmore_html="";
                    /*消息类型数量不多于展示数量时需插入消息头部的html内容*/
                    if(msgdata.data.msgtype.length<=msgtypeshow){
                        for(var i=0;i<msgdata.data.msgtype.length;i++){
                            msgtp_html+="<div class='msgitem'><span class='m-item' id='"+msgdata.data.msgtype[i].typecode+"'>"+msgdata.data.msgtype[i].typename+"</span></div>";
                        }
                    }
                    /*消息类型数量多于展示数量时需插入消息头部的html内容，隐藏部分*/
                    else if(msgdata.data.msgtype.length>msgtypeshow){
                        var nn=0;
                        for(var i=0;i<msgdata.data.msgtype.length;i++){
                            if(nn>=msgtypeshow) {
                                if(nn==msgtypeshow+1){
                                    msgtp_html+="<div class='additem'></div><div class='m-classifymore'><button class='u-button'><i class='fa fa-chevron-down'></i></button><div></div></div>";
                                }
                                msgtpmore_html+="<div ><span class='m-item' id='"+msgdata.data.msgtype[i].typecode+"'>"+msgdata.data.msgtype[i].typename+"</span></div>";
                                nn++;
                            }else{
                                msgtp_html+="<div class='msgitem'><span class='m-item' id='"+msgdata.data.msgtype[i].typecode+"'>"+msgdata.data.msgtype[i].typename+"</span></div>";
                                nn++;
                            }
                        }
                    }
                    /*动态插入内容*/
                    $(".m-classify .left").html("").prepend(msgtp_html);
                    $(".m-classifymore>div").html("").prepend( msgtpmore_html);
                    /*消息类型可扩展功能键控制*/
                    $(".m-classifymore>button").click(function(){
                        var clamore_active=$(".m-classifymore .active").parent().clone(true);
                        if($(".m-classifymore>div").css("display")=="none"){
                            $(".additem").html("");
                            $(".u-button").css("width","110px");
                            $(".m-classifymore>div").css("display","inline-block");
                            $(".m-classifymore>button i").removeClass("fa-chevron-down").addClass("fa-chevron-up");
                        }else {
                            $(".additem").append(clamore_active);
                            $(".u-button").css("width","30px");
                            $(".m-classifymore>div").css("display","none");
                            $(".m-classifymore>button i").removeClass("fa-chevron-up").addClass("fa-chevron-down");
                        }
                    });
                    $(".m-classifymore>div>div").click(function(){
                        var statuspar = $(".m-status .m-item.active").attr("id");
                        var additem=$(this).clone(true);//选中dom节点转移
                        $(".u-button").css("width","30px");
                        $(".m-classifymore>div").css("display","none");
                        $(".m-classifymore>button i").removeClass("fa-chevron-up").addClass("fa-chevron-down");
                        var sendtpid=$(this).find(".m-item").attr("id");//选中某消息类型传递的msgtypecodevar sendtppar="msgType="+sendtpid;//传递的属性值对
                        var msgpara = {
                            "msgtype": sendtpid,
                            "pagenum": "1",
                            "pagesize": pgsize,
                            "receiver": logusername,
                            "status": "0",
                            "starttime": "",
                            "endtime": "",
                            "search": ""
                        };
                        $.ajax({
                            type: "POST",
                            url: requesturl,
                            dataType: "json",
                            data:{
                                data:JSON.stringify(msgpara)
                            },
                            success: function(data) {
                                $(".m-dtllist").html("");
                                refreshdom(data);
                                pgnum=1;
                                $(".additem").html("").append(additem);
                                $(".m-classify .m-item").removeClass("active");
                                $(".additem .m-item").addClass("active");
                                $(".m-classifymore #"+sendtpid).addClass("active");
                                $("#" + statuspar).addClass("active");//节点更新，其他筛选条件不变
                            }
                        });

                    });
                    $("#dateall").addClass("active");//默认选中全部日期消息
                    $("#classifyall").addClass("active");//默认选中全部消息
                    $("#unread").addClass("active");//默认选中未读消息
                }
            });
            /*刷新页面*/
            function refreshdom(data){
                msgdata = data;//  请求回来的数据
                var msgsts_html;//直接显示的状态类别
                var msgrd_num=0;//已读消息数量
                var msgurd_num=0;//未读消息数量
                var msgdtl_html="";//消息详情列表
                msgtolcount=msgdata.data.totalUnreadNum;
                for(var h=0;h<msgdata.data.msgnum.length;h++){
                    if(msgdata.data.msgnum[h].status=="read"){
                        msgrd_num=msgdata.data.msgnum[h].num;
                    }else if(msgdata.data.msgnum[h].status=="unread"){
                        msgurd_num=msgdata.data.msgnum[h].num;
                    }
                    if( msgrd_num>=100){
                        msgrd_num="99+";
                    }//最多显示99条
                    if( msgurd_num>=100){
                        msgurd_num="99+";
                    }//最多显示99条
                }
                /*消息状态需插入的html内容*/
                //msgsts_html="<div><span class='m-item all' id='statusall'>全部</span></div> <div><span class='m-item' id='readed'>已读<b class='u-badge u-badge-danger' data-badge='"+msgrd_num+"'></b></span></div> <div><span class='m-item' id='unread'>未读<b class='u-badge u-badge-danger' data-badge='"+msgurd_num+"'></b></span></div>";
                msgsts_html="<div><span class='m-item all' id='statusall'>全部</span></div> <div><span class='m-item' id='readed'>已读</span></div> <div><span class='m-item' id='unread'>未读<b class='u-badge u-badge-danger' data-badge='"+msgurd_num+"'></b></span></div>";
                //详细消息列表
                if(msgdata.data.message.length==0){
                    $(".load").css({"display":"none"});
                    msgdtl_html="<div class='nodata'><div class='u-col-lg-12 u-col-md-12 u-col-sm-12 u-col-xs-12 text-center'> 暂无数据！</div></div>";
                }else{
                    $(".load").css({"display":"block"});
                    for(var j=0;j<msgdata.data.message.length;j++){
                        var datatype=msgdata.data.message[j];
                        if(requiretmp[datatype.msgtype]){
                            var msgtmpl=baidu.template(require(requiretmp[datatype.msgtype]));
                        }else{
                            var msgtmpl=baidu.template(require(requiretmp.dft));
                        }
                        msgdtl_html+=msgtmpl({data:datatype});
                    }
                }
                $(".m-dtllist").append(msgdtl_html);
                /*for(var k=0;k<msgdata.data.message.length;k++){
                    if($(".msgcontent:eq("+lisno+")").height()>msgcontheight){
                        $(".msgcontent:eq("+lisno+")").css({"height":"100px","overflow":"auto"});
                        $(".msgcontent:eq("+lisno+")").siblings(".dtlmore").css({"display":"block"});
                    }else{
                        $(".msgcontent:eq("+lisno+")").siblings(".dtlmore").css({"display":"none"})
                    }
                    lisno++;
                }*/
                $(".m-status .left").html("").prepend(msgsts_html);
                /*if(msgrd_num==0){
                    $("#readed b").css("display","none");
                }*/
                if(msgurd_num==0){
                    $("#unread b").css("display","none");
                }
            }
            /*获取距离打开页面的时间*/
            function getBeforeDate(n){
                var n = n;
                var d = new Date();
                var year = d.getFullYear();
                var mon=d.getMonth()+1;
                var day=d.getDate();
                var hh = d.getHours();            //时
                var mm = d.getMinutes();          //分
                var ss=d.getSeconds();            //秒
                if(day <= n){
                    if(mon>1) {
                        mon=mon-1;
                    }
                    else {
                        year = year-1;
                        mon = 12;
                    }
                }
                d.setDate(d.getDate()-n);
                year = d.getFullYear();
                mon=d.getMonth()+1;
                day=d.getDate();
                showtime = year+"-"+(mon<10?('0'+mon):mon)+"-"+(day<10?('0'+day):day)+" "+(hh<10?('0'+hh):hh)+":"+(mm<10?('0'+mm):mm)+":"+(ss<10?('0'+ss):ss);
                return showtime;
            }
            /*消息过滤切换*/
            function filter(){
                var sttimepar = $(".m-date .m-item.active").attr("id");
                var statuspar = $(".m-status .m-item.active").attr("id");
                var msgtp = $(".m-classify .m-item.active").attr("id");
                if(msgtp&&msgtp.indexOf("all")>=0){
                    msgtp="";
                }
                var endtime;//目前时间
                var srchpar=$("#schcont").val();
                endtime=getBeforeDate(0);
                var msgfltpara = {
                    "msgtype": msgtp,
                    "pagenum": "1",
                    "pagesize": pgsize,
                    "receiver": logusername,
                    "status": sttssearch[statuspar],
                    "starttime": timsearch[sttimepar],
                    "endtime": endtime,
                    "search": srchpar
                };
                $.ajax({
                    type: "POST",
                    url: requesturl,
                    dataType: "json",
                    data: {
                        data: JSON.stringify(msgfltpara)
                    },
                    success: function (data) {
                        $(".m-dtllist").html("");
                        lisno=0;
                        refreshdom(data);//更新消息状态栏以及消息列表dom
                        pgnum=1;
                        $("#" + statuspar).addClass("active");//节点更新，其他筛选条件不变
                    }
                });
            }
            $(".m-classify").on("click",".msgitem .m-item",function(){
                var clcid = $(this).attr("id");//选中某消息类型传递的msgtypecode
                $(".m-classify .m-item").removeClass("active");
                $("#"+clcid).addClass("active");//选中消息类型更换样式
                filter();
            });
            $(".m-date").on("click",".m-item",function(){
                var clcid = $(this).attr("id");//选中某消息类型传递的msgtypecode
                $(".m-date .m-item").removeClass("active");
                $("#"+clcid).addClass("active");//选中消息类型更换样式
                filter();
            });
            $(".m-status").on("click",".m-item",function(){
                var clcid = $(this).attr("id");//选中某消息类型传递的msgtypecode
                $(".m-status .m-item").removeClass("active");
                $("#"+clcid).addClass("active");//选中消息类型更换样式
                filter();
            });
            /*模糊搜索*/
            $("#msgsearch").click(function(){
                var srchpar=$("#schcont").val();
                var sttimepar = $(".m-date .m-item.active").attr("id");
                var statuspar = $(".m-status .m-item.active").attr("id");
                var msgtp = $(".m-classify .m-item.active").attr("id");
                if(msgtp&&msgtp.indexOf("all")>=0){
                    msgtp="";
                }
                var endtime;//目前时间
                endtime=getBeforeDate(0);
                var msgfltpara = {
                    "msgtype": msgtp,
                    "pagenum": "1",
                    "pagesize": pgsize,
                    "receiver": logusername,
                    "status": sttssearch[statuspar],
                    "starttime": timsearch[sttimepar],
                    "endtime": endtime,
                    "search": srchpar
                };
                $.ajax({
                    type: "POST",
                    url: requesturl,
                    dataType: "json",
                    data: {
                        data: JSON.stringify(msgfltpara)
                    },
                    success: function (data) {
                        $(".m-dtllist").html("");
                        lisno=0;
                        refreshdom(data);//更新消息状态栏以及消息列表dom
                        pgnum=1;
                        $("#" + statuspar).addClass("active");//节点更新，其他筛选条件不变
                    }
                });
            });
            /*滚动与点击加载更多*/
                function loading(){
                    pgnum++;
                    var srchpar=$("#schcont").val();
                    var sttimepar = $(".m-date .m-item.active").attr("id");
                    var statuspar = $(".m-status .m-item.active").attr("id");
                    var msgtp = $(".m-classify .m-item.active").attr("id");
                    if(msgtp&&msgtp.indexOf("all")>=0){
                        msgtp="";
                    }
                    var endtime;//目前时间
                    endtime=getBeforeDate(0);
                    var msgfltpara = {
                        "msgtype": msgtp,
                        "pagenum": pgnum,
                        "pagesize": pgsize,
                        "receiver": logusername,
                        "status": sttssearch[statuspar],
                        "starttime": timsearch[sttimepar],
                        "endtime": endtime,
                        "search": srchpar
                    };
                    $.ajax({
                        type: "POST",
                        url: requesturl,
                        dataType: "json",
                        data: {
                            data: JSON.stringify(msgfltpara)
                        },
                        success: function (data) {
                            refreshdom(data);
                            $("#" + statuspar).addClass("active");//节点更新，其他筛选条件不变
                        }
                    });
                }
            $(window).unbind ('scroll');
            $(window).scroll(function(){
                if($(document).height()-$(this).scrollTop()-$(this).height()<=0&&$(this).scrollTop()>0&&$(".load").css("display")=="block"){
                    loading();
                }
            });
            $("#loadmore").click(function(){
                    loading();
                });

            $(".msgbackbutton").click(function(){
                    window.history.go(-1);
                });
            /*标识已读状态*/
            $(".m-dtllist").on("click",".tempcontent[data-status='0']",function(){
                if($(this).find(".dtlmore").css("display")=="none"){
                    var _this=$(this);
                    var msgid=_this.attr("id");
                    var type=_this.attr("data-type");
                    var msgData={};
                    if(type!="task"&&!_this.hasClass("msgdone")){
                        msgData = {
                            "id":msgid,
                            "status":"1"
                        };
                        $.ajax({
                            type: "POST",
                            url: updatestatusurl,
                            dataType: "json",
                            data:{
                                data:JSON.stringify(msgData)
                            },
                            success: function () {
                                _this.addClass("msgdone");
                                var typecount=parseInt($("#unread b").attr('data-badge'));
                                typecount=typecount-1;
                                $("#unread b").attr('data-badge',typecount.toString());
                                if(typecount==0){
                                    $("#unread b").css("display","none");
                                }

                                var Tcount=msgtolcount;
                                Tcount=Tcount-1;
                                msgtolcount=msgtolcount-1;
                                if($("#messageCount")){
                                    /*同步工作台的消息推送，$("#messageCount [data-badge]")元素根据不同工作台而不同*/
                                    $("#messageCount [data-badge]").attr('data-badge', Tcount.toString());
                                    if ($("#messageCount:has(b)")) {
                                        $("#messageCount>b").text(Tcount.toString());
                                    }
                                }
                            }
                        });//读完消息传给后台状态
                    }
                }
            });
            /*详情更多*/
            $(".m-dtllist").on("click",".dtlmore",function(e){
                    /*弹出模态框*/
                    /*var diogcontent=$(this).closest('.tempcontent').html();
                     $("#ctndialog_content").html("").append(diogcontent);
                     u.dialog({id:'ctntestDialg',content:"#ctndialog_content",hasCloseMenu:true});*/
                    e.stopPropagation();
                    $(this).siblings(".msgcontent").css({"height":"initial"});
                    $(this).css({"display":"none"});
                    var parent=$(this).parents(".tempcontent");
                    var msgstatus=parent.attr("data-status");
                    var type=parent.attr("data-type");
                    var msgid=parent.attr("id");
                    var msgData={};
                    if(type!="task"&&msgstatus=="0"){
                        msgData = {
                            "id":msgid,
                            "status":"1"
                        };
                        $.ajax({
                            type: "POST",
                            url: updatestatusurl,
                            dataType: "json",
                            data:{
                                data:JSON.stringify(msgData)
                            },
                            success:function(){
                                parent.addClass("msgdone");
                                var typecount=parseInt($("#unread b").attr('data-badge'));
                                typecount=typecount-1;
                                $("#unread b").attr('data-badge',typecount.toString());
                                if(typecount==0){
                                    $("#unread b").css("display","none");
                                }

                                var Tcount=msgtolcount;
                                Tcount=Tcount-1;
                                msgtolcount=msgtolcount-1;
                                if($("#messageCount")){
                                    /*同步工作台的消息推送，$("#messageCount [data-badge]")元素根据不同工作台而不同*/
                                    $("#messageCount [data-badge]").attr('data-badge', Tcount.toString());
                                    if ($("#messageCount:has(b)")) {
                                        if(Tcount > 99){
                                            $("#messageCount>b").text("99+");
                                        }else {
                                            $("#messageCount>b").text(Tcount.toString());
                                        }
                                    }
                                }

                            }
                        });//读完消息传给后台状态
                    }
                })
        }
    }
});