/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.carousel.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.base.response.SimpleResponse;
import com.yyjz.icop.carousel.entity.CarouselEntity;
import com.yyjz.icop.carousel.entity.CarouselWidgetEntity;
import com.yyjz.icop.carousel.repository.CarouselDao;
import com.yyjz.icop.carousel.repository.CarouselWidgetDao;
import com.yyjz.icop.carousel.service.ICarouselService;
import com.yyjz.icop.carousel.service.ICarouselWidgetService;
import com.yyjz.icop.carousel.vo.CarouselVO;
import com.yyjz.icop.layout.service.ILayoutMgrService;
import com.yyjz.icop.layout.vo.LayoutVO;
import com.yyjz.icop.layout.vo.RolesVO;
import com.yyjz.icop.orgcenter.company.service.ICompanyService;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleVO;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import iuap.portal.util.UUIDUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;
import redis.clients.jedis.Jedis;

@Service(value="carouselService")
public class CarouselServiceImpl
implements ICarouselService {
    @Autowired
    private CarouselDao dao;
    @Autowired
    private CarouselWidgetDao carouselWidgetDao;
    @Autowired
    private ICarouselWidgetService carouselWidgetService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ICompanyService companyService;
    private Configuration freeMarkerCfg = new Configuration(Configuration.VERSION_2_3_22);
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private ILayoutMgrService layoutMgrService;

    public CarouselServiceImpl() throws IOException {
        ClassPathResource resource = new ClassPathResource("widget-tpl");
        this.freeMarkerCfg.setDirectoryForTemplateLoading(resource.getFile());
        this.freeMarkerCfg.setDefaultEncoding("UTF-8");
        this.freeMarkerCfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freeMarkerCfg.setLogTemplateExceptions(false);
    }

    public CarouselVO save(CarouselVO vo, final HttpServletRequest request) throws Exception {
        CarouselEntity c = new CarouselEntity();
        if (vo.getId() == null) {
            org.springframework.beans.BeanUtils.copyProperties((Object)vo, (Object)((Object)c));
            c.setId(UUID.randomUUID().toString());
            vo.setId(c.getId());
            c.setTenantId(InvocationInfoProxy.getTenantid());
        } else {
            c = (CarouselEntity)((Object)this.dao.findOne((Serializable)((Object)vo.getId())));
            c.setCarouselCode(vo.getCarouselCode());
            c.setCarouselName(vo.getCarouselName());
            c.setCarouselType(vo.getCarouselType());
            c.setCompanyName(vo.getCompanyName());
            c.setBusinessField(vo.getBusinessField());
        }
        if (StringUtils.isBlank((CharSequence)vo.getCarouselType())) {
            c.setCarouselType("1");
        }
        c = (CarouselEntity)((Object)this.dao.save((Object)c));
        org.springframework.beans.BeanUtils.copyProperties((Object)((Object)c), (Object)vo);
        String updateLayoutSql = "update pt_layout set rnd='" + UUIDUtils.base58Uuid() + "',ts=now() where id='" + c.getLayoutId() + "' ";
        this.jdbcTemplate.update(updateLayoutSql);
        final String layoutId = c.getLayoutId();
        Set keys = (Set)this.jedisTemplate.execute((JedisTemplate.JedisAction)new JedisTemplate.JedisAction<Set<String>>(){

            public Set<String> action(Jedis jedis) {
                return jedis.keys(request.getContextPath() + "/layout/" + layoutId + "*");
            }
        });
        for (String k : keys) {
            this.jedisTemplate.del(new String[]{k});
        }
        return vo;
    }

    @Transactional
    public void del(String id) throws Exception {
        this.dao.delete(this.dao.findOne((Serializable)((Object)id)));
        this.carouselWidgetDao.delWidgetByCarouselId(id);
    }

    public List<CarouselVO> findCarouselByRoleId(String roleID) {
        List<CarouselEntity> ces = this.dao.findCarouselByRoleId(roleID, InvocationInfoProxy.getTenantid());
        ArrayList<CarouselVO> vos = new ArrayList<CarouselVO>();
        for (CarouselEntity c : ces) {
            CarouselVO v = new CarouselVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)((Object)c), (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public List<CarouselVO> findCarouselByLayoutId(String layoutId) {
        List<CarouselEntity> ces = this.dao.findCarouselByLayoutId(layoutId);
        ArrayList<CarouselVO> vos = new ArrayList<CarouselVO>();
        for (CarouselEntity c : ces) {
            CarouselVO v = new CarouselVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)((Object)c), (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public List<CarouselVO> findCarouselByCode(String code) {
        List<CarouselEntity> list = this.dao.findCarouselByCode(code, InvocationInfoProxy.getTenantid());
        ArrayList<CarouselVO> vos = new ArrayList<CarouselVO>();
        for (CarouselEntity c : list) {
            CarouselVO vo = new CarouselVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)((Object)c), (Object)vo);
            vos.add(vo);
        }
        return vos;
    }

    public CarouselVO queryUniqueBean(String wid) {
        CarouselEntity entity = this.dao.queryByPkId(wid);
        CarouselVO vo = null;
        if (entity != null) {
            vo = new CarouselVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        }
        return vo;
    }

    @Transactional
    public Boolean delWidgetsByRole(String roleId, List<String> widgetids) throws Exception {
        try {
            if (CollectionUtils.isNotEmpty(widgetids)) {
                this.carouselWidgetDao.delWidgetByWidgetIds(roleId, widgetids);
            } else {
                this.carouselWidgetDao.delWidgetByRoleId(roleId);
            }
            CarouselEntity c = this.dao.findCarouselByRoleId(roleId);
            if (c != null) {
                this.carouselWidgetService.clearCarouselCache(c.getId());
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Transactional
    public CarouselVO findCarouselByRoleIdAsContent(String roleID) {
        CarouselEntity entity = this.dao.findCarouselByRoleId(roleID);
        CarouselVO vo = null;
        if (entity != null) {
            this.carouselWidgetDao.delWidgetByRoleId(roleID);
            vo = new CarouselVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        }
        return vo;
    }

    private List<Object> setParam(PageRequest page, String param, String companyId) {
        ArrayList<Object> obj = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)param)) {
            obj.add(param);
            obj.add(param);
        }
        if (StringUtils.isNotBlank((CharSequence)companyId)) {
            obj.add(companyId);
        }
        if (page != null) {
            obj.add(page.getOffset());
            obj.add(page.getPageSize());
        }
        return obj;
    }

    private String joinSql(PageRequest page, String param, String companyId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select id,carousel_name carouselName,carousel_code carouselCode,company_id companyId from pt_carousel where dr=0 ");
        if (StringUtils.isNotBlank((CharSequence)param)) {
            sb.append(" and (carousel_name LIKE concat('%', ?, '%') or carousel_code LIKE concat('%', ?, '%'))");
        }
        if (StringUtils.isNotBlank((CharSequence)companyId)) {
            sb.append(" and  company_id =? ");
        }
        if (page != null) {
            sb.append(" ORDER BY lastmodifiedtime DESC limit ?,?");
        }
        return sb.toString();
    }

    Long count(String param, String companyId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from  ( ");
        sb.append(this.joinSql(null, param, companyId));
        sb.append(") r");
        return (Long)this.jdbcTemplate.queryForObject(sb.toString(), Long.class, this.setParam(null, param, companyId).toArray());
    }

    public Page<CarouselVO> page(PageRequest page, String param, String companyId) {
        ArrayList<CarouselVO> vos = new ArrayList<CarouselVO>();
        Long count = this.count(param, companyId);
        if (count > 0L) {
            List bos = this.jdbcTemplate.queryForList(this.joinSql(page, param, companyId), this.setParam(page, param, companyId).toArray());
            for (int i = 0; i < bos.size(); ++i) {
                CarouselVO v = new CarouselVO();
                try {
                    BeanUtils.populate((Object)v, (Map)((Map)bos.get(i)));
                    vos.add(v);
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return new PageImpl(vos, (Pageable)page, count.longValue());
    }

    public List<RolesVO> carouselRoleIds(String param, String carouselId) {
        ArrayList<RolesVO> vos = new ArrayList<RolesVO>();
        String sql = "select role_id from pt_carousel_role where carousel_id=? and dr=0 ";
        List ids = this.jdbcTemplate.queryForList(sql, (Object[])new String[]{carouselId}, String.class);
        for (int i = 0; i < ids.size(); ++i) {
            RolesVO v = new RolesVO();
            RoleVO vo = this.roleService.findOneRole((String)ids.get(i));
            vo.setCompanyName(this.companyService.getCompany(vo.getCompanyId()).getCompanyName());
            org.springframework.beans.BeanUtils.copyProperties((Object)vo, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    @Transactional
    public void delCarouselRoles(final CarouselVO vo) throws Exception {
        this.jdbcTemplate.update("delete from pt_carousel_role   where carousel_id=? and role_id in(?)", new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, vo.getId());
                ps.setString(2, String.join((CharSequence)",", vo.getIds()));
            }
        });
    }

    public void findCarouselWidget(String carouselId, PrintWriter out) {
        CarouselEntity carouselEntity = (CarouselEntity)((Object)this.dao.findOne((Serializable)((Object)carouselId)));
        if (carouselEntity != null) {
            CarouselVO carsouselVo = new CarouselVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)((Object)carouselEntity), (Object)carsouselVo);
            carsouselVo.setCarouselId(carouselEntity.getId());
            if ("1".equals(carsouselVo.getCarouselType())) {
                String templateFileName = "carousel-widget.ftlh";
                try {
                    Template template = this.freeMarkerCfg.getTemplate(templateFileName);
                    template.process((Object)carsouselVo, (Writer)out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("2".equals(carsouselVo.getCarouselType())) {
                String templateFileName = "one-layout.ftlh";
                try {
                    Template template = this.freeMarkerCfg.getTemplate(templateFileName);
                    template.process((Object)carsouselVo, (Writer)out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("3".equals(carsouselVo.getCarouselType())) {
                String templateFileName = "two-layout.ftlh";
                try {
                    Template template = this.freeMarkerCfg.getTemplate(templateFileName);
                    template.process((Object)carsouselVo, (Writer)out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("4".equals(carsouselVo.getCarouselType())) {
                String templateFileName = "three-layout.ftlh";
                try {
                    Template template = this.freeMarkerCfg.getTemplate(templateFileName);
                    template.process((Object)carsouselVo, (Writer)out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("5".equals(carsouselVo.getCarouselType())) {
                String templateFileName = "four-layout.ftlh";
                try {
                    Template template = this.freeMarkerCfg.getTemplate(templateFileName);
                    template.process((Object)carsouselVo, (Writer)out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("6".equals(carsouselVo.getCarouselType())) {
                String templateFileName = "five-layout.ftlh";
                try {
                    Template template = this.freeMarkerCfg.getTemplate(templateFileName);
                    template.process((Object)carsouselVo, (Writer)out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Page<CarouselVO> pageByCompanyIds(PageRequest pageRequest, String param, List<String> companyIds, String carouselType, String layoutId) {
        ArrayList<CarouselVO> vos = new ArrayList<CarouselVO>();
        Long count = this.pageCount(param, companyIds, carouselType, layoutId);
        ArrayList<Object> params = new ArrayList<Object>();
        if (count > 0L) {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT id,carousel_name carouselName,carousel_code carouselCode,company_id companyId, company_name companyName, carousel_type carouselType  from pt_carousel where dr=0 ");
            if (StringUtils.isNotBlank((CharSequence)layoutId)) {
                sql.append(" AND layout_id = ?");
                params.add(layoutId);
            }
            if (StringUtils.isNotBlank((CharSequence)carouselType)) {
                sql.append(" AND carousel_type = ?");
                params.add(carouselType);
            }
            if (CollectionUtils.isNotEmpty(companyIds)) {
                sql.append(" AND company_id IN ( ");
                for (String id : companyIds) {
                    sql.append("?, ");
                    params.add(id);
                }
                sql.append("'0') ");
            }
            if (StringUtils.isNotBlank((CharSequence)param)) {
                sql.append(" and (carousel_name LIKE concat('%', ?, '%') or carousel_code LIKE concat('%', ?, '%') )");
                params.add(param);
                params.add(param);
            }
            sql.append(" ORDER BY lastmodifiedtime DESC,creationtime DESC limit ?,?");
            params.add(pageRequest.getOffset());
            params.add(pageRequest.getPageSize());
            List bos = this.jdbcTemplate.queryForList(sql.toString(), params.toArray());
            CompanyVO company = null;
            for (int i = 0; i < bos.size(); ++i) {
                CarouselVO v = new CarouselVO();
                try {
                    BeanUtils.populate((Object)v, (Map)((Map)bos.get(i)));
                    company = this.companyService.getCompany(v.getCompanyId());
                    if (null != company) {
                        v.setCompanyName(company.getCompanyShName());
                    }
                    vos.add(v);
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return new PageImpl(vos, (Pageable)pageRequest, count.longValue());
    }

    private Long pageCount(String param, List<String> companyIds, String carouselType, String layoutId) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        sb.append("SELECT COUNT(*) FROM pt_carousel WHERE dr=0 ");
        if (StringUtils.isNotBlank((CharSequence)layoutId)) {
            sb.append(" AND layout_id = ?");
            params.add(layoutId);
        }
        if (StringUtils.isNotBlank((CharSequence)carouselType)) {
            sb.append(" AND carousel_type = ?");
            params.add(carouselType);
        }
        if (StringUtils.isNotBlank((CharSequence)param)) {
            sb.append(" AND (carousel_name LIKE CONCAT('%', ?, '%') or carousel_code LIKE CONCAT('%', ?, '%'))");
            params.add(param);
            params.add(param);
        }
        if (CollectionUtils.isNotEmpty(companyIds)) {
            sb.append(" AND company_id IN ( ");
            for (String id : companyIds) {
                sb.append("?, ");
                params.add(id);
            }
            sb.append("'0') ");
        }
        return (Long)this.jdbcTemplate.queryForObject(sb.toString(), Long.class, params.toArray());
    }

    public void batchSaveCarousel(List<CarouselVO> list, String id, String tenantId, String companyId, String companyName, String roleId) {
        CarouselEntity entity = null;
        for (CarouselVO vo : list) {
            List<String> idlist = this.carouselWidgetDao.findWidgetIdsByCarouselId(vo.getId());
            entity = new CarouselEntity();
            org.springframework.beans.BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setTenantId(tenantId);
            entity.setCompanyId(companyId);
            entity.setCompanyName(companyName);
            entity.setCreationTimestamp(new Timestamp(System.currentTimeMillis()));
            entity.setModificationTimestamp(new Timestamp(System.currentTimeMillis()));
            entity.setRoleId(roleId);
            entity.setLayoutId(id);
            entity.setId(null);
            entity = (CarouselEntity)((Object)this.dao.save((Object)entity));
            int i = 1;
            for (String widgetId : idlist) {
                CarouselWidgetEntity widget = new CarouselWidgetEntity();
                widget.setCarouselId(entity.getId());
                widget.setWidgetId(widgetId);
                widget.setTenantId(tenantId);
                widget.setTag(i);
                this.carouselWidgetDao.save((Object)widget);
                ++i;
            }
        }
    }

    public SimpleResponse batchDelCarousel(List<String> carouselIds) {
        SimpleResponse resp = new SimpleResponse();
        resp.setCode(true);
        resp.setMsg("\u64cd\u4f5c\u6210\u529f");
        boolean isAllDelAble = true;
        ArrayList<CarouselEntity> delList = new ArrayList<CarouselEntity>();
        StringBuilder msg = null;
        if (CollectionUtils.isNotEmpty(carouselIds)) {
            List elist = this.dao.findAll(carouselIds);
            List volist = this.layoutMgrService.getByCarouselIds(carouselIds);
            StringBuilder info = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)volist)) {
                String setting = ((LayoutVO)volist.get(0)).getSetting();
                if (CollectionUtils.isNotEmpty((Collection)elist)) {
                    for (CarouselEntity e : elist) {
                        if (StringUtils.isNotBlank((CharSequence)setting) && setting.indexOf(e.getId()) >= 0) {
                            info.append(e.getCarouselCode()).append("\u3001");
                            isAllDelAble = false;
                            continue;
                        }
                        delList.add(e);
                    }
                    msg = new StringBuilder();
                    if (!isAllDelAble) {
                        if (CollectionUtils.isNotEmpty(delList)) {
                            msg.append("\u64cd\u4f5c\u90e8\u5206\u6210\u529f\uff0c");
                        } else {
                            msg.append("\u64cd\u4f5c\u5931\u8d25\uff0c");
                        }
                        msg.append("\u7f16\u7801\u4e3a[").append(info.substring(0, info.length() - 1)).append("]\u7684\u5c0f\u5e03\u5c40\u5df2\u8bbe\u8ba1\u5e03\u5c40\uff0c\u4e0d\u80fd\u76f4\u63a5\u5220\u9664\u3002");
                        resp.setMsg(msg.toString());
                    }
                    if (CollectionUtils.isNotEmpty(delList)) {
                        this.dao.delete(delList);
                    }
                }
            } else {
                this.dao.delete(elist);
            }
        }
        return resp;
    }

    @Transactional
    public void batchSaveCarousel(List<CarouselVO> list, String id, String tenantId, String companyId, String companyName, String roleId, Map<String, String> widgetIds) {
        CarouselEntity entity = null;
        for (CarouselVO vo : list) {
            List<String> idlist = this.carouselWidgetDao.findWidgetIdsByCarouselId(vo.getId());
            entity = new CarouselEntity();
            org.springframework.beans.BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setTenantId(tenantId);
            entity.setCompanyId(companyId);
            entity.setCompanyName(companyName);
            entity.setCreationTimestamp(new Timestamp(System.currentTimeMillis()));
            entity.setModificationTimestamp(new Timestamp(System.currentTimeMillis()));
            entity.setRoleId(roleId);
            entity.setLayoutId(id);
            entity.setId(null);
            entity = (CarouselEntity)((Object)this.dao.save((Object)entity));
            int i = 1;
            for (String widgetid : idlist) {
                if (widgetIds.containsKey(widgetid)) {
                    CarouselWidgetEntity widget = new CarouselWidgetEntity();
                    widget.setCarouselId(entity.getId());
                    widget.setWidgetId(widgetid);
                    widget.setTenantId(tenantId);
                    widget.setTag(i);
                    this.carouselWidgetDao.save((Object)widget);
                }
                ++i;
            }
        }
    }
}

