/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.carousel.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.carousel.entity.CarouselWidgetEntity;
import com.yyjz.icop.carousel.repository.CarouselWidgetDao;
import com.yyjz.icop.carousel.service.ICarouselWidgetService;
import com.yyjz.icop.carousel.vo.CarouselWidgetVO;
import com.yyjz.icop.permission.menu.service.IAppMenuService;
import com.yyjz.icop.widgetx.entity.WidgetEntity;
import com.yyjz.icop.widgetx.repository.WidgetXDao;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

@Service(value="carouselWidgetService")
public class CarouselWidgetServiceImpl
implements ICarouselWidgetService {
    @Autowired
    private CarouselWidgetDao dao;
    @Autowired
    private WidgetXDao widgetXDao;
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private IAppMenuService appMenuService;

    public void clearCarouselCache(String carouselId) {
        List<String> ids = this.dao.findWidgetIdsByCarouselId(carouselId);
        if (CollectionUtils.isNotEmpty(ids)) {
            String key = "carousel_" + StringUtils.join((Object[])ids.toArray(new String[ids.size()]), (String)"_");
            this.jedisTemplate.del(new String[]{key});
        }
    }

    @Transactional
    public CarouselWidgetVO save(CarouselWidgetVO vo) throws Exception {
        Integer maxtag = this.dao.findMaxTagByCarouselId(vo.getCarouselId());
        if (maxtag == null) {
            maxtag = 0;
        }
        for (int i = 0; i < vo.getWidgetIds().size(); ++i) {
            maxtag = maxtag + 1;
            CarouselWidgetEntity c = new CarouselWidgetEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)c));
            c.setTenantId(InvocationInfoProxy.getTenantid());
            c.setWidgetId((String)vo.getWidgetIds().get(i));
            c.setTag(maxtag);
            c = (CarouselWidgetEntity)((Object)this.dao.save((Object)c));
        }
        return vo;
    }

    @Transactional
    public void del(String carouselId, String widgetId) throws Exception {
        this.dao.delWidgetByCarouselId(carouselId, widgetId);
    }

    public List<WidgetVO> findWidgetByCarouselId(String carouselId) {
        List<String> list = this.dao.findWidgetIdsByCarouselId(carouselId);
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        if (list != null && list.size() > 0) {
            WidgetVO v = null;
            for (String id : list) {
                WidgetEntity e = (WidgetEntity)this.widgetXDao.findOne((Serializable)((Object)id));
                if (e == null) continue;
                v = new WidgetVO();
                BeanUtils.copyProperties((Object)e, (Object)v);
                vos.add(v);
            }
        }
        return vos;
    }

    @Transactional
    public int eidtTag(CarouselWidgetVO vo) {
        CarouselWidgetEntity entity = this.dao.findWidgetByCarouselId(vo.getCarouselId(), vo.getWidgetId());
        if (entity != null) {
            Integer tag = entity.getTag();
            if (vo.getType() == 0) {
                CarouselWidgetEntity upentity = this.dao.getUpWidgetById(vo.getCarouselId(), entity.getId());
                if (upentity != null) {
                    entity.setTag(upentity.getTag());
                    upentity.setTag(tag);
                    this.dao.save((Object)entity);
                    this.dao.save((Object)upentity);
                    return 0;
                }
                return 1;
            }
            CarouselWidgetEntity nextentity = this.dao.getNextWidgetById(vo.getCarouselId(), entity.getId());
            if (nextentity != null) {
                entity.setTag(nextentity.getTag());
                nextentity.setTag(tag);
                this.dao.save((Object)entity);
                this.dao.save((Object)nextentity);
                return 0;
            }
            return 2;
        }
        return 3;
    }

    public List<WidgetVO> findAllByProperties(String carouselId, String searchText, String magnetType, String category) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("select pw.id, pw.pk_widget widgetId, pw.name, pw.magnet_type magnetType, pw.category ").append(" from pt_widget pw ").append(" inner join ( select widget_id,tag from pt_carousel_widget").append(" where carousel_id = ? and dr = 0) pcw on pw.pk_widget = pcw.widget_id ").append(" where pw.dr = 0 ");
        params.add(carouselId);
        if (StringUtils.isNotBlank((CharSequence)magnetType)) {
            sql.append(" and pw.magnet_type = ?");
            params.add(magnetType);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{category})) {
            sql.append(" and pw.category = ?");
            params.add(category);
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sql.append(" and (pw.id like CONCAT('%',?,'%') or pw.`name` like CONCAT('%',?,'%')) ");
            params.add(searchText);
            params.add(searchText);
        }
        sql.append(" order by pcw.tag");
        return this.jdbcTemplate.query(sql.toString(), params.toArray(), (RowMapper)BeanPropertyRowMapper.newInstance(WidgetVO.class));
    }

    public List<WidgetVO> findWidgetByCarouselId(String carouselId, String roleId) {
        List appMenuIds = this.appMenuService.findMenuIdsByRoleId(roleId);
        if (CollectionUtils.isEmpty((Collection)appMenuIds)) {
            return null;
        }
        List<String> list = this.dao.findWidgetIdsByCarouselId(carouselId, appMenuIds);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        if (list != null && list.size() > 0) {
            WidgetVO v = null;
            for (String id : list) {
                WidgetEntity e = (WidgetEntity)this.widgetXDao.findOne((Serializable)((Object)id));
                if (e == null) continue;
                v = new WidgetVO();
                BeanUtils.copyProperties((Object)e, (Object)v);
                vos.add(v);
            }
        }
        return vos;
    }

    @Transactional
    public void batchDel(String carouselId, List<String> widgetIds) {
        this.dao.batchDel(carouselId, widgetIds);
    }
}

