/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.context.web;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.base.response.ObjectResponse;
import com.yyjz.icop.base.response.ReturnCode;
import com.yyjz.icop.base.utils.ContextUtils;
import com.yyjz.icop.base.utils.DESUtils;
import com.yyjz.icop.context.bo.BtnBO;
import com.yyjz.icop.context.bo.MaContext;
import com.yyjz.icop.context.bo.RoleBO;
import com.yyjz.icop.context.bo.UserRoleOrderBO;
import com.yyjz.icop.context.service.IUserRoleOrderService;
import com.yyjz.icop.context.service.WorkbenchAppService;
import com.yyjz.icop.context.vo.UserRoleOrderVO;
import com.yyjz.icop.orgcenter.company.service.ICompanyService;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;
import com.yyjz.icop.permission.app.vo.AppBtnVO;
import com.yyjz.icop.permission.menu.vo.AppMenuVO;
import com.yyjz.icop.permission.role.service.IRoleAppBtnService;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleVO;
import com.yyjz.icop.util.RestTemplateUtil;
import com.yyjz.icop.utils.httpclient.HttpClientUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springside.modules.nosql.redis.JedisTemplate;
import uap.web.utils.CookieUtil;
import uap.web.utils.PropertyUtil;

@Controller
@RequestMapping(value={"/wb/app"})
public class WorkbenchAppController {
    public static Logger logger = LoggerFactory.getLogger(WorkbenchAppController.class);
    private final String USERCENTER_BASEHOST = PropertyUtil.getPropertyByKey((String)"icop.usercenter.web.serverName");
    private static RestTemplateUtil restTemplateUtil = new RestTemplateUtil();
    public static final Integer USER_CONTEXT_EXPIRETIME = 3600;
    public static final String USER_CONTEXT_AUTHORITY = "USER_CONTEXT_AUTHORITY";
    public static final String USER_CONTEXT_BY_PROXY = "USER_CONTEXT_BY_PROXY";
    public static final String USER_CONTEXT_BY_HEADER = "USER_CONTEXT_BY_HEADER";
    public static final String SESSION_PREFIX = "IUAP_SESSION_USER:";
    private static final String CURRENT_USER_ROLE_LIST = "CURRENT_USER_ROLE_LIST";
    @Value(value="#{configProperties['sso.usercenter.loginAndValidate']}")
    private String loginAndValidate;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private IRoleAppBtnService roleAppBtnService;
    @Autowired
    private WorkbenchAppService workbenchAppService;
    @Autowired
    private RedisTemplate<String, Object> jdkRedisTemplate;
    @Autowired
    private IUserRoleOrderService userRoleOrderService;

    @RequestMapping(method={RequestMethod.POST}, value={"/ssologin"})
    public void ssoLogin(HttpServletRequest request, HttpServletResponse response) {
        try {
            String authority;
            Cookie[] cookies = request.getCookies();
            if (cookies != null && cookies.length > 0) {
                for (Cookie cookie : cookies) {
                    cookie.setMaxAge(0);
                    cookie.setPath("/");
                    response.addCookie(cookie);
                }
            }
            String userName = request.getParameter("userName");
            String password = request.getParameter("password");
            userName = DESUtils.decrypt((String)userName);
            password = DESUtils.decrypt((String)password);
            HashMap<String, String> postMap = new HashMap<String, String>();
            postMap.put("userName", userName);
            postMap.put("userPassword", DESUtils.encrypt((String)password));
            postMap.put("systemId", "icop");
            JSONObject retJson = null;
            String result = HttpClientUtil.postParam(this.USERCENTER_BASEHOST + this.loginAndValidate, null, postMap);
            if (StringUtils.isNotBlank((String)result)) {
                retJson = JSONObject.parseObject((String)result);
            }
            if (retJson != null && !retJson.isEmpty() && StringUtils.isNotBlank((String)(authority = retJson.getString("authentication")))) {
                String[] authorities;
                JSONObject jsonObject = retJson.getJSONObject("userValidate");
                JSONObject user = jsonObject.getJSONObject("user");
                StringBuilder sb = new StringBuilder(authority);
                if (StringUtils.isNotEmpty((String)user.getString("userId"))) {
                    sb.append(";").append("_A_P_userId=").append(user.getString("userId"));
                }
                if (StringUtils.isNotEmpty((String)user.getString("userCode"))) {
                    sb.append(";").append("_A_P_userLoginName=").append(user.getString("userCode"));
                }
                if (StringUtils.isNotEmpty((String)user.getString("userName"))) {
                    sb.append(";").append("_A_P_userName=").append(URLEncoder.encode(URLEncoder.encode(user.getString("userName"), "UTF-8"), "UTF-8"));
                }
                if ("1".equals(user.getString("typeId"))) {
                    sb.append(";").append("_A_P_isadmin=1");
                }
                List roleVOS = this.roleService.findAllRolesByUserId(user.getString("userId"));
                List<RoleBO> roleBos = null;
                if (roleVOS != null && roleVOS.size() > 0) {
                    roleBos = this.sortRoleList(user.getString("userId"), null, roleVOS);
                    this.redisTemplate.opsForValue().set((Object)("CURRENT_USER_ROLE_LIST:" + user.getString("userId")), roleBos);
                }
                if (roleBos != null && roleBos.size() > 0) {
                    for (RoleBO roleBo : roleBos) {
                        CompanyVO companyVo;
                        if (!roleBo.getSelected()) continue;
                        sb.append(";").append("_A_P_currentRoleId=").append(roleBo.getId());
                        sb.append(";").append("_A_P_currentRoleDictId=").append(roleBo.getDictionaryId());
                        sb.append(";").append("source_auth_type=").append(roleBo.getSourceAuthType());
                        if (!StringUtils.isNotBlank((String)roleBo.getCompanyId()) || (companyVo = this.companyService.getCompany(roleBo.getCompanyId())) == null || !StringUtils.isNotEmpty((String)companyVo.getId())) continue;
                        sb.append(";").append("companyId=").append(roleBo.getCompanyId());
                        sb.append(";").append("companyCode=").append(URLEncoder.encode(URLEncoder.encode(companyVo.getCompanyCode(), "UTF-8"), "UTF-8"));
                        sb.append(";").append("companyName=").append(URLEncoder.encode(URLEncoder.encode(companyVo.getCompanyName(), "UTF-8"), "UTF-8"));
                        sb.append(";").append("orgType=").append("1");
                        sb.append(";").append("companyType=").append(companyVo.getCompanyType());
                    }
                }
                for (String value : authorities = sb.toString().split(";")) {
                    String[] auths = value.split("=");
                    Cookie cookie = new Cookie(auths[0], auths[1]);
                    cookie.setPath("/");
                    cookie.setMaxAge(604800000);
                    response.addCookie(cookie);
                }
                response.sendRedirect(PropertyUtil.getPropertyByKey((String)"lunbo.url"));
            }
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u767b\u5f55\u5f02\u5e38" + e.getMessage());
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/switchCompany"})
    @ResponseBody
    public Object switchCompany(HttpServletRequest request) {
        ObjectResponse listResponse = new ObjectResponse();
        try {
            String contextUrl = this.USERCENTER_BASEHOST + "usercenter/context";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userId", InvocationInfoProxy.getUserid());
            params.put("refreshContext", "true");
            System.out.println("contextUrl=" + contextUrl);
            String userContextStr = restTemplateUtil.get((ServletRequest)request, contextUrl, params);
            try {
                JSONObject userContext = JSONObject.parseObject((String)userContextStr);
                JSONObject init = userContext.getJSONObject("init");
                if (init.getString("code").equals(ReturnCode.FAILURE.getValue())) {
                    throw new Exception(init.getString("tip"));
                }
                if (init.containsKey((Object)"tip")) {
                    logger.error(init.getString("tip"));
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage().equals(ReturnCode.REGEX_CHINESE.getValue()) ? e.getMessage() : ">>>>>>>\u8c03\u7528\u521d\u59cb\u5316\u4e0a\u4e0b\u6587\u670d\u52a1\u5f02\u5e38, url=> " + contextUrl);
            }
            listResponse.setCode(true);
            listResponse.setMsg("\u67e5\u8be2\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            listResponse.setCode(false);
            listResponse.setMsg("\u67e5\u8be2\u5931\u8d25\uff01+msg" + e.getMessage());
        }
        return listResponse;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/switchMaCompany"})
    @ResponseBody
    public Object switchMaCompany(HttpServletRequest request, @RequestBody MaContext context) {
        JSONObject ret = new JSONObject();
        try {
            RedisTemplate redisTemplate = (RedisTemplate)ContextUtils.getBean((String)"jdkRedisTemplate", RedisTemplate.class);
            if (StringUtils.isNotBlank((String)context.getToken())) {
                System.out.println(InvocationInfoProxy.getToken());
                JSONObject redisUserContext = (JSONObject)redisTemplate.opsForValue().get((Object)context.getToken());
                if (redisUserContext != null) {
                    JSONObject userContextProxy = (JSONObject)redisUserContext.get((Object)USER_CONTEXT_BY_PROXY);
                    JSONObject userContextHeader = (JSONObject)redisUserContext.get((Object)USER_CONTEXT_BY_HEADER);
                    String userContextAuth = (String)redisUserContext.get((Object)USER_CONTEXT_AUTHORITY);
                    JSONObject contextProxy = (JSONObject)userContextProxy.get((Object)"data");
                    contextProxy.put("curCompanyId", (Object)context.getCompanyId());
                    userContextProxy.put("data", (Object)contextProxy);
                    JSONObject headerData = (JSONObject)userContextHeader.get((Object)"data");
                    JSONObject company = (JSONObject)headerData.get((Object)"curCompany");
                    company.put("companyId", (Object)context.getCompanyId());
                    company.put("companyName", (Object)context.getCompanyName());
                    company.put("companyCode", (Object)context.getCompanyCode());
                    headerData.put("curCompany", (Object)company);
                    userContextHeader.put("data", (Object)headerData);
                    JSONObject redisNewUserContext = new JSONObject();
                    redisNewUserContext.put(USER_CONTEXT_BY_PROXY, (Object)userContextProxy);
                    redisNewUserContext.put(USER_CONTEXT_BY_HEADER, (Object)userContextHeader);
                    redisNewUserContext.put(USER_CONTEXT_AUTHORITY, (Object)userContextAuth);
                    redisTemplate.opsForValue().set((Object)InvocationInfoProxy.getToken(), (Object)redisUserContext);
                    redisTemplate.expire((Object)context.getToken(), (long)USER_CONTEXT_EXPIRETIME.intValue(), TimeUnit.SECONDS);
                }
            }
            ret.put("msg", (Object)"\u66f4\u65b0\u4e0a\u4e0b\u6587\u6210\u529f!");
            ret.put("code", (Object)"success");
        }
        catch (Exception e) {
            ret.put("msg", (Object)"\u66f4\u65b0\u4e0a\u4e0b\u6587\u5931\u8d25!");
            ret.put("code", (Object)"failure");
            e.printStackTrace();
        }
        return ret;
    }

    private List<BtnBO> queryBtnBoList(String roleId, String appCode, String pageCode, String widgetCode, String portalAppCode) {
        List btnVOs = this.roleAppBtnService.getBtnsPermission(roleId, appCode, pageCode, widgetCode, portalAppCode);
        ArrayList<BtnBO> data = new ArrayList<BtnBO>();
        if (btnVOs != null) {
            for (AppBtnVO bvo : btnVOs) {
                BtnBO btnBo = new BtnBO();
                btnBo.setBtnCode(bvo.getCode());
                btnBo.setBtnName(bvo.getName());
                if ("1".equals(bvo.getRoute())) {
                    btnBo.setEnable(true);
                } else {
                    btnBo.setEnable(false);
                }
                btnBo.setViewMode(bvo.getViewMode());
                data.add(btnBo);
            }
        }
        return data;
    }

    @RequestMapping(value={"getBtn/{roleId}/{appCode}/{pageCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject getAuthorityButton(@PathVariable(value="roleId") String roleId, @PathVariable(value="appCode") String appCode, @PathVariable(value="pageCode") String pageCode, String widgetCode, String portalAppCode) {
        JSONObject ret = new JSONObject();
        try {
            List<BtnBO> data = this.queryBtnBoList(roleId, appCode, pageCode, widgetCode, portalAppCode);
            ret.put("msg", (Object)"\u83b7\u53d6\u6210\u529f!");
            ret.put("data", data);
            ret.put("code", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.put("msg", (Object)"\u83b7\u53d6\u5931\u8d25!");
            ret.put("code", (Object)"failure");
        }
        return ret;
    }

    @RequestMapping(value={"getApps/{roleId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object queryAuthrityApps(@PathVariable(value="roleId") String roleId) {
        JSONObject ret = new JSONObject();
        try {
            ArrayList appGroupList = new ArrayList();
            if (StringUtils.isNotBlank((String)roleId)) {
                appGroupList = this.roleAppBtnService.queryAuthorityAppGroups(roleId);
            }
            ret.put("msg", (Object)"\u83b7\u53d6\u6210\u529f\uff01");
            ret.put("data", (Object)appGroupList);
            ret.put("code", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.put("msg", (Object)"\u83b7\u53d6\u5931\u8d25!");
            ret.put("code", (Object)"failure");
        }
        return ret;
    }

    @RequestMapping(value={"queryRoleList"}, method={RequestMethod.GET})
    @ResponseBody
    public Object queryRoleListByCompanyId() {
        JSONObject ret = new JSONObject();
        try {
            String userId = InvocationInfoProxy.getUserid();
            List<RoleBO> roleVoList = (List<RoleBO>)this.jdkRedisTemplate.opsForValue().get((Object)("CURRENT_USER_ROLE_LIST:" + userId));
            if (roleVoList == null || roleVoList.isEmpty()) {
                roleVoList = this.workbenchAppService.findRolesByUserId(userId);
            }
            ret.put("msg", (Object)"\u83b7\u53d6\u6210\u529f\uff01");
            ret.put("data", roleVoList);
            ret.put("code", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.put("msg", (Object)"\u67e5\u8be2\u89d2\u8272\u5931\u8d25!");
            ret.put("code", (Object)"failure");
        }
        return ret;
    }

    @RequestMapping(value={"saveUserRoleOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveUserRoleOrder(@RequestBody UserRoleOrderBO bo) {
        JSONObject resp = new JSONObject();
        try {
            String s = this.workbenchAppService.saveUserRoleOrder(bo);
            resp.put("data", (Object)s);
            resp.put("msg", (Object)"\u4fdd\u5b58\u7528\u6237\u89d2\u8272\u6392\u5e8f\u6210\u529f");
            resp.put("code", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.put("msg", (Object)"\u4fdd\u5b58\u89d2\u8272\u987a\u5e8f\u5931\u8d25");
            resp.put("code", (Object)"failure");
        }
        return resp;
    }

    @RequestMapping(value={"saveSelectedRole"})
    @ResponseBody
    public Object saveSelectedRole(@RequestParam String roleId) {
        JSONObject resp = new JSONObject();
        try {
            this.workbenchAppService.saveSelectedRole(roleId);
            resp.put("msg", (Object)"\u4fdd\u5b58\u5f53\u524d\u89d2\u8272\u6210\u529f");
            resp.put("code", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.put("msg", (Object)"\u4fdd\u5b58\u5f53\u524d\u89d2\u8272\u5931\u8d25");
            resp.put("code", (Object)"failure");
        }
        return resp;
    }

    @RequestMapping(value={"/validateOnline"}, produces={"text/event-stream"})
    @ResponseBody
    public String swidtchScreen(HttpServletRequest request) throws Exception {
        Thread.sleep(5000L);
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
        JedisTemplate jedisTemplate = (JedisTemplate)ctx.getBean("jedisTemplate", JedisTemplate.class);
        String tokenStr = CookieUtil.findCookieValue((Cookie[])request.getCookies(), (String)"token");
        String cookieUserId = CookieUtil.findCookieValue((Cookie[])request.getCookies(), (String)"_A_P_userId");
        Map jedisMap = jedisTemplate.hgetAll(SESSION_PREFIX + cookieUserId);
        String result = "data:failure\n\n";
        if (StringUtils.isNotEmpty((String)tokenStr) && (jedisMap == null || jedisMap != null && !jedisMap.containsKey(tokenStr))) {
            result = "data:success\n\n";
        }
        return result;
    }

    @RequestMapping(value={"getAppMenu"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getAppMenu(String widgetCode, String appCode) {
        JSONObject resp = new JSONObject();
        try {
            AppMenuVO appMenu = this.workbenchAppService.getAppMenu(widgetCode, appCode);
            resp.put("data", (Object)appMenu);
            resp.put("msg", (Object)"\u83b7\u53d6\u5e94\u7528\u6210\u529f");
            resp.put("code", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.put("msg", (Object)"\u83b7\u53d6\u5e94\u8be5\u5931\u8d25");
            resp.put("code", (Object)"failure");
        }
        return resp;
    }

    /*
     * WARNING - void declaration
     */
    private List<RoleBO> sortRoleList(String userId, String companyId, List<RoleVO> roles) {
        ArrayList<RoleBO> orderedRoles = null;
        List orders = this.userRoleOrderService.findByUserId(userId);
        String selectedRole = null;
        if (orders != null && !orders.isEmpty()) {
            UserRoleOrderVO userRoleOrderVo = (UserRoleOrderVO)orders.get(0);
            String roleIdsStr = userRoleOrderVo.getRoleIds();
            selectedRole = userRoleOrderVo.getSelectedRole();
            if (StringUtils.isNotBlank((String)roleIdsStr)) {
                void var12_20;
                String[] roleIds = roleIdsStr.split(",");
                HashMap<String, RoleBO> roleVOMap = new HashMap<String, RoleBO>();
                for (RoleVO roleVO : roles) {
                    RoleBO bo = new RoleBO();
                    BeanUtils.copyProperties((Object)roleVO, (Object)((Object)bo));
                    roleVOMap.put(roleVO.getId(), bo);
                }
                orderedRoles = new ArrayList();
                for (String roleId : roleIds) {
                    RoleBO roleBO = (RoleBO)((Object)roleVOMap.get(roleId));
                    if (roleBO == null) continue;
                    orderedRoles.add(roleBO);
                    roleVOMap.remove(roleId);
                }
                if (!roleVOMap.isEmpty()) {
                    for (Map.Entry entry : roleVOMap.entrySet()) {
                        orderedRoles.add((RoleBO)((Object)entry.getValue()));
                    }
                }
                boolean hasSelected = false;
                boolean bl = false;
                while (var12_20 < orderedRoles.size()) {
                    RoleBO roleBO = (RoleBO)((Object)orderedRoles.get((int)var12_20));
                    if (roleBO.getId().equals(selectedRole)) {
                        roleBO.setSelected(true);
                        hasSelected = true;
                        break;
                    }
                    ++var12_20;
                }
                if (!hasSelected && !orderedRoles.isEmpty()) {
                    ((RoleBO)((Object)orderedRoles.get(0))).setSelected(true);
                }
                return orderedRoles;
            }
        }
        boolean hasSelected = false;
        orderedRoles = new ArrayList<RoleBO>();
        for (int i = 0; i < roles.size(); ++i) {
            RoleBO bo = new RoleBO();
            BeanUtils.copyProperties((Object)roles.get(i), (Object)((Object)bo));
            if (bo.getId().equals(selectedRole)) {
                bo.setSelected(true);
                hasSelected = true;
            }
            orderedRoles.add(bo);
        }
        if (!hasSelected && !orderedRoles.isEmpty()) {
            ((RoleBO)((Object)orderedRoles.get(0))).setSelected(true);
        }
        return orderedRoles;
    }
}

