/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layout.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.carousel.entity.CarouselEntity;
import com.yyjz.icop.carousel.entity.CarouselWidgetEntity;
import com.yyjz.icop.carousel.repository.CarouselDao;
import com.yyjz.icop.carousel.repository.CarouselWidgetDao;
import com.yyjz.icop.carousel.service.ICarouselWidgetService;
import com.yyjz.icop.layout.entity.LayoutRoleDesignEntity;
import com.yyjz.icop.layout.repository.LayoutRoleDesignDao;
import com.yyjz.icop.layout.service.ILayoutRoleCarouselService;
import com.yyjz.icop.layout.vo.LayoutRoleVO;
import com.yyjz.icop.utils.LayoutTools;
import com.yyjz.icop.utils.httpclient.HttpClientUtil;
import com.yyjz.icop.widgetx.entity.WidgetEntity;
import com.yyjz.icop.widgetx.repository.WidgetXDao;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import iuap.portal.util.UUIDUtils;
import java.net.SocketTimeoutException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import uap.web.utils.PropertyUtil;

@Service(value="layoutRoleCarouselService")
@Deprecated
public class LayoutRoleCarouselServiceImpl
implements ILayoutRoleCarouselService {
    @Autowired
    private CarouselDao carouselDao;
    @Autowired
    private CarouselWidgetDao widgetDao;
    @Autowired
    private LayoutRoleDesignDao dao;
    @Autowired
    private WidgetXDao widgetXDao;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ICarouselWidgetService carouselWidgetService;
    private String TEMP_LATEID = "new-home-1-5-1-3";
    private String RND = null;
    private static String SQL_LAYOUT_UPDATE = "update pt_layout set setting=?,rnd=? where id=?";

    @Transactional
    public boolean save(LayoutRoleVO vo) throws Exception {
        try {
            if (vo.getRoleCategory() == 2) {
                this.TEMP_LATEID = "column4-4-4-4";
            } else {
                CarouselEntity cc = this.saveCarousel(vo);
                vo.setCarouselId(cc.getId());
            }
            this.saveLayout(vo);
            this.saveLayoutRole(vo);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return true;
    }

    @Transactional
    public CarouselEntity saveCarousel(LayoutRoleVO vo) throws Exception {
        CarouselEntity c = new CarouselEntity();
        try {
            String id = UUID.randomUUID().toString();
            c.setId(id);
            c.setCarouselCode(vo.getCarouselCode());
            c.setCarouselName(vo.getCarouselName());
            c.setRoleId(vo.getRoleId());
            c.setTenantId(InvocationInfoProxy.getTenantid());
            c.setContent(vo.getRoleId());
            c = (CarouselEntity)((Object)this.carouselDao.save((Object)c));
        }
        catch (Exception e) {
            throw new Exception("\u8f6e\u64ad\u4fdd\u5b58\u5931\u8d25" + e.getMessage());
        }
        return c;
    }

    @Transactional
    public void saveLayout(final LayoutRoleVO vo) throws Exception {
        try {
            this.RND = UUIDUtils.base58Uuid();
            final String tenantId = InvocationInfoProxy.getTenantid();
            final String time = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date());
            final String setting = LayoutTools.getInit().setting(vo.getRoleCategory(), vo.getRoleId(), vo.getCarouselId());
            String sql = this.join();
            this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, vo.getRoleId());
                    ps.setString(2, LayoutRoleCarouselServiceImpl.this.RND);
                    ps.setString(3, vo.getLayoutName());
                    ps.setString(4, tenantId);
                    ps.setString(5, LayoutRoleCarouselServiceImpl.this.TEMP_LATEID);
                    ps.setString(6, LayoutRoleCarouselServiceImpl.this.RND);
                    ps.setInt(7, 0);
                    ps.setString(8, tenantId);
                    ps.setString(9, time);
                    ps.setString(10, time);
                    ps.setString(11, time);
                    ps.setString(12, "icop");
                    ps.setString(13, "Y");
                    ps.setString(14, setting);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u4fdd\u5b58\u5e03\u5c40\u5931\u8d25" + e.getMessage());
        }
    }

    public String join() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO PT_LAYOUT(ID,PK_LAYOUT,NAME,TENANT,TEMPLATEID,RND,DR,TENANT_ID,CTIME,TS,MODIFYTIME,SYSTEM,ISENABLE,SETTING)");
        sb.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sb.toString();
    }

    @Transactional
    public void saveLayoutRole(LayoutRoleVO vo) throws Exception {
        try {
            LayoutRoleDesignEntity c = new LayoutRoleDesignEntity();
            c.setLayoutId(vo.getRoleId());
            c.setLayoutCode(vo.getLayoutCode());
            c.setLayoutName(vo.getLayoutName());
            c.setRoleId(vo.getRoleId());
            c.setRoleCode(vo.getRoleCode());
            this.dao.save((Object)c);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u89d2\u8272\u6388\u6743\u5e03\u5c40\u5931\u8d25" + e.getMessage());
        }
    }

    public Runnable clearLayoutCache(final String layoutId) {
        return new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> idMap = new HashMap<String, String>();
                idMap.put("id", layoutId);
                String url = PropertyUtil.getPropertyByKey((String)"layout.create");
                try {
                    String rs = HttpClientUtil.postParam(url + "/icop-workbench/layout/clearCache", null, idMap);
                    System.out.println(rs);
                }
                catch (ConnectTimeoutException e) {
                    e.printStackTrace();
                }
                catch (SocketTimeoutException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Transactional
    public void saveWidgets(String carouselId, List<String> widgetIds) {
        this.widgetDao.delWidgetByCarouselId(carouselId);
        if (CollectionUtils.isNotEmpty(widgetIds)) {
            for (int i = 0; i < widgetIds.size(); ++i) {
                CarouselWidgetEntity cw = new CarouselWidgetEntity();
                cw.setCarouselId(carouselId);
                cw.setWidgetId(widgetIds.get(i));
                cw.setTenantId(InvocationInfoProxy.getTenantid());
                cw.setTag(i + 1);
                this.widgetDao.save((Object)cw);
            }
        }
        this.carouselWidgetService.clearCarouselCache(carouselId);
    }

    @Transactional
    public boolean saveCarouselWidges(String roleId, Integer roleCategory, List<String> widgetIds) throws Exception {
        try {
            CarouselEntity c = null;
            LayoutRoleVO vo = new LayoutRoleVO();
            if (roleCategory == 1) {
                c = this.carouselDao.findCarouselByRoleId(roleId);
                if (c == null) {
                    return true;
                }
                vo.setCarouselId(c.getId());
                vo.setCarouselName(c.getCarouselName());
                this.saveWidgets(c.getId(), widgetIds);
            } else {
                if (CollectionUtils.isNotEmpty(widgetIds)) {
                    List<WidgetEntity> wes = this.widgetXDao.findWidgetsByIds(widgetIds);
                    vo.setRoleId(roleId);
                    vo.setRoleCategory(roleCategory);
                    for (int i = 0; i < wes.size(); ++i) {
                        WidgetVO v = new WidgetVO();
                        v.setId(wes.get(i).getWidgetId());
                        v.setName(wes.get(i).getName());
                        v.setUrl(wes.get(i).getUrl());
                        vo.getWidgets().add(v);
                    }
                    this.updateLayout(vo, roleId);
                } else {
                    this.updateLayout(null, roleId);
                }
                Thread t = new Thread(this.clearLayoutCache(roleId));
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u89d2\u8272\u6388\u6743\u5e94\u7528\u5931\u8d25-" + e.getMessage());
        }
        return true;
    }

    @Transactional
    public void updateLayout(LayoutRoleVO vo, final String roleId) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(SQL_LAYOUT_UPDATE);
            final String rs = vo == null ? LayoutTools.getInit().setting(2, null, null) : LayoutTools.getInit().setting(vo);
            this.jdbcTemplate.update(sb.toString(), new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, rs);
                    ps.setString(2, UUIDUtils.base58Uuid());
                    ps.setString(3, roleId);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("setting\u5e03\u5c40\u8bbe\u8ba1\u5931\u8d25-" + e.getMessage());
        }
    }
}

