/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layout.service.impl;

import com.yyjz.icop.carousel.service.ICarouselService;
import com.yyjz.icop.layout.entity.LayoutRoleDesignEntity;
import com.yyjz.icop.layout.repository.LayoutRoleDesignDao;
import com.yyjz.icop.layout.service.ILayoutMgrService;
import com.yyjz.icop.layout.service.ILayoutRoleDesignService;
import com.yyjz.icop.layout.vo.LayoutRoleVO;
import com.yyjz.icop.layout.vo.LayoutVO;
import com.yyjz.icop.orgcenter.company.service.ICompanyService;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;
import com.yyjz.icop.permission.role.service.IRoleAppBtnService;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleVO;
import com.yyjz.icop.usercenter.service.IUserService;
import com.yyjz.icop.usercenter.vo.UserBaseVO;
import iuap.portal.layout.service.IPortalLayoutPubService;
import iuap.portal.service.ILayoutService;
import iuap.portal.util.UUIDUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="layoutRoleDesignService")
public class LayoutRoleDesignServiceImpl
implements ILayoutRoleDesignService {
    private static final Logger LOGGER = Logger.getLogger(LayoutRoleDesignServiceImpl.class);
    @Resource(name="layoutRoleDesignDao")
    private LayoutRoleDesignDao layoutRoleDesignDao;
    @Autowired
    private IPortalLayoutPubService portalLayoutPubService;
    @Autowired
    private ILayoutService layoutService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ILayoutMgrService layoutMgrService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private IRoleAppBtnService roleAppBtnService;
    @Autowired
    private IUserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private NamedParameterJdbcTemplate namedJdbcTemplate;
    @Autowired
    private ICarouselService carouselService;

    @Transactional
    public LayoutRoleVO add(String layoutId, String roleId) {
        return null;
    }

    @Transactional
    public int delLayout(String id) {
        final LayoutRoleDesignEntity e = this.layoutRoleDesignDao.findLayoutById(id);
        if (e != null) {
            e.setDr(1);
            e.setModificationTimestamp(new Timestamp(System.currentTimeMillis()));
            this.layoutRoleDesignDao.save((Object)e);
            this.jdbcTemplate.update("delete from pt_layout   where id=?", new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, e.getLayoutId());
                }
            });
            return 1;
        }
        return 0;
    }

    @Transactional
    public void changeSortlayout(String id, Integer sign) {
    }

    public LayoutRoleVO findLayoutById(String id) throws Exception {
        LayoutRoleVO vo = new LayoutRoleVO();
        LayoutRoleDesignEntity e = this.layoutRoleDesignDao.findLayoutById(id);
        BeanUtils.copyProperties((Object)((Object)e), (Object)vo);
        return vo;
    }

    public List<Map<String, String>> queryLayoutDesignByRole(String roleId, String userId) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        List<LayoutRoleDesignEntity> roleDesignList = this.layoutRoleDesignDao.findLayoutDesignIdsByRoleId(roleId);
        if (roleDesignList != null && roleDesignList.size() > 0) {
            for (LayoutRoleDesignEntity entity : roleDesignList) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                LayoutRoleDesignEntity layoutRoleDesignEntity = this.layoutRoleDesignDao.findPersonalLayout(entity.getLayoutId(), userId);
                if (layoutRoleDesignEntity != null) {
                    resultMap.put("templateId", layoutRoleDesignEntity.getLayoutCode());
                    resultMap.put("layoutId", layoutRoleDesignEntity.getId());
                } else {
                    resultMap.put("templateId", entity.getRoleCode());
                    resultMap.put("layoutId", entity.getLayoutId());
                }
                resultList.add(resultMap);
            }
        }
        return resultList;
    }

    public List<LayoutRoleVO> queryByRole(String roleId) {
        List<LayoutRoleDesignEntity> roleDesignList = this.layoutRoleDesignDao.findLayoutByRoleId(roleId);
        ArrayList<LayoutRoleVO> vos = new ArrayList<LayoutRoleVO>();
        for (LayoutRoleDesignEntity e : roleDesignList) {
            LayoutRoleVO v = new LayoutRoleVO();
            BeanUtils.copyProperties((Object)((Object)e), (Object)v);
            vos.add(v);
        }
        return vos;
    }

    @Transactional
    public LayoutRoleVO saveLayout(LayoutRoleVO vo) {
        LayoutRoleDesignEntity e = null;
        if (vo.getId() != null && !"".equals(vo.getId())) {
            e = this.layoutRoleDesignDao.findLayoutById(vo.getId());
            e.setLayoutName(vo.getLayoutName());
            e.setLayoutCode(vo.getLayoutCode());
            e.setModificationTimestamp(new Timestamp(System.currentTimeMillis()));
        } else {
            e = new LayoutRoleDesignEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)e));
        }
        if (e.getSort() == null) {
            e.setSort(10);
        }
        e = (LayoutRoleDesignEntity)((Object)this.layoutRoleDesignDao.save((Object)e));
        BeanUtils.copyProperties((Object)((Object)e), (Object)vo);
        return vo;
    }

    public Map<String, String> saveLayoutDesign(String roleLayoutId) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        LayoutRoleDesignEntity roleDesignEntity = this.layoutRoleDesignDao.findLayoutById(roleLayoutId);
        if (StringUtils.isEmpty((String)roleDesignEntity.getLayoutId())) {
            String layoutId = UUID.randomUUID().toString();
            iuap.portal.entity.LayoutVO layoutvo = this.portalLayoutPubService.createEmptyLayout(layoutId, roleDesignEntity.getLayoutName(), "");
            resultMap.put("layoutId", layoutId);
            resultMap.put("modify", layoutvo.getRnd());
            roleDesignEntity.setLayoutId(layoutId);
            this.layoutRoleDesignDao.save((Object)roleDesignEntity);
        } else {
            iuap.portal.entity.LayoutVO layoutVo = this.portalLayoutPubService.queryLayoutById(roleDesignEntity.getLayoutId());
            resultMap.put("layoutId", roleDesignEntity.getLayoutId());
            resultMap.put("modify", layoutVo.getRnd());
        }
        return resultMap;
    }

    public LayoutRoleVO queryParentLayRoleDesign(String layoutId) {
        LayoutRoleDesignEntity roleDesignEntity = this.layoutRoleDesignDao.queryParentLayRoleDesign(layoutId);
        if (roleDesignEntity != null) {
            LayoutRoleVO layoutRoleVo = new LayoutRoleVO();
            BeanUtils.copyProperties((Object)((Object)roleDesignEntity), (Object)layoutRoleVo);
            return layoutRoleVo;
        }
        return null;
    }

    @Transactional
    public void deleteLayoutByUserId(String roleId, String userId) throws Exception {
        List<LayoutRoleDesignEntity> layoutRoleDesignList = this.layoutRoleDesignDao.findLayoutDesignIdsByRoleId(roleId);
        if (layoutRoleDesignList != null && layoutRoleDesignList.size() > 0) {
            for (LayoutRoleDesignEntity layoutRoleDesign : layoutRoleDesignList) {
                if (!StringUtils.isNotBlank((String)layoutRoleDesign.getLayoutId())) continue;
                this.layoutService.reset(userId, layoutRoleDesign.getLayoutId());
            }
        }
    }

    public LayoutRoleVO findOneByCode(String roleId, String layoutCode) {
        LayoutRoleDesignEntity roleDesignEntity = this.layoutRoleDesignDao.findOneByCode(roleId, layoutCode);
        if (roleDesignEntity != null) {
            LayoutRoleVO layoutRoleVo = new LayoutRoleVO();
            BeanUtils.copyProperties((Object)((Object)roleDesignEntity), (Object)layoutRoleVo);
            return layoutRoleVo;
        }
        return null;
    }

    public LayoutRoleVO findOneByLayoutId(String layoutId) {
        LayoutRoleDesignEntity roleDesignEntity = this.layoutRoleDesignDao.findOneByLayoutId(layoutId);
        if (roleDesignEntity != null) {
            LayoutRoleVO layoutRoleVo = new LayoutRoleVO();
            BeanUtils.copyProperties((Object)((Object)roleDesignEntity), (Object)layoutRoleVo);
            return layoutRoleVo;
        }
        return null;
    }

    public List<LayoutRoleVO> queryByRoleForNewLayout(String roleId) {
        List<LayoutRoleDesignEntity> roleDesignList = this.layoutRoleDesignDao.findNewLayoutByRoleId(roleId);
        ArrayList<LayoutRoleVO> vos = new ArrayList<LayoutRoleVO>();
        for (LayoutRoleDesignEntity e : roleDesignList) {
            LayoutRoleVO v = new LayoutRoleVO();
            BeanUtils.copyProperties((Object)((Object)e), (Object)v);
            vos.add(v);
        }
        return vos;
    }

    @Transactional
    public Map<String, String> saveRoleLayout(String tenantId, String companyId, String type) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            RoleVO isflag_gys;
            CompanyVO company = this.companyService.getCompany(companyId);
            if (company == null) {
                map.put("code", "false");
                map.put("msg", "\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
                return map;
            }
            UserBaseVO user = this.userService.findSuperUserByTenantId(tenantId);
            if (user == null) {
                map.put("code", "false");
                map.put("msg", "\u79df\u6237\u4e0b\u4e0d\u5b58\u5728\u7ba1\u7406\u5458\u7528\u6237\uff01");
                return map;
            }
            String gysRoleId = null;
            String cgsRoleId = null;
            RoleVO isflag_cgs = this.roleService.findOneRoleByCode("globle_cgs", Integer.valueOf(1), tenantId);
            if (isflag_cgs == null && (cgsRoleId = this.layoutMgrService.savefindByRoleCode("globle_cgs", tenantId, companyId)) != null) {
                LayoutVO cgsLayou = this.layoutMgrService.savefindByLayoutCode("purchase-cgs", tenantId, companyId, company.getCompanyName(), cgsRoleId);
                LayoutRoleDesignEntity entity = null;
                if (cgsLayou != null) {
                    entity = new LayoutRoleDesignEntity();
                    entity.setCompanyId(companyId);
                    entity.setRoleId(cgsRoleId);
                    entity.setRoleCode("globle_cgs");
                    entity.setLayoutId(cgsLayou.getId());
                    entity.setLayoutCode(cgsLayou.getLayoutCode());
                    entity.setLayoutName(cgsLayou.getLayoutName());
                    entity.setSort(1);
                    entity.setTenantId(tenantId);
                    this.layoutRoleDesignDao.save((Object)entity);
                }
            }
            if ((isflag_gys = this.roleService.findOneRoleByCode("globle_gys", Integer.valueOf(1), tenantId)) == null && (gysRoleId = this.layoutMgrService.savefindByRoleCode("globle_gys", tenantId, companyId)) != null) {
                LayoutVO gysLayou = this.layoutMgrService.savefindByLayoutCode("purchase-gys", tenantId, companyId, company.getCompanyName(), gysRoleId);
                LayoutRoleDesignEntity entity = null;
                if (gysLayou != null) {
                    entity = new LayoutRoleDesignEntity();
                    entity.setCompanyId(companyId);
                    entity.setRoleId(gysRoleId);
                    entity.setRoleCode("globle_gys");
                    entity.setLayoutId(gysLayou.getId());
                    entity.setLayoutCode(gysLayou.getLayoutCode());
                    entity.setLayoutName(gysLayou.getLayoutName());
                    entity.setSort(2);
                    entity.setTenantId(tenantId);
                    this.layoutRoleDesignDao.save((Object)entity);
                }
            }
            if ("cgs".equals(type) && user != null && cgsRoleId != null) {
                this.roleAppBtnService.addWorkbench(user.getUserId(), Integer.valueOf(0), companyId, company.getCompanyName(), cgsRoleId, "1");
            } else if ("gys".equals(type) && user != null && gysRoleId != null) {
                this.roleAppBtnService.addWorkbench(user.getUserId(), Integer.valueOf(0), companyId, company.getCompanyName(), gysRoleId, "1");
            } else if ("all".equals(type) && user != null && cgsRoleId != null && gysRoleId != null) {
                this.roleAppBtnService.addWorkbench(user.getUserId(), Integer.valueOf(0), companyId, company.getCompanyName(), cgsRoleId, "1");
                this.roleAppBtnService.addWorkbench(user.getUserId(), Integer.valueOf(0), companyId, company.getCompanyName(), gysRoleId, "1");
            }
            map.put("code", "true");
            map.put("msg", "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            map.put("code", "false");
            map.put("msg", "\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage());
        }
        return map;
    }

    @Transactional
    public Map<String, String> savefindByLayoutCode(final String tenantId, final String companyId, String companyName, String roleId, Map<String, String> widgetId, String newRoleId) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("roleId", roleId);
            List bos = this.namedJdbcTemplate.queryForList("select t.* from pt_layout t,sm_role_design r where t.id=r.layout_id and t.dr=0 and t.layout_type=2 and r.role_id=:roleId", obj);
            if (bos != null && bos.size() > 0) {
                final String templateid = (String)((Map)bos.get(0)).get("templateid");
                final String setting = (String)((Map)bos.get(0)).get("setting");
                final String name = (String)((Map)bos.get(0)).get("name");
                final String system = (String)((Map)bos.get(0)).get("system");
                final String isenable = (String)((Map)bos.get(0)).get("isenable");
                final String code = (String)((Map)bos.get(0)).get("code");
                final String id = UUID.randomUUID().toString();
                this.jdbcTemplate.update("delete from PT_LAYOUT where code=? and tenant_id=?", new Object[]{code, tenantId});
                String sql = "INSERT INTO PT_LAYOUT(ID,PK_LAYOUT,NAME,TENANT,TEMPLATEID,RND,DR,TENANT_ID,CTIME,TS,MODIFYTIME,SYSTEM,ISENABLE,SETTING,CODE,COMPANY_ID,LAYOUT_TYPE) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                final String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                int num = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setString(1, id);
                        ps.setString(2, UUIDUtils.base58Uuid());
                        ps.setString(3, name);
                        ps.setString(4, tenantId);
                        ps.setString(5, templateid);
                        ps.setString(6, UUIDUtils.base58Uuid());
                        ps.setInt(7, 0);
                        ps.setString(8, tenantId);
                        ps.setString(9, time);
                        ps.setString(10, time);
                        ps.setString(11, time);
                        ps.setString(12, system);
                        ps.setString(13, isenable);
                        ps.setString(14, setting);
                        ps.setString(15, code);
                        ps.setString(16, companyId);
                        ps.setInt(17, 2);
                    }
                });
                if (num != 0) {
                    List list = this.carouselService.findCarouselByLayoutId((String)((Map)bos.get(0)).get("id"));
                    this.carouselService.batchSaveCarousel(list, id, tenantId, companyId, companyName, newRoleId, widgetId);
                    LayoutRoleDesignEntity entity = new LayoutRoleDesignEntity();
                    entity.setCompanyId(companyId);
                    entity.setRoleId(newRoleId);
                    entity.setRoleCode("globle_cgs");
                    entity.setLayoutId(id);
                    entity.setLayoutCode(code);
                    entity.setLayoutName(name);
                    entity.setSort(1);
                    entity.setTenantId(tenantId);
                    this.layoutRoleDesignDao.save((Object)entity);
                    map.put("code", "true");
                    map.put("msg", "\u89d2\u8272\u4fdd\u5b58\u6210\u529f");
                } else {
                    map.put("code", "false");
                    map.put("msg", "\u89d2\u8272\u5e03\u5c40\u4fdd\u5b58\u5931\u8d25");
                }
            } else {
                map.put("code", "false");
                map.put("msg", "\u89d2\u8272\u5e03\u5c40\u67e5\u8be2\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return map;
    }
}

