/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.shortcut.service.impl;

import com.yyjz.icop.shortcut.entity.ShortcutCategoryEntity;
import com.yyjz.icop.shortcut.entity.ShortcutEntity;
import com.yyjz.icop.shortcut.repository.ShortcutCategoryDao;
import com.yyjz.icop.shortcut.repository.ShortcutDao;
import com.yyjz.icop.shortcut.service.IShortcutService;
import com.yyjz.icop.shortcut.service.impl.ShortcutSpecification;
import com.yyjz.icop.shortcut.vo.ShortcutVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShortcutServiceImpl
implements IShortcutService {
    @Resource(name="shortcutCategoryDao")
    private ShortcutCategoryDao shortcutCategoryDao;
    @Autowired
    private ShortcutDao shortcutDao;

    public List<ShortcutVO> findShortcutPage(String searchText, Map<String, Object> rel, PageRequest page) {
        ShortcutSpecification spe = new ShortcutSpecification(searchText, rel);
        Page es = this.shortcutDao.findAll(spe, (Pageable)page);
        ArrayList<ShortcutVO> vos = new ArrayList<ShortcutVO>();
        for (ShortcutEntity e : es) {
            ShortcutVO v = new ShortcutVO();
            BeanUtils.copyProperties((Object)((Object)e), (Object)v);
            ShortcutCategoryEntity category = this.shortcutCategoryDao.findShortcutCategoryByID(v.getCategory());
            if (category != null) {
                v.setCategoryName(category.getName());
            }
            vos.add(v);
        }
        return vos;
    }

    public long findShortcutCount(String searchText, Map<String, Object> rel) {
        ShortcutSpecification spe = new ShortcutSpecification(searchText, rel);
        return this.shortcutDao.count(spe);
    }

    @Transactional
    public ShortcutVO saveShortcut(ShortcutVO vo) throws Exception {
        ShortcutEntity e = new ShortcutEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)e));
        e = (ShortcutEntity)((Object)this.shortcutDao.save((Object)e));
        BeanUtils.copyProperties((Object)((Object)e), (Object)vo);
        return vo;
    }

    public ShortcutVO findShortcutEntityByID(String id) {
        ShortcutEntity e = (ShortcutEntity)((Object)this.shortcutDao.findOne((Serializable)((Object)id)));
        ShortcutVO vo = new ShortcutVO();
        BeanUtils.copyProperties((Object)((Object)e), (Object)vo);
        return vo;
    }

    public int findShortcutByIdAndCode(String ShortcutId, String code) {
        return this.shortcutDao.findShortcutByIdAndCode(ShortcutId, code);
    }

    @Transactional
    public int delShortcut(String ShortcutId) throws Exception {
        return this.shortcutDao.delShortcut(ShortcutId);
    }

    public void deleteShortcutByGroup(String category) {
        this.shortcutDao.deleteShortcutByGroup(category);
    }

    public List<ShortcutVO> findShortcutsByIds(List<String> ShortcutIds) {
        List<ShortcutEntity> list = this.shortcutDao.findShortcutByIds(ShortcutIds);
        ArrayList<ShortcutVO> vos = new ArrayList<ShortcutVO>();
        for (ShortcutEntity e : list) {
            ShortcutVO v = new ShortcutVO();
            BeanUtils.copyProperties((Object)((Object)e), (Object)v);
            vos.add(v);
        }
        return vos;
    }
}

