/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils {
    private static Logger log = LoggerFactory.getLogger(PropertiesUtils.class);
    private static PropertiesUtils instance = null;
    private Map<String, Properties> resMap = new HashMap<String, Properties>();

    protected Properties initProperties(String path) {
        Properties properties = new Properties();
        try {
            InputStream is = super.getClass().getResourceAsStream(path);
            properties.load(is);
            this.resMap.put(path, properties);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return properties;
    }

    public Properties getProperties(String path) {
        if (this.resMap.get(path) == null) {
            return this.initProperties(path);
        }
        return this.resMap.get(path);
    }

    public static void writeProperties(Properties props, String profilepath, String keyname, String keyvalue) {
        try {
            FileOutputStream fos = new FileOutputStream(profilepath);
            props.setProperty(keyname, keyvalue);
            props.store(fos, "Update '" + keyname + "' value");
        }
        catch (IOException e) {
            System.err.println("\u5c5e\u6027\u6587\u4ef6\u66f4\u65b0\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertiesUtils getInstance() {
        if (instance != null) return instance;
        Class<PropertiesUtils> clazz = PropertiesUtils.class;
        synchronized (PropertiesUtils.class) {
            if (instance != null) return instance;
            instance = new PropertiesUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

