/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.widgetx.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.permission.app.service.IAppGroupService;
import com.yyjz.icop.permission.app.vo.AppGroupVO;
import com.yyjz.icop.widgetx.entity.WidgetCategoryEntity;
import com.yyjz.icop.widgetx.repository.WidgetXCategoryDao;
import com.yyjz.icop.widgetx.service.IWidgetXCategoryService;
import com.yyjz.icop.widgetx.vo.WidgetCategoryVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="widgetXCategoryService")
public class WidgetXCategoryServiceImpl
implements IWidgetXCategoryService {
    @Autowired
    private WidgetXCategoryDao dao;
    @Autowired
    private IAppGroupService appGroupService;

    public WidgetCategoryVO saveWidget(WidgetCategoryVO vo) throws Exception {
        WidgetCategoryEntity e = new WidgetCategoryEntity();
        BeanUtils.copyProperties((Object)vo, (Object)e);
        e = (WidgetCategoryEntity)this.dao.save(e);
        BeanUtils.copyProperties((Object)e, (Object)vo);
        return vo;
    }

    public WidgetCategoryVO findWidgetCategoryByID(String id) {
        WidgetCategoryEntity e = this.dao.findWidgetCategoryByID(id);
        WidgetCategoryVO vo = new WidgetCategoryVO();
        BeanUtils.copyProperties((Object)e, (Object)vo);
        return vo;
    }

    public List<WidgetCategoryVO> findAllCategory() {
        ArrayList<WidgetCategoryVO> vos = new ArrayList<WidgetCategoryVO>();
        List<WidgetCategoryEntity> es = this.dao.findAllWidgetCategory();
        for (WidgetCategoryEntity e : es) {
            WidgetCategoryVO v = new WidgetCategoryVO();
            BeanUtils.copyProperties((Object)e, (Object)v);
            vos.add(v);
        }
        return vos;
    }

    public List<WidgetCategoryVO> findAppGroups(String searchWord) {
        String tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new RuntimeException("tenantId \u4e3a null");
        }
        List appGroups = this.appGroupService.searchAppGroup(searchWord);
        ArrayList<WidgetCategoryVO> categoryVOS = new ArrayList<WidgetCategoryVO>();
        for (int i = 0; i < appGroups.size(); ++i) {
            AppGroupVO appGroupVO = (AppGroupVO)appGroups.get(i);
            String appGroupCode = appGroupVO.getId();
            WidgetCategoryVO widgetCategoryVO = new WidgetCategoryVO();
            widgetCategoryVO.setCategoryId(appGroupCode);
            widgetCategoryVO.setId(appGroupCode);
            widgetCategoryVO.setName(appGroupVO.getGroupName());
            categoryVOS.add(widgetCategoryVO);
        }
        return categoryVOS;
    }

    public void delWidgetxGroup(String id) {
        WidgetCategoryEntity entity = this.dao.findWidgetCategoryByID(id);
        if (entity != null) {
            entity.setDr(1);
            this.dao.save(entity);
        }
    }
}

