/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.widgetx.service.impl;

import com.yyjz.icop.widgetx.entity.WidgetEntity;
import java.util.ArrayList;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class WidgetXSpecification
implements Specification<WidgetEntity> {
    private Integer delete = new Integer(0);
    private String searchParam;
    private Map<String, Object> relyCondition;

    public WidgetXSpecification(String param) {
        this.searchParam = param;
    }

    public WidgetXSpecification(String param, Map<String, Object> relyCondition) {
        this.searchParam = param;
        this.relyCondition = relyCondition;
    }

    public Predicate toPredicate(Root<WidgetEntity> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)this.searchParam)) {
            Predicate p1 = cb.like(root.get("name").as(String.class), cb.literal((Object)("%" + this.searchParam + "%")));
            Predicate p2 = cb.like(root.get("id").as(String.class), cb.literal((Object)("%" + this.searchParam + "%")));
            list.add(cb.or((Expression)p1, (Expression)p2));
        }
        if (this.relyCondition != null) {
            for (Map.Entry<String, Object> entry : this.relyCondition.entrySet()) {
                String key = entry.getKey();
                String[] keySplit = key.split("_");
                String entryValue = entry.getValue().toString();
                String string = entryValue = entryValue.startsWith("'") && entryValue.endsWith("'") ? entryValue.substring(1, entryValue.length() - 1) : entryValue;
                if (!"EQ".equals(keySplit[0])) continue;
                if ("widgetProperty".equals(keySplit[1].toString())) {
                    list.add(cb.or((Expression)cb.equal(root.get("property").as(String.class), (Object)entryValue), (Expression)cb.equal(root.get("property").as(String.class), (Object)"0")));
                    continue;
                }
                if ("widgetType".equals(keySplit[1].toString())) {
                    list.add(cb.or((Expression)cb.equal(root.get("type").as(String.class), (Object)entryValue), (Expression)cb.equal(root.get("type").as(String.class), (Object)"0")));
                    continue;
                }
                if ("category".equals(keySplit[1].toString())) {
                    list.add(cb.equal(root.get("category").as(String.class), (Object)entryValue));
                    continue;
                }
                if ("widgetIds".equals(keySplit[1].toString())) {
                    list.add(cb.not((Expression)root.get("widgetId").in((Object[])entryValue.split(","))));
                    continue;
                }
                if ("roleWidgetIds".equals(keySplit[1].toString())) {
                    list.add(cb.and(new Predicate[]{root.get("widgetId").in((Object[])entryValue.split(","))}));
                    continue;
                }
                if (!"magnetType".equals(keySplit[1].toString())) continue;
                list.add(cb.equal(root.get("magnetType").as(String.class), (Object)entryValue));
            }
        }
        list.add(cb.and(new Predicate[]{cb.equal(root.get("dr").as(Integer.class), (Object)0)}));
        Predicate[] predicates = new Predicate[list.size()];
        query.where(list.toArray(predicates));
        ArrayList<Order> orderlist = new ArrayList<Order>();
        orderlist.add(cb.asc(root.get("category").as(String.class)));
        orderlist.add(cb.asc(root.get("id").as(String.class)));
        query.orderBy(orderlist);
        return query.getRestriction();
    }
}

