/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.widgetx.web;

import iuap.portal.drive.MockRequest;
import iuap.portal.drive.MockResponse;
import iuap.portal.layout.LayoutRequestService;
import iuap.portal.layout.Widget;
import iuap.portal.web.BaseController;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class WidgetParseController
extends BaseController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private LayoutRequestService layoutRequest;

    @RequestMapping(method={RequestMethod.GET}, value={"/data:widget/{insertAreaId}/{widgetId}"})
    public void renderWidget(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="insertAreaId") String insertAreaId, @PathVariable(value="widgetId") String widgetId) throws IOException {
        response.addIntHeader("Expires", 0);
        Widget widget = this.layoutRequest.getWidget(widgetId);
        if (widget == null) {
            response.getWriter().write("define([], function () {return { init: function (){  alert('\u5c0f\u90e8\u4ef6" + widgetId + "\u4e0d\u5b58\u5728'); }};});");
            return;
        }
        String requestBody = this.layoutRequest.getWidgetRequestBody(widget);
        String widgetMeta = this.render(requestBody, request, response);
        String script = widget.getScript();
        String json = script.replace("'_$$$_$$$_'", widgetMeta).replace("widget-content", insertAreaId);
        response.getWriter().write(json);
    }

    private String render(String requestBody, HttpServletRequest request, HttpServletResponse response) {
        MockResponse mockResponse = new MockResponse(response);
        try {
            MockRequest mr = new MockRequest(request);
            mr.setContentType("application/json");
            mr.setRequestBody(requestBody);
            mr.getRequestDispatcher("/rpc").forward((ServletRequest)mr, (ServletResponse)mockResponse);
            mockResponse.flushBuffer();
        }
        catch (ServletException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return this.processEnvInfo(mockResponse.getString(), request);
    }

    private String processEnvInfo(String widgetInfo, HttpServletRequest request) {
        return widgetInfo.replace("${context}", request.getContextPath());
    }
}

