/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.basic.ArrayType;
import org.apache.cxf.aegis.type.basic.ObjectType;
import org.apache.cxf.aegis.type.collection.CollectionType;
import org.apache.cxf.aegis.type.collection.MapType;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.aegis.util.ServiceUtils;
import org.apache.cxf.common.util.XMLSchemaQNames;

public abstract class AbstractTypeCreator
implements TypeCreator {
    public static final String HTTP_CXF_APACHE_ORG_ARRAYS = "http://cxf.apache.org/arrays";
    protected TypeMapping tm;
    protected AbstractTypeCreator nextCreator;
    private TypeCreationOptions typeConfiguration;
    private TypeCreator parent;

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public TypeCreator getTopCreator() {
        AbstractTypeCreator top;
        TypeCreator next = top = this;
        while (next != null) {
            top = next;
            next = top.getParent();
        }
        return top;
    }

    public TypeCreator getParent() {
        return this.parent;
    }

    public void setParent(TypeCreator parent) {
        this.parent = parent;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
        if (this.nextCreator != null) {
            this.nextCreator.setTypeMapping(this.tm);
        }
    }

    public void setNextCreator(AbstractTypeCreator creator) {
        this.nextCreator = creator;
        this.nextCreator.parent = this;
    }

    public TypeClassInfo createClassInfo(Field f) {
        TypeClassInfo info = this.createBasicClassInfo((Class)f.getType());
        info.setDescription("field " + f.getName() + " in  " + f.getDeclaringClass());
        return info;
    }

    public TypeClassInfo createBasicClassInfo(Class typeClass) {
        TypeClassInfo info = new TypeClassInfo();
        info.setDescription("class '" + typeClass.getName() + '\'');
        info.setTypeClass(typeClass);
        return info;
    }

    public Type createTypeForClass(TypeClassInfo info) {
        Class javaType = info.getTypeClass();
        Type result = null;
        boolean newType = true;
        if (info.getType() != null) {
            result = this.createUserType(info);
        } else if (this.isArray(javaType)) {
            result = this.createArrayType(info);
        } else if (this.isMap(javaType)) {
            result = this.createMapType(info);
        } else if (this.isHolder(javaType)) {
            result = this.createHolderType(info);
        } else if (this.isCollection(javaType)) {
            result = this.createCollectionType(info);
        } else if (this.isEnum(javaType)) {
            result = this.createEnumType(info);
        } else {
            Type type = this.getTypeMapping().getType(javaType);
            if (type == null) {
                if (info.getTypeName() != null) {
                    type = this.getTypeMapping().getType(info.getTypeName());
                }
                if (type == null) {
                    type = this.createDefaultType(info);
                } else {
                    newType = false;
                }
            } else {
                newType = false;
            }
            result = type;
        }
        if (newType && !this.getConfiguration().isDefaultNillable()) {
            result.setNillable(false);
        }
        return result;
    }

    protected boolean isHolder(Class javaType) {
        return "javax.xml.ws.Holder".equals(javaType.getName());
    }

    protected Type createHolderType(TypeClassInfo info) {
        if (info.getGenericType() == null) {
            throw new UnsupportedOperationException("To use holder types you must have an XML descriptor declaring the component type.");
        }
        Class heldCls = (Class)info.getGenericType();
        info.setTypeClass(heldCls);
        return this.createType(heldCls);
    }

    protected boolean isArray(Class javaType) {
        return javaType.isArray() && !javaType.equals(byte[].class);
    }

    protected Type createUserType(TypeClassInfo info) {
        try {
            Type type = (Type)info.getType().newInstance();
            QName name = info.getTypeName();
            if (name == null) {
                if (info.getTypeClass().getPackage().getName().startsWith("java")) {
                    name = this.tm.getTypeQName(info.getTypeClass());
                }
                if (name == null) {
                    name = this.createQName(info.getTypeClass());
                }
            }
            type.setSchemaType(name);
            type.setTypeClass(info.getTypeClass());
            type.setTypeMapping(this.getTypeMapping());
            return type;
        }
        catch (InstantiationException e) {
            throw new DatabindingException("Couldn't instantiate type classs " + info.getType().getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DatabindingException("Couldn't access type classs " + info.getType().getName(), (Throwable)e);
        }
    }

    protected Type createArrayType(TypeClassInfo info) {
        ArrayType type = new ArrayType();
        type.setTypeMapping(this.getTypeMapping());
        type.setTypeClass(info.getTypeClass());
        type.setSchemaType(this.createCollectionQName(info, type.getComponentType()));
        if (info.getMinOccurs() != -1L) {
            type.setMinOccurs(info.getMinOccurs());
        } else {
            type.setMinOccurs(this.typeConfiguration.getDefaultMinOccurs());
        }
        if (info.getMaxOccurs() != -1L) {
            type.setMaxOccurs(info.getMaxOccurs());
        }
        type.setFlat(info.isFlat());
        return type;
    }

    protected QName createQName(Class javaType) {
        String clsName = javaType.getName();
        String ns = NamespaceHelper.makeNamespaceFromClassName(clsName, "http");
        String localName = ServiceUtils.makeServiceNameFromClassName(javaType);
        return new QName(ns, localName);
    }

    protected boolean isCollection(Class javaType) {
        return Collection.class.isAssignableFrom(javaType);
    }

    protected Type createCollectionTypeFromGeneric(TypeClassInfo info) {
        Type component = this.getOrCreateGenericType(info);
        CollectionType type = new CollectionType(component);
        type.setTypeMapping(this.getTypeMapping());
        QName name = info.getTypeName();
        if (name == null) {
            name = this.createCollectionQName(info, component);
        }
        type.setSchemaType(name);
        type.setTypeClass(info.getTypeClass());
        if (info.getMinOccurs() != -1L) {
            type.setMinOccurs(info.getMinOccurs());
        }
        if (info.getMaxOccurs() != -1L) {
            type.setMaxOccurs(info.getMaxOccurs());
        }
        type.setFlat(info.isFlat());
        return type;
    }

    protected Type getOrCreateGenericType(TypeClassInfo info) {
        return this.createObjectType();
    }

    protected Type getOrCreateMapKeyType(TypeClassInfo info) {
        return this.nextCreator.getOrCreateMapKeyType(info);
    }

    protected Type createObjectType() {
        ObjectType type = new ObjectType();
        type.setSchemaType(XMLSchemaQNames.XSD_ANY);
        type.setTypeClass(Object.class);
        type.setTypeMapping(this.getTypeMapping());
        return type;
    }

    protected Type getOrCreateMapValueType(TypeClassInfo info) {
        return this.nextCreator.getOrCreateMapValueType(info);
    }

    protected Type createMapType(TypeClassInfo info, Type keyType, Type valueType) {
        QName schemaType = this.createMapQName(info, keyType, valueType);
        MapType type = new MapType(schemaType, keyType, valueType);
        type.setTypeMapping(this.getTypeMapping());
        type.setTypeClass(info.getTypeClass());
        return type;
    }

    protected Type createMapType(TypeClassInfo info) {
        Type keyType = this.getOrCreateMapKeyType(info);
        Type valueType = this.getOrCreateMapValueType(info);
        return this.createMapType(info, keyType, valueType);
    }

    protected QName createMapQName(TypeClassInfo info, Type keyType, Type valueType) {
        String name = keyType.getSchemaType().getLocalPart() + '2' + valueType.getSchemaType().getLocalPart() + "Map";
        return new QName(this.tm.getMappingIdentifierURI(), name);
    }

    protected boolean isMap(Class javaType) {
        return Map.class.isAssignableFrom(javaType);
    }

    public abstract TypeClassInfo createClassInfo(PropertyDescriptor var1);

    protected boolean isEnum(Class javaType) {
        return false;
    }

    public Type createEnumType(TypeClassInfo info) {
        return null;
    }

    public abstract Type createCollectionType(TypeClassInfo var1);

    public abstract Type createDefaultType(TypeClassInfo var1);

    protected QName createCollectionQName(TypeClassInfo info, Type type) {
        String ns = type.isComplex() ? type.getSchemaType().getNamespaceURI() : this.tm.getMappingIdentifierURI();
        if ("http://www.w3.org/2001/XMLSchema".equals(ns)) {
            ns = HTTP_CXF_APACHE_ORG_ARRAYS;
        }
        String first = type.getSchemaType().getLocalPart().substring(0, 1);
        String last = type.getSchemaType().getLocalPart().substring(1);
        String localName = "ArrayOf" + first.toUpperCase() + last;
        if (info.nonDefaultAttributes()) {
            localName = localName + "-";
            if (info.getMinOccurs() >= 0L) {
                localName = localName + info.getMinOccurs();
            }
            localName = localName + "-";
            if (info.getMaxOccurs() >= 0L) {
                localName = localName + info.getMaxOccurs();
            }
            if (info.isFlat()) {
                localName = localName + "Flat";
            }
        }
        return new QName(ns, localName);
    }

    public abstract TypeClassInfo createClassInfo(Method var1, int var2);

    public Type createType(Method m, int index) {
        TypeClassInfo info = this.createClassInfo(m, index);
        info.setDescription((index == -1 ? "return type" : "parameter " + index) + " of method " + m.getName() + " in " + m.getDeclaringClass());
        return this.createTypeForClass(info);
    }

    public QName getElementName(Method m, int index) {
        TypeClassInfo info = this.createClassInfo(m, index);
        return info.getMappedName();
    }

    public Type createType(PropertyDescriptor pd) {
        TypeClassInfo info = this.createClassInfo(pd);
        info.setDescription("property " + pd.getName());
        return this.createTypeForClass(info);
    }

    public Type createType(Field f) {
        TypeClassInfo info = this.createClassInfo(f);
        info.setDescription("field " + f.getName() + " in " + f.getDeclaringClass());
        return this.createTypeForClass(info);
    }

    public Type createType(java.lang.reflect.Type t) {
        TypeClassInfo info = new TypeClassInfo();
        info.setGenericType(t);
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            java.lang.reflect.Type rawType = pt.getRawType();
            if (rawType instanceof Class) {
                info.setTypeClass((Class)rawType);
            }
        } else if (t instanceof Class) {
            info.setTypeClass((Class)t);
        }
        info.setDescription("reflected type " + t.toString());
        return this.createTypeForClass(info);
    }

    public Type createType(Class clazz) {
        TypeClassInfo info = this.createBasicClassInfo(clazz);
        info.setDescription(clazz.toString());
        return this.createTypeForClass(info);
    }

    public TypeCreationOptions getConfiguration() {
        return this.typeConfiguration;
    }

    public void setConfiguration(TypeCreationOptions tpConfiguration) {
        this.typeConfiguration = tpConfiguration;
    }
}

