/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSClientFactoryBean
extends AbstractJAXRSFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSClientFactoryBean.class);
    private String username;
    private String password;
    private boolean inheritHeaders;
    private MultivaluedMap<String, String> headers;

    public JAXRSClientFactoryBean() {
        this(new JAXRSServiceFactoryBean());
    }

    public JAXRSClientFactoryBean(JAXRSServiceFactoryBean serviceFactory) {
        super(serviceFactory);
        serviceFactory.setEnableStaticResolution(true);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInheritHeaders(boolean ih) {
        this.inheritHeaders = ih;
    }

    public void setResourceClass(Class cls) {
        this.setServiceClass(cls);
    }

    public void setServiceClass(Class cls) {
        this.serviceFactory.setResourceClass(cls);
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = new MetadataMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] values;
            for (String v : values = entry.getValue().split(",")) {
                if (v.length() == 0) continue;
                this.headers.add((Object)entry.getKey(), (Object)v);
            }
        }
    }

    public Map getHeaders() {
        return this.headers;
    }

    public WebClient createWebClient() {
        JAXRSServiceImpl service = new JAXRSServiceImpl(this.getAddress());
        this.getServiceFactory().setService(service);
        try {
            Endpoint ep = this.createEndpoint();
            WebClient client = new WebClient(this.getAddress());
            this.initClient(client, ep);
            return client;
        }
        catch (Exception ex) {
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    public <T> T create(Class<T> cls, Object ... varValues) {
        return cls.cast(this.createWithValues(varValues));
    }

    public Client create() {
        return this.createWithValues(new Object[0]);
    }

    public Client createWithValues(Object ... varValues) {
        this.checkResources(false);
        AbstractResourceInfo cri = null;
        try {
            Endpoint ep = this.createEndpoint();
            URI baseURI = URI.create(this.getAddress());
            cri = this.serviceFactory.getClassResourceInfo().get(0);
            boolean isRoot = ((ClassResourceInfo)cri).getURITemplate() != null;
            ClientProxyImpl proxyImpl = new ClientProxyImpl(baseURI, baseURI, (ClassResourceInfo)cri, isRoot, this.inheritHeaders, varValues);
            this.initClient(proxyImpl, ep);
            try {
                return (Client)ProxyHelper.getProxy(cri.getServiceClass().getClassLoader(), new Class[]{cri.getServiceClass(), Client.class, InvocationHandlerAware.class}, proxyImpl);
            }
            catch (Exception ex) {
                return (Client)ProxyHelper.getProxy(Thread.currentThread().getContextClassLoader(), new Class[]{cri.getServiceClass(), Client.class, InvocationHandlerAware.class}, proxyImpl);
            }
        }
        catch (IllegalArgumentException ex) {
            String expected;
            String message = ex.getLocalizedMessage();
            if (cri != null && ((expected = cri.getServiceClass().getSimpleName()) + " is not an interface").equals(message)) {
                message = message + "; make sure CGLIB is on the classpath";
            }
            LOG.severe(ex.getClass().getName() + " : " + message);
            throw ex;
        }
        catch (Exception ex) {
            LOG.severe(ex.getClass().getName() + " : " + ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    protected ConduitSelector getConduitSelector(Endpoint ep) {
        ConduitSelector cs = this.getConduitSelector();
        cs = cs == null ? new UpfrontConduitSelector() : cs;
        cs.setEndpoint(ep);
        return cs;
    }

    protected void initClient(AbstractClient client, Endpoint ep) {
        if (this.username != null) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(this.username);
            authPolicy.setPassword(this.password);
            ep.getEndpointInfo().addExtensor(authPolicy);
        }
        this.applyFeatures(client);
        client.getConfiguration().setConduitSelector(this.getConduitSelector(ep));
        client.getConfiguration().setBus(this.getBus());
        client.getConfiguration().getOutInterceptors().addAll(this.getOutInterceptors());
        client.getConfiguration().getInInterceptors().addAll(this.getInInterceptors());
        if (this.headers != null) {
            client.headers(this.headers);
        }
        this.setupFactory(ep);
    }

    protected void applyFeatures(AbstractClient client) {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(client.getConfiguration(), this.getBus());
            }
        }
    }
}

