/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.image;

import dev.langchain4j.data.image.Image;
import java.net.URI;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ImageTest
implements WithAssertions {
    ImageTest() {
    }

    @Test
    public void testBuilder() throws Exception {
        Image image = Image.builder().url(new URI("https://example.com/image.png")).base64Data("base64Data").mimeType("image/png").revisedPrompt("revisedPrompt").build();
        this.assertThat(image.url().toString()).isEqualTo("https://example.com/image.png");
        this.assertThat(image.base64Data()).isEqualTo("base64Data");
        this.assertThat(image.mimeType()).isEqualTo("image/png");
        this.assertThat(image.revisedPrompt()).isEqualTo("revisedPrompt");
        image = Image.builder().build();
        this.assertThat(image.url()).isNull();
        this.assertThat(image.base64Data()).isNull();
        this.assertThat(image.mimeType()).isNull();
        this.assertThat(image.revisedPrompt()).isNull();
        image = Image.builder().url("https://example.com/image.png").build();
        this.assertThat(image.url()).isEqualTo((Object)new URI("https://example.com/image.png"));
    }

    @Test
    public void test_toString() {
        Image image = Image.builder().url(URI.create("https://example.com/image.png")).base64Data("base64Data").mimeType("image/png").revisedPrompt("revisedPrompt").build();
        this.assertThat(image).hasToString("Image { url = \"https://example.com/image.png\", base64Data = \"base64Data\", mimeType = \"image/png\", revisedPrompt = \"revisedPrompt\" }");
    }

    @Test
    public void test_equals_hash() {
        Image image1 = Image.builder().url(URI.create("https://example.com/image.png")).base64Data("base64Data").mimeType("image/png").revisedPrompt("revisedPrompt").build();
        Image image2 = Image.builder().url(URI.create("https://example.com/image.png")).base64Data("base64Data").mimeType("image/png").revisedPrompt("revisedPrompt").build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(image1).isEqualTo((Object)image1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)image2)).hasSameHashCodeAs((Object)image2);
        ((ObjectAssert)this.assertThat(Image.builder().url(URI.create("https://change")).base64Data("base64Data").mimeType("image/png").revisedPrompt("revisedPrompt").build()).isNotEqualTo((Object)image1)).doesNotHaveSameHashCodeAs((Object)image1);
        ((ObjectAssert)this.assertThat(Image.builder().url(URI.create("https://example.com/image.png")).base64Data("changed").mimeType("image/png").revisedPrompt("revisedPrompt").build()).isNotEqualTo((Object)image1)).doesNotHaveSameHashCodeAs((Object)image1);
        ((ObjectAssert)this.assertThat(Image.builder().url(URI.create("https://example.com/image.png")).base64Data("base64Data").mimeType("changed").revisedPrompt("revisedPrompt").build()).isNotEqualTo((Object)image1)).doesNotHaveSameHashCodeAs((Object)image1);
        ((ObjectAssert)this.assertThat(Image.builder().url(URI.create("https://example.com/image.png")).base64Data("base64Data").mimeType("image/png").revisedPrompt("changed").build()).isNotEqualTo((Object)image1)).doesNotHaveSameHashCodeAs((Object)image1);
    }
}

