/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import com.google.gson.JsonSyntaxException;
import dev.langchain4j.internal.GsonJsonCodec;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.WithAssertions;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.Test;

class GsonJsonCodecTest
implements WithAssertions {
    GsonJsonCodecTest() {
    }

    private static String readAllBytes(InputStream stream) throws IOException {
        int n;
        StringBuilder sb = new StringBuilder();
        byte[] buf = new byte[1024];
        while ((n = stream.read(buf)) >= 0) {
            sb.append(new String(buf, 0, n));
        }
        return sb.toString();
    }

    @Test
    public void test() throws Exception {
        GsonJsonCodec codec = new GsonJsonCodec();
        Example example = new Example("John", 42);
        this.assertThat((Example)codec.fromJson(codec.toJson((Object)example), Example.class)).isEqualTo((Object)example);
        InputStream inputStream = codec.toInputStream((Object)example, Example.class);
        this.assertThat((Example)codec.fromJson(GsonJsonCodecTest.readAllBytes(inputStream), Example.class)).isEqualTo((Object)example);
    }

    @Test
    public void test_map() {
        GsonJsonCodec codec = new GsonJsonCodec();
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put("a", "b");
        this.assertThat(codec.toJson(expectedMap)).isEqualTo("{\n  \"a\": \"b\"\n}");
        this.assertThat(codec.fromJson("{\"a\": \"b\"}", expectedMap.getClass())).isEqualTo(expectedMap);
        Map map = (Map)codec.fromJson("{\"a\": [1, 2]}", Map.class);
        this.assertThat(map).containsExactly(new Map.Entry[]{MapEntry.entry((Object)"a", Arrays.asList(1.0, 2.0))});
    }

    @Test
    public void test_datetime() {
        GsonJsonCodec codec = new GsonJsonCodec();
        DateExample example = new DateExample(LocalDate.of(2019, 1, 1), LocalDateTime.of(2019, 1, 1, 0, 0, 0));
        this.assertThat(codec.toJson((Object)example)).isEqualTo("{\n  \"localDate\": \"2019-01-01\",\n  \"localDateTime\": \"2019-01-01T00:00:00\"\n}");
        this.assertThat((DateExample)codec.fromJson(codec.toJson((Object)example), DateExample.class)).isEqualTo((Object)example);
    }

    @Test
    public void test_broken() {
        GsonJsonCodec codec = new GsonJsonCodec();
        this.assertThatExceptionOfType(JsonSyntaxException.class).isThrownBy(() -> codec.fromJson("abc", Integer.class));
        this.assertThatExceptionOfType(ClassCastException.class).isThrownBy(() -> {
            try (InputStream ignored = codec.toInputStream((Object)"abc", Integer.class);){
                this.fail("should not reach here");
            }
        });
    }

    public static class Example {
        public String name;
        public int age;

        public Example(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Example)) {
                return false;
            }
            Example example = (Example)o;
            return this.age == example.age && this.name.equals(example.name);
        }
    }

    public static class DateExample {
        public LocalDate localDate;
        public LocalDateTime localDateTime;

        public DateExample(LocalDate localDate, LocalDateTime localDateTime) {
            this.localDate = localDate;
            this.localDateTime = localDateTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DateExample)) {
                return false;
            }
            DateExample that = (DateExample)o;
            return this.localDate.equals(that.localDate) && this.localDateTime.equals(that.localDateTime);
        }
    }
}

