/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.model.ExampleTestTokenizer;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class TokenizerTest
implements WithAssertions {
    TokenizerTest() {
    }

    @Test
    public void test_estimateTokenCountInTools() throws Exception {
        ExampleTestTokenizer tokenizer = new ExampleTestTokenizer();
        ExampleTools exampleTools = new ExampleTools();
        this.assertThat(tokenizer.estimateTokenCountInTools(exampleTools)).isEqualTo(6);
        this.assertThat(tokenizer.estimateTokenCountInTools(Arrays.asList(exampleTools, exampleTools))).isEqualTo(12);
        this.assertThat(tokenizer.estimateTokenCountInForcefulToolExecutionRequest(ToolExecutionRequest.builder().id("id").name("name").arguments("foo bar baz").build())).isEqualTo(3);
        this.assertThat(tokenizer.estimateTokenCountInForcefulToolSpecification(ToolSpecifications.toolSpecificationFrom((Method)ExampleTools.class.getMethod("launchRockets", new Class[0])))).isEqualTo(3);
    }

    public static class ExampleTools {
        @Tool(name="launch", value={"Launch the rockets"})
        public void launchRockets() {
        }

        @Tool(name="abort", value={"Abort the rockets"})
        public void abortRockets() {
        }
    }
}

