/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.aggregator;

import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.scoring.ScoringModel;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.aggregator.ContentAggregator;
import dev.langchain4j.rag.content.aggregator.ReRankingContentAggregator;
import dev.langchain4j.rag.query.Query;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ReRankingContentAggregatorTest {
    ReRankingContentAggregatorTest() {
    }

    @ParameterizedTest
    @MethodSource
    void should_rerank_when_single_query_and_single_contents(Function<ScoringModel, ContentAggregator> contentAggregatorProvider) {
        Query query = Query.from((String)"query");
        Content content1 = Content.from((String)"content 1");
        Content content2 = Content.from((String)"content 2");
        Map<Query, List<List<Content>>> queryToContents = Collections.singletonMap(query, Collections.singletonList(Arrays.asList(content1, content2)));
        ScoringModel scoringModel = (ScoringModel)Mockito.mock(ScoringModel.class);
        Mockito.when((Object)scoringModel.scoreAll((List)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)Response.from(Arrays.asList(0.5, 0.7)));
        ContentAggregator aggregator = contentAggregatorProvider.apply(scoringModel);
        List aggregated = aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).containsExactly((Object[])new Content[]{content2, content1});
    }

    static Stream<Arguments> should_rerank_when_single_query_and_single_contents() {
        return Stream.builder().add(Arguments.of((Object[])new Object[]{ReRankingContentAggregator::new})).add(Arguments.of((Object[])new Object[]{scoringModel -> ReRankingContentAggregator.builder().scoringModel(scoringModel).build()})).build();
    }

    @Test
    void should_fuse_then_rerank_when_single_query_and_multiple_contents() {
        Query query = Query.from((String)"query");
        Content content1 = Content.from((String)"content 1");
        Content content2 = Content.from((String)"content");
        Content content3 = Content.from((String)"content");
        Content content4 = Content.from((String)"content 4");
        Map<Query, List<List>> queryToContents = Collections.singletonMap(query, Arrays.asList(Arrays.asList(content1, content2), Arrays.asList(content3, content4)));
        ScoringModel scoringModel = (ScoringModel)Mockito.mock(ScoringModel.class);
        Mockito.when((Object)scoringModel.scoreAll(Arrays.asList(content2.textSegment(), content1.textSegment(), content4.textSegment()), query.text())).thenReturn((Object)Response.from(Arrays.asList(0.5, 0.7, 0.9)));
        ReRankingContentAggregator aggregator = new ReRankingContentAggregator(scoringModel);
        List aggregated = aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).containsExactly((Object[])new Content[]{content4, content1, content2});
    }

    @Test
    void should_fail_when_multiple_queries_with_default_query_selector() {
        HashMap<Query, Object> queryToContents = new HashMap<Query, Object>();
        queryToContents.put(Query.from((String)"query 1"), null);
        queryToContents.put(Query.from((String)"query 2"), null);
        ScoringModel scoringModel = (ScoringModel)Mockito.mock(ScoringModel.class);
        ReRankingContentAggregator aggregator = new ReRankingContentAggregator(scoringModel);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ReRankingContentAggregatorTest.lambda$should_fail_when_multiple_queries_with_default_query_selector$1((ContentAggregator)aggregator, queryToContents)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("The 'queryToContents' contains 2 queries, making the re-ranking ambiguous. Because there are multiple queries, it is unclear which one should be used for re-ranking. Please provide a 'querySelector' in the constructor/builder.");
    }

    @Test
    void should_fuse_then_rerank_against_first_query_then_filter_by_minScore() {
        Function<Map, Query> querySelector = q -> (Query)q.keySet().iterator().next();
        double minScore = 0.4;
        Query query1 = Query.from((String)"query 1");
        Content content1 = Content.from((String)"content");
        Content content2 = Content.from((String)"content 2");
        Content content3 = Content.from((String)"content 3");
        Content content4 = Content.from((String)"content");
        Query query2 = Query.from((String)"query 2");
        Content content5 = Content.from((String)"content 5");
        Content content6 = Content.from((String)"content");
        Content content7 = Content.from((String)"content");
        Content content8 = Content.from((String)"content 8");
        LinkedHashMap<Query, List<List>> queryToContents = new LinkedHashMap<Query, List<List>>();
        queryToContents.put(query1, Arrays.asList(Arrays.asList(content1, content2), Arrays.asList(content3, content4)));
        queryToContents.put(query2, Arrays.asList(Arrays.asList(content5, content6), Arrays.asList(content7, content8)));
        ScoringModel scoringModel = (ScoringModel)Mockito.mock(ScoringModel.class);
        Mockito.when((Object)scoringModel.scoreAll(Arrays.asList(content1.textSegment(), content3.textSegment(), content5.textSegment(), content2.textSegment(), content8.textSegment()), query1.text())).thenReturn((Object)Response.from(Arrays.asList(0.6, 0.2, 0.3, 0.4, 0.5)));
        ReRankingContentAggregator aggregator = new ReRankingContentAggregator(scoringModel, querySelector, Double.valueOf(minScore));
        List aggregated = aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).containsExactly((Object[])new Content[]{content1, content8, content2});
    }

    @ParameterizedTest
    @MethodSource
    void should_return_empty_list_when_there_is_no_content_to_rerank(Map<Query, Collection<List<Content>>> queryToContents) {
        ScoringModel scoringModel = (ScoringModel)Mockito.mock(ScoringModel.class);
        ReRankingContentAggregator aggregator = new ReRankingContentAggregator(scoringModel);
        List aggregated = aggregator.aggregate(queryToContents);
        Assertions.assertThat((List)aggregated).isEmpty();
        Mockito.verifyNoInteractions((Object[])new Object[]{scoringModel});
    }

    private static Stream<Arguments> should_return_empty_list_when_there_is_no_content_to_rerank() {
        return Stream.builder().add(Arguments.of((Object[])new Object[]{Collections.emptyMap()})).add(Arguments.of((Object[])new Object[]{Collections.singletonMap(Query.from((String)"query"), Collections.emptyList())})).add(Arguments.of((Object[])new Object[]{Collections.singletonMap(Query.from((String)"query"), Collections.singletonList(Collections.emptyList()))})).add(Arguments.of((Object[])new Object[]{Collections.singletonMap(Query.from((String)"query"), Arrays.asList(Collections.emptyList(), Collections.emptyList()))})).build();
    }

    private static /* synthetic */ void lambda$should_fail_when_multiple_queries_with_default_query_selector$1(ContentAggregator aggregator, Map queryToContents) throws Throwable {
        aggregator.aggregate(queryToContents);
    }
}

