/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.retriever;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.retriever.WebSearchContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class WebSearchContentRetrieverTest {
    WebSearchEngine webSearchEngine;

    WebSearchContentRetrieverTest() {
    }

    @BeforeEach
    void mockWebSearchEngine() {
        this.webSearchEngine = (WebSearchEngine)Mockito.mock(WebSearchEngine.class);
        Mockito.when((Object)this.webSearchEngine.search((WebSearchRequest)Mockito.any(WebSearchRequest.class))).thenReturn((Object)new WebSearchResults(WebSearchInformationResult.from((Long)3L, (Integer)1, new HashMap()), Arrays.asList(WebSearchOrganicResult.from((String)"title 1", (URI)URI.create("https://one.com"), (String)"snippet 1", null), WebSearchOrganicResult.from((String)"title 2", (URI)URI.create("https://two.com"), null, (String)"content 2"), WebSearchOrganicResult.from((String)"title 3", (URI)URI.create("https://three.com"), (String)"snippet 3", (String)"content 3"), WebSearchOrganicResult.from((String)"title 4", (URI)URI.create("https://four.com"), (String)"snippet 4", (String)"content 4"), WebSearchOrganicResult.from((String)"title 5", (URI)URI.create("https://five.com"), (String)"snippet 5", (String)"content 5"))));
    }

    @AfterEach
    void resetWebSearchEngine() {
        Mockito.reset((Object[])new WebSearchEngine[]{this.webSearchEngine});
    }

    @Test
    void should_retrieve_web_pages_back() {
        WebSearchContentRetriever contentRetriever = WebSearchContentRetriever.builder().webSearchEngine(this.webSearchEngine).build();
        Query query = Query.from((String)"query");
        List contents = contentRetriever.retrieve(query);
        Assertions.assertThat((List)contents).containsExactly((Object[])new Content[]{Content.from((TextSegment)TextSegment.from((String)"title 1\nsnippet 1", (Metadata)Metadata.from((String)"url", (String)"https://one.com"))), Content.from((TextSegment)TextSegment.from((String)"title 2\ncontent 2", (Metadata)Metadata.from((String)"url", (String)"https://two.com"))), Content.from((TextSegment)TextSegment.from((String)"title 3\ncontent 3", (Metadata)Metadata.from((String)"url", (String)"https://three.com"))), Content.from((TextSegment)TextSegment.from((String)"title 4\ncontent 4", (Metadata)Metadata.from((String)"url", (String)"https://four.com"))), Content.from((TextSegment)TextSegment.from((String)"title 5\ncontent 5", (Metadata)Metadata.from((String)"url", (String)"https://five.com")))});
        ((WebSearchEngine)Mockito.verify((Object)this.webSearchEngine)).search(WebSearchRequest.builder().searchTerms(query.text()).maxResults(Integer.valueOf(5)).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.webSearchEngine});
    }
}

