/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query.transformer;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.mock.ChatModelMock;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.rag.query.transformer.ExpandingQueryTransformer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ExpandingQueryTransformerTest {
    ExpandingQueryTransformerTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"query 1\nquery 2\nquery 3", "query 1\n\nquery 2\n\nquery 3"})
    void should_expand_query(String queriesString) {
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Hi"), AiMessage.from((String)"Hello"));
        UserMessage userMessage = UserMessage.from((String)"query");
        Metadata metadata = Metadata.from((UserMessage)userMessage, (Object)"default", chatMemory);
        Query query = Query.from((String)userMessage.singleText(), (Metadata)metadata);
        ChatModelMock model = ChatModelMock.thatAlwaysResponds(queriesString);
        ExpandingQueryTransformer transformer = new ExpandingQueryTransformer((ChatLanguageModel)model);
        Collection queries = transformer.transform(query);
        Assertions.assertThat((Collection)queries).containsExactly((Object[])new Query[]{Query.from((String)"query 1", (Metadata)metadata), Query.from((String)"query 2", (Metadata)metadata), Query.from((String)"query 3", (Metadata)metadata)});
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Generate 3 different versions of a provided user query. Each version should be worded differently, using synonyms or alternative sentence structures, but they should all retain the original meaning. These versions will be used to retrieve relevant documents. It is very important to provide each query version on a separate line, without enumerations, hyphens, or any additional formatting!\nUser query: query");
    }

    @Test
    void should_expand_query_with_custom_N() {
        int n = 5;
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("does not matter");
        ExpandingQueryTransformer transformer = new ExpandingQueryTransformer((ChatLanguageModel)model, n);
        Query query = Query.from((String)"query");
        transformer.transform(query);
        Assertions.assertThat((String)model.userMessageText()).contains(new CharSequence[]{"Generate 5 different versions"});
    }

    @Test
    void should_expand_query_with_custom_prompt_template() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"Generate 7 variations of {{query}}");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("does not matter");
        ExpandingQueryTransformer transformer = new ExpandingQueryTransformer((ChatLanguageModel)model, promptTemplate);
        Query query = Query.from((String)"query");
        transformer.transform(query);
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Generate 7 variations of query");
    }

    @Test
    void should_expand_query_with_custom_prompt_template_and_n_builder() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"Generate {{n}} variations of {{query}}");
        ChatModelMock model = ChatModelMock.thatAlwaysResponds("does not matter");
        ExpandingQueryTransformer transformer = ExpandingQueryTransformer.builder().chatLanguageModel((ChatLanguageModel)model).promptTemplate(promptTemplate).n(Integer.valueOf(7)).build();
        Query query = Query.from((String)"query");
        transformer.transform(query);
        Assertions.assertThat((String)model.userMessageText()).isEqualTo("Generate 7 variations of query");
    }
}

