/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingStoreWithoutMetadataIT;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;

public abstract class EmbeddingStoreIT
extends EmbeddingStoreWithoutMetadataIT {
    static final UUID TEST_UUID = UUID.randomUUID();
    static final UUID TEST_UUID2 = UUID.randomUUID();

    @Test
    void should_add_embedding_with_segment_with_metadata() {
        Metadata metadata = this.createMetadata();
        TextSegment segment = TextSegment.from((String)"hello", (Metadata)metadata);
        Embedding embedding = (Embedding)this.embeddingModel().embed(segment.text()).content();
        String id = this.embeddingStore().add(embedding, (Object)segment);
        Assertions.assertThat((String)id).isNotBlank();
        TextSegment altSegment = TextSegment.from((String)"hello?");
        Embedding altEmbedding = (Embedding)this.embeddingModel().embed(altSegment.text()).content();
        this.embeddingStore().add(altEmbedding, (Object)altSegment);
        this.awaitUntilPersisted();
        List relevant = this.embeddingStore().findRelevant(embedding, 1);
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)match.embeddingId()).isEqualTo(id);
        Assertions.assertThat((Object)match.embedding()).isEqualTo((Object)embedding);
        Assertions.assertThat((String)((TextSegment)match.embedded()).text()).isEqualTo(segment.text());
        Assertions.assertThat((String)((TextSegment)match.embedded()).metadata().getString("string_empty")).isEqualTo("");
        Assertions.assertThat((String)((TextSegment)match.embedded()).metadata().getString("string_space")).isEqualTo(" ");
        Assertions.assertThat((String)((TextSegment)match.embedded()).metadata().getString("string_abc")).isEqualTo("abc");
        Assertions.assertThat((Comparable)((TextSegment)match.embedded()).metadata().getUUID("uuid")).isEqualTo((Object)TEST_UUID);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_min")).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_minus_1")).isEqualTo(-1);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_0")).isEqualTo(0);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_1")).isEqualTo(1);
        Assertions.assertThat((Integer)((TextSegment)match.embedded()).metadata().getInteger("integer_max")).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_min")).isEqualTo(Long.MIN_VALUE);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_minus_1")).isEqualTo(-1L);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_0")).isEqualTo(0L);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_1")).isEqualTo(1L);
        Assertions.assertThat((Long)((TextSegment)match.embedded()).metadata().getLong("long_max")).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_min")).isEqualTo(-3.4028235E38f);
        Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_minus_1")).isEqualTo(-1.0f);
        Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_0")).isEqualTo(Float.MIN_VALUE);
        Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_1")).isEqualTo(1.0f);
        Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_123")).isEqualTo(1.2345679f);
        Assertions.assertThat((Float)((TextSegment)match.embedded()).metadata().getFloat("float_max")).isEqualTo(Float.MAX_VALUE);
        Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_minus_1")).isEqualTo(-1.0);
        Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_0")).isEqualTo(Double.MIN_VALUE);
        Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_1")).isEqualTo(1.0);
        Assertions.assertThat((Double)((TextSegment)match.embedded()).metadata().getDouble("double_123")).isEqualTo(1.23456789);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(1)).build()).matches()).isEqualTo((Object)relevant);
    }

    protected Metadata createMetadata() {
        Metadata metadata = new Metadata();
        metadata.put("string_empty", "");
        metadata.put("string_space", " ");
        metadata.put("string_abc", "abc");
        metadata.put("uuid", TEST_UUID);
        metadata.put("integer_min", Integer.MIN_VALUE);
        metadata.put("integer_minus_1", -1);
        metadata.put("integer_0", 0);
        metadata.put("integer_1", 1);
        metadata.put("integer_max", Integer.MAX_VALUE);
        metadata.put("long_min", Long.MIN_VALUE);
        metadata.put("long_minus_1", -1L);
        metadata.put("long_0", 0L);
        metadata.put("long_1", 1L);
        metadata.put("long_max", Long.MAX_VALUE);
        metadata.put("float_min", -3.4028235E38f);
        metadata.put("float_minus_1", -1.0f);
        metadata.put("float_0", Float.MIN_VALUE);
        metadata.put("float_1", 1.0f);
        metadata.put("float_123", 1.2345679f);
        metadata.put("float_max", Float.MAX_VALUE);
        metadata.put("double_minus_1", -1.0);
        metadata.put("double_0", Double.MIN_VALUE);
        metadata.put("double_1", 1.0);
        metadata.put("double_123", 1.23456789);
        return metadata;
    }
}

