/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.DocumentTransformer;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.data.segment.TextSegmentTransformer;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.EmbeddingStoreIngestor;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class EmbeddingStoreIngestorTest {
    EmbeddingStoreIngestorTest() {
    }

    @Test
    public void should_extract_text_then_split_into_segments_then_embed_them_and_store_in_embedding_store() {
        Document firstDocument = Document.from((String)"First sentence.");
        Document secondDocument = Document.from((String)"Second sentence. Third sentence.");
        Document thirdDocument = Document.from((String)"Fourth sentence.");
        Document fourthDocument = Document.from((String)"Fifth sentence.");
        Document fifthDocument = Document.from((String)"Sixth Sentence");
        DocumentTransformer documentTransformer = (DocumentTransformer)Mockito.mock(DocumentTransformer.class);
        Mockito.when((Object)documentTransformer.transformAll(Collections.singletonList(firstDocument))).thenReturn(Collections.singletonList(firstDocument));
        Mockito.when((Object)documentTransformer.transformAll(Arrays.asList(secondDocument, thirdDocument))).thenReturn(Arrays.asList(secondDocument, thirdDocument));
        Mockito.when((Object)documentTransformer.transformAll(Arrays.asList(fourthDocument, fifthDocument))).thenReturn(Arrays.asList(fourthDocument, fifthDocument));
        DocumentSplitter documentSplitter = (DocumentSplitter)Mockito.mock(DocumentSplitter.class);
        Mockito.when((Object)documentSplitter.splitAll(Collections.singletonList(firstDocument))).thenReturn(Collections.singletonList(TextSegment.textSegment((String)"First sentence.")));
        Mockito.when((Object)documentSplitter.splitAll(Arrays.asList(secondDocument, thirdDocument))).thenReturn(Arrays.asList(TextSegment.textSegment((String)"Second sentence."), TextSegment.textSegment((String)"Third sentence."), TextSegment.textSegment((String)"Fourth sentence.")));
        Mockito.when((Object)documentSplitter.splitAll(Arrays.asList(fourthDocument, fifthDocument))).thenReturn(Arrays.asList(TextSegment.textSegment((String)"Fifth sentence."), TextSegment.textSegment((String)"Sixth sentence.")));
        TextSegmentTransformer textSegmentTransformer = (TextSegmentTransformer)Mockito.mock(TextSegmentTransformer.class);
        Mockito.when((Object)textSegmentTransformer.transformAll(Collections.singletonList(TextSegment.textSegment((String)"First sentence.")))).thenReturn(Collections.singletonList(TextSegment.textSegment((String)"Transformed first sentence.")));
        Mockito.when((Object)textSegmentTransformer.transformAll(Arrays.asList(TextSegment.textSegment((String)"Second sentence."), TextSegment.textSegment((String)"Third sentence."), TextSegment.textSegment((String)"Fourth sentence.")))).thenReturn(Arrays.asList(TextSegment.textSegment((String)"Transformed second sentence."), TextSegment.textSegment((String)"Transformed third sentence."), TextSegment.textSegment((String)"Transformed fourth sentence.")));
        Mockito.when((Object)textSegmentTransformer.transformAll(Arrays.asList(TextSegment.textSegment((String)"Fifth sentence."), TextSegment.textSegment((String)"Sixth sentence.")))).thenReturn(Arrays.asList(TextSegment.textSegment((String)"Transformed fifth sentence."), TextSegment.textSegment((String)"Transformed sixth sentence.")));
        EmbeddingModel embeddingModel = (EmbeddingModel)Mockito.mock(EmbeddingModel.class);
        Mockito.when((Object)embeddingModel.embedAll(Collections.singletonList(TextSegment.textSegment((String)"Transformed first sentence.")))).thenReturn((Object)Response.from(Collections.singletonList(Embedding.from((float[])new float[]{1.0f}))));
        Mockito.when((Object)embeddingModel.embedAll(Arrays.asList(TextSegment.textSegment((String)"Transformed second sentence."), TextSegment.textSegment((String)"Transformed third sentence."), TextSegment.textSegment((String)"Transformed fourth sentence.")))).thenReturn((Object)Response.from(Arrays.asList(Embedding.from((float[])new float[]{2.0f}), Embedding.from((float[])new float[]{3.0f}), Embedding.from((float[])new float[]{4.0f}))));
        Mockito.when((Object)embeddingModel.embedAll(Arrays.asList(TextSegment.textSegment((String)"Transformed fifth sentence."), TextSegment.textSegment((String)"Transformed sixth sentence.")))).thenReturn((Object)Response.from(Arrays.asList(Embedding.from((float[])new float[]{5.0f}), Embedding.from((float[])new float[]{6.0f}))));
        EmbeddingStore embeddingStore = (EmbeddingStore)Mockito.mock(EmbeddingStore.class);
        EmbeddingStoreIngestor ingestor = EmbeddingStoreIngestor.builder().documentTransformer(documentTransformer).documentSplitter(documentSplitter).textSegmentTransformer(textSegmentTransformer).embeddingModel(embeddingModel).embeddingStore(embeddingStore).build();
        ingestor.ingest(firstDocument);
        ingestor.ingest(new Document[]{secondDocument, thirdDocument});
        ingestor.ingest(Arrays.asList(fourthDocument, fifthDocument));
        ((DocumentTransformer)Mockito.verify((Object)documentTransformer)).transformAll(Collections.singletonList(firstDocument));
        ((DocumentTransformer)Mockito.verify((Object)documentTransformer)).transformAll(Arrays.asList(secondDocument, thirdDocument));
        ((DocumentTransformer)Mockito.verify((Object)documentTransformer)).transformAll(Arrays.asList(fourthDocument, fifthDocument));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{documentTransformer});
        ((DocumentSplitter)Mockito.verify((Object)documentSplitter)).splitAll(Collections.singletonList(firstDocument));
        ((DocumentSplitter)Mockito.verify((Object)documentSplitter)).splitAll(Arrays.asList(secondDocument, thirdDocument));
        ((DocumentSplitter)Mockito.verify((Object)documentSplitter)).splitAll(Arrays.asList(fourthDocument, fifthDocument));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{documentSplitter});
        ((TextSegmentTransformer)Mockito.verify((Object)textSegmentTransformer)).transformAll(Collections.singletonList(TextSegment.textSegment((String)"First sentence.")));
        ((TextSegmentTransformer)Mockito.verify((Object)textSegmentTransformer)).transformAll(Arrays.asList(TextSegment.textSegment((String)"Second sentence."), TextSegment.textSegment((String)"Third sentence."), TextSegment.textSegment((String)"Fourth sentence.")));
        ((TextSegmentTransformer)Mockito.verify((Object)textSegmentTransformer)).transformAll(Arrays.asList(TextSegment.textSegment((String)"Fifth sentence."), TextSegment.textSegment((String)"Sixth sentence.")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{textSegmentTransformer});
        ((EmbeddingModel)Mockito.verify((Object)embeddingModel)).embedAll(Collections.singletonList(TextSegment.textSegment((String)"Transformed first sentence.")));
        ((EmbeddingModel)Mockito.verify((Object)embeddingModel)).embedAll(Arrays.asList(TextSegment.textSegment((String)"Transformed second sentence."), TextSegment.textSegment((String)"Transformed third sentence."), TextSegment.textSegment((String)"Transformed fourth sentence.")));
        ((EmbeddingModel)Mockito.verify((Object)embeddingModel)).embedAll(Arrays.asList(TextSegment.textSegment((String)"Transformed fifth sentence."), TextSegment.textSegment((String)"Transformed sixth sentence.")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{embeddingModel});
        ((EmbeddingStore)Mockito.verify((Object)embeddingStore)).addAll(Collections.singletonList(new Embedding(new float[]{1.0f})), Collections.singletonList(TextSegment.textSegment((String)"Transformed first sentence.")));
        ((EmbeddingStore)Mockito.verify((Object)embeddingStore)).addAll(Arrays.asList(new Embedding(new float[]{2.0f}), new Embedding(new float[]{3.0f}), new Embedding(new float[]{4.0f})), Arrays.asList(TextSegment.textSegment((String)"Transformed second sentence."), TextSegment.textSegment((String)"Transformed third sentence."), TextSegment.textSegment((String)"Transformed fourth sentence.")));
        ((EmbeddingStore)Mockito.verify((Object)embeddingStore)).addAll(Arrays.asList(new Embedding(new float[]{5.0f}), new Embedding(new float[]{6.0f})), Arrays.asList(TextSegment.textSegment((String)"Transformed fifth sentence."), TextSegment.textSegment((String)"Transformed sixth sentence.")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{embeddingStore});
    }

    @Test
    void should_not_split_when_no_splitter_is_specified() {
        String text = "Some text";
        Document document = Document.from((String)text);
        TextSegment expectedTextSegment = TextSegment.from((String)text, (Metadata)Metadata.from((String)"index", (String)"0"));
        Embedding expectedEmbedding = Embedding.from((float[])new float[]{1.0f});
        EmbeddingModel embeddingModel = (EmbeddingModel)Mockito.mock(EmbeddingModel.class);
        Mockito.when((Object)embeddingModel.embedAll(Collections.singletonList(expectedTextSegment))).thenReturn((Object)Response.from(Collections.singletonList(expectedEmbedding)));
        EmbeddingStore embeddingStore = (EmbeddingStore)Mockito.mock(EmbeddingStore.class);
        EmbeddingStoreIngestor ingestor = EmbeddingStoreIngestor.builder().embeddingModel(embeddingModel).embeddingStore(embeddingStore).build();
        ingestor.ingest(document);
        ((EmbeddingStore)Mockito.verify((Object)embeddingStore)).addAll(Collections.singletonList(expectedEmbedding), Collections.singletonList(expectedTextSegment));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{embeddingStore});
    }
}

