/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.CosineSimilarity;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.RelevanceScore;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class EmbeddingStoreWithoutMetadataIT {
    protected abstract EmbeddingStore<TextSegment> embeddingStore();

    protected abstract EmbeddingModel embeddingModel();

    @BeforeEach
    void beforeEach() {
        this.clearStore();
        this.ensureStoreIsEmpty();
    }

    protected void clearStore() {
    }

    protected void ensureStoreIsEmpty() {
        Embedding embedding = (Embedding)this.embeddingModel().embed("hello").content();
        Assertions.assertThat((List)this.embeddingStore().findRelevant(embedding, 1000)).isEmpty();
    }

    @Test
    void should_add_embedding() {
        Embedding embedding = (Embedding)this.embeddingModel().embed("hello").content();
        String id = this.embeddingStore().add(embedding);
        Assertions.assertThat((String)id).isNotBlank();
        this.awaitUntilPersisted();
        List relevant = this.embeddingStore().findRelevant(embedding, 10);
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)match.embeddingId()).isEqualTo(id);
        Assertions.assertThat((Object)match.embedding()).isEqualTo((Object)embedding);
        Assertions.assertThat((Object)((TextSegment)match.embedded())).isNull();
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_embedding_with_id() {
        String id = Utils.randomUUID();
        Embedding embedding = (Embedding)this.embeddingModel().embed("hello").content();
        this.embeddingStore().add(id, embedding);
        this.awaitUntilPersisted();
        List relevant = this.embeddingStore().findRelevant(embedding, 10);
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)match.embeddingId()).isEqualTo(id);
        Assertions.assertThat((Object)match.embedding()).isEqualTo((Object)embedding);
        Assertions.assertThat((Object)((TextSegment)match.embedded())).isNull();
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_embedding_with_segment() {
        TextSegment segment = TextSegment.from((String)"hello");
        Embedding embedding = (Embedding)this.embeddingModel().embed(segment.text()).content();
        String id = this.embeddingStore().add(embedding, (Object)segment);
        Assertions.assertThat((String)id).isNotBlank();
        this.awaitUntilPersisted();
        List relevant = this.embeddingStore().findRelevant(embedding, 10);
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)match.embeddingId()).isEqualTo(id);
        Assertions.assertThat((Object)match.embedding()).isEqualTo((Object)embedding);
        Assertions.assertThat((Object)((TextSegment)match.embedded())).isEqualTo((Object)segment);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_multiple_embeddings() {
        Embedding firstEmbedding = (Embedding)this.embeddingModel().embed("hello").content();
        Embedding secondEmbedding = (Embedding)this.embeddingModel().embed("hi").content();
        List ids = this.embeddingStore().addAll(Arrays.asList(firstEmbedding, secondEmbedding));
        Assertions.assertThat((List)ids).hasSize(2);
        Assertions.assertThat((String)((String)ids.get(0))).isNotBlank();
        Assertions.assertThat((String)((String)ids.get(1))).isNotBlank();
        Assertions.assertThat((String)((String)ids.get(0))).isNotEqualTo(ids.get(1));
        this.awaitUntilPersisted();
        List relevant = this.embeddingStore().findRelevant(firstEmbedding, 10);
        Assertions.assertThat((List)relevant).hasSize(2);
        EmbeddingMatch firstMatch = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)firstMatch.score()).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)firstMatch.embeddingId()).isEqualTo((String)ids.get(0));
        Assertions.assertThat((Object)firstMatch.embedding()).isEqualTo((Object)firstEmbedding);
        Assertions.assertThat((Object)((TextSegment)firstMatch.embedded())).isNull();
        EmbeddingMatch secondMatch = (EmbeddingMatch)relevant.get(1);
        Assertions.assertThat((Double)secondMatch.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)firstEmbedding, (Embedding)secondEmbedding)), Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)secondMatch.embeddingId()).isEqualTo((String)ids.get(1));
        Assertions.assertThat((double)CosineSimilarity.between((Embedding)secondMatch.embedding(), (Embedding)secondEmbedding)).isCloseTo(1.0, Percentage.withPercentage((double)0.01));
        Assertions.assertThat((Object)((TextSegment)secondMatch.embedded())).isNull();
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_add_multiple_embeddings_with_segments() {
        TextSegment firstSegment = TextSegment.from((String)"hello");
        Embedding firstEmbedding = (Embedding)this.embeddingModel().embed(firstSegment.text()).content();
        TextSegment secondSegment = TextSegment.from((String)"hi");
        Embedding secondEmbedding = (Embedding)this.embeddingModel().embed(secondSegment.text()).content();
        List ids = this.embeddingStore().addAll(Arrays.asList(firstEmbedding, secondEmbedding), Arrays.asList(firstSegment, secondSegment));
        Assertions.assertThat((List)ids).hasSize(2);
        Assertions.assertThat((String)((String)ids.get(0))).isNotBlank();
        Assertions.assertThat((String)((String)ids.get(1))).isNotBlank();
        Assertions.assertThat((String)((String)ids.get(0))).isNotEqualTo(ids.get(1));
        this.awaitUntilPersisted();
        List relevant = this.embeddingStore().findRelevant(firstEmbedding, 10);
        Assertions.assertThat((List)relevant).hasSize(2);
        EmbeddingMatch firstMatch = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)firstMatch.score()).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)firstMatch.embeddingId()).isEqualTo((String)ids.get(0));
        Assertions.assertThat((Object)firstMatch.embedding()).isEqualTo((Object)firstEmbedding);
        Assertions.assertThat((Object)((TextSegment)firstMatch.embedded())).isEqualTo((Object)firstSegment);
        EmbeddingMatch secondMatch = (EmbeddingMatch)relevant.get(1);
        Assertions.assertThat((Double)secondMatch.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)firstEmbedding, (Embedding)secondEmbedding)), Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)secondMatch.embeddingId()).isEqualTo((String)ids.get(1));
        Assertions.assertThat((double)CosineSimilarity.between((Embedding)secondMatch.embedding(), (Embedding)secondEmbedding)).isCloseTo(1.0, Percentage.withPercentage((double)0.01));
        Assertions.assertThat((Object)((TextSegment)secondMatch.embedded())).isEqualTo((Object)secondSegment);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
    }

    @Test
    void should_find_with_min_score() {
        String firstId = Utils.randomUUID();
        Embedding firstEmbedding = (Embedding)this.embeddingModel().embed("hello").content();
        this.embeddingStore().add(firstId, firstEmbedding);
        String secondId = Utils.randomUUID();
        Embedding secondEmbedding = (Embedding)this.embeddingModel().embed("hi").content();
        this.embeddingStore().add(secondId, secondEmbedding);
        this.awaitUntilPersisted();
        List relevant = this.embeddingStore().findRelevant(firstEmbedding, 10);
        Assertions.assertThat((List)relevant).hasSize(2);
        EmbeddingMatch firstMatch = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)firstMatch.score()).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)firstMatch.embeddingId()).isEqualTo(firstId);
        EmbeddingMatch secondMatch = (EmbeddingMatch)relevant.get(1);
        Assertions.assertThat((Double)secondMatch.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)firstEmbedding, (Embedding)secondEmbedding)), Percentage.withPercentage((double)1.0));
        Assertions.assertThat((String)secondMatch.embeddingId()).isEqualTo(secondId);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).build()).matches()).isEqualTo((Object)relevant);
        List relevant2 = this.embeddingStore().findRelevant(firstEmbedding, 10, secondMatch.score() - 0.01);
        Assertions.assertThat((List)relevant2).hasSize(2);
        Assertions.assertThat((String)((EmbeddingMatch)relevant2.get(0)).embeddingId()).isEqualTo(firstId);
        Assertions.assertThat((String)((EmbeddingMatch)relevant2.get(1)).embeddingId()).isEqualTo(secondId);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).minScore(Double.valueOf(secondMatch.score() - 0.01)).build()).matches()).isEqualTo((Object)relevant2);
        List relevant3 = this.embeddingStore().findRelevant(firstEmbedding, 10, secondMatch.score().doubleValue());
        Assertions.assertThat((List)relevant3).hasSize(2);
        Assertions.assertThat((String)((EmbeddingMatch)relevant3.get(0)).embeddingId()).isEqualTo(firstId);
        Assertions.assertThat((String)((EmbeddingMatch)relevant3.get(1)).embeddingId()).isEqualTo(secondId);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).minScore(secondMatch.score()).build()).matches()).isEqualTo((Object)relevant3);
        List relevant4 = this.embeddingStore().findRelevant(firstEmbedding, 10, secondMatch.score() + 0.01);
        Assertions.assertThat((List)relevant4).hasSize(1);
        Assertions.assertThat((String)((EmbeddingMatch)relevant4.get(0)).embeddingId()).isEqualTo(firstId);
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(firstEmbedding).maxResults(Integer.valueOf(10)).minScore(Double.valueOf(secondMatch.score() + 0.01)).build()).matches()).isEqualTo((Object)relevant4);
    }

    @Test
    void should_return_correct_score() {
        Embedding embedding = (Embedding)this.embeddingModel().embed("hello").content();
        String id = this.embeddingStore().add(embedding);
        Assertions.assertThat((String)id).isNotBlank();
        this.awaitUntilPersisted();
        Embedding referenceEmbedding = (Embedding)this.embeddingModel().embed("hi").content();
        List relevant = this.embeddingStore().findRelevant(referenceEmbedding, 1);
        Assertions.assertThat((List)relevant).hasSize(1);
        EmbeddingMatch match = (EmbeddingMatch)relevant.get(0);
        Assertions.assertThat((Double)match.score()).isCloseTo(RelevanceScore.fromCosineSimilarity((double)CosineSimilarity.between((Embedding)embedding, (Embedding)referenceEmbedding)), Percentage.withPercentage((double)1.0));
        Assertions.assertThat((List)this.embeddingStore().search(EmbeddingSearchRequest.builder().queryEmbedding(referenceEmbedding).maxResults(Integer.valueOf(1)).build()).matches()).isEqualTo((Object)relevant);
    }

    protected void awaitUntilPersisted() {
    }
}

