/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search;

import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import java.net.URI;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class WebSearchEngineIT {
    protected abstract WebSearchEngine searchEngine();

    @Test
    void should_search() {
        WebSearchResults webSearchResults = this.searchEngine().search("LangChain4j");
        List results = webSearchResults.results();
        Assertions.assertThat((List)results).hasSize(5);
        results.forEach(result -> {
            Assertions.assertThat((String)result.title()).isNotBlank();
            Assertions.assertThat((URI)result.url()).isNotNull();
            Assertions.assertThat((String)result.snippet()).isNotBlank();
            Assertions.assertThat((String)result.content()).isNull();
        });
        Assertions.assertThat((List)results).anyMatch(result -> result.url().toString().contains("https://github.com/langchain4j"));
    }

    @Test
    void should_search_with_max_results() {
        int maxResults = 7;
        WebSearchRequest request = WebSearchRequest.builder().searchTerms("LangChain4j").maxResults(Integer.valueOf(maxResults)).build();
        WebSearchResults webSearchResults = this.searchEngine().search(request);
        List results = webSearchResults.results();
        Assertions.assertThat((List)results).hasSize(maxResults);
    }
}

