/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.config;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
@ConfigurationProperties(value="mica.redis")
public class MicaRedisProperties {
    public static final String PREFIX = "mica.redis";
    private SerializerType serializerType = SerializerType.JSON;
    private Stream stream = new Stream();

    public SerializerType getSerializerType() {
        return this.serializerType;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setSerializerType(SerializerType serializerType) {
        this.serializerType = serializerType;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public static class Stream {
        public static final String PREFIX = "mica.redis.stream";
        boolean enable = false;
        String consumerGroup;
        String consumerName;
        Integer pollBatchSize;
        Duration pollTimeout;

        public boolean isEnable() {
            return this.enable;
        }

        public String getConsumerGroup() {
            return this.consumerGroup;
        }

        public String getConsumerName() {
            return this.consumerName;
        }

        public Integer getPollBatchSize() {
            return this.pollBatchSize;
        }

        public Duration getPollTimeout() {
            return this.pollTimeout;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setConsumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
        }

        public void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        public void setPollBatchSize(Integer pollBatchSize) {
            this.pollBatchSize = pollBatchSize;
        }

        public void setPollTimeout(Duration pollTimeout) {
            this.pollTimeout = pollTimeout;
        }
    }

    public static enum SerializerType {
        JSON,
        JDK;

    }
}

