/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.CmmnActivityWithMigrationContextBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EntityLinkUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.cmmn.engine.interceptor.CreateHumanTaskAfterContext;
import org.flowable.cmmn.engine.interceptor.CreateHumanTaskBeforeContext;
import org.flowable.cmmn.engine.interceptor.MigrationContext;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.logging.LoggingSessionUtil;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class HumanTaskActivityBehavior
extends TaskActivityBehavior
implements PlanItemActivityBehavior,
CmmnActivityWithMigrationContextBehavior {
    protected HumanTask humanTask;

    public HumanTaskActivityBehavior(HumanTask humanTask) {
        super(humanTask.isBlocking(), humanTask.getBlockingExpression());
        this.humanTask = humanTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        this.execute(commandContext, planItemInstanceEntity, null);
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, MigrationContext migrationContext) {
        if (this.evaluateIsBlocking(planItemInstanceEntity)) {
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            TaskService taskService = cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService();
            ExpressionManager expressionManager = CommandContextUtil.getExpressionManager(commandContext);
            TaskEntity taskEntity = taskService.createTask();
            taskEntity.setScopeId(planItemInstanceEntity.getCaseInstanceId());
            taskEntity.setSubScopeId(planItemInstanceEntity.getId());
            taskEntity.setScopeDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
            taskEntity.setScopeType("cmmn");
            taskEntity.setTenantId(planItemInstanceEntity.getTenantId());
            taskEntity.setPropagatedStageInstanceId(planItemInstanceEntity.getStageInstanceId());
            taskEntity.setTaskDefinitionKey(this.humanTask.getId());
            String taskName = this.humanTask.getName();
            if (planItemInstanceEntity.getName() != null) {
                taskName = planItemInstanceEntity.getName();
            }
            CreateHumanTaskBeforeContext beforeContext = new CreateHumanTaskBeforeContext(this.humanTask, planItemInstanceEntity, taskName, this.humanTask.getDocumentation(), this.humanTask.getDueDate(), this.humanTask.getPriority(), this.humanTask.getCategory(), this.humanTask.getFormKey(), this.humanTask.getAssignee(), this.humanTask.getOwner(), this.humanTask.getCandidateUsers(), this.humanTask.getCandidateGroups());
            if (cmmnEngineConfiguration.getCreateHumanTaskInterceptor() != null) {
                cmmnEngineConfiguration.getCreateHumanTaskInterceptor().beforeCreateHumanTask(beforeContext);
            }
            this.handleTaskName(planItemInstanceEntity, expressionManager, taskEntity, beforeContext);
            this.handleTaskDescription(planItemInstanceEntity, expressionManager, taskEntity, beforeContext);
            this.handleAssignee(planItemInstanceEntity, taskService, expressionManager, taskEntity, beforeContext, migrationContext);
            this.handleOwner(planItemInstanceEntity, taskService, expressionManager, taskEntity, beforeContext);
            this.handlePriority(planItemInstanceEntity, expressionManager, taskEntity, beforeContext);
            this.handleFormKey(planItemInstanceEntity, expressionManager, taskEntity, beforeContext);
            this.handleDueDate(commandContext, planItemInstanceEntity, expressionManager, taskEntity, beforeContext);
            this.handleCategory(planItemInstanceEntity, expressionManager, taskEntity, beforeContext);
            TaskHelper.insertTask(taskEntity, true, cmmnEngineConfiguration);
            if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                ObjectNode loggingNode;
                CmmnLoggingSessionUtil.addLoggingData("humanTaskCreate", "Human task '" + taskEntity.getName() + "' created", taskEntity, planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
                if (StringUtils.isNotEmpty((CharSequence)taskEntity.getAssignee())) {
                    loggingNode = CmmnLoggingSessionUtil.fillBasicTaskLoggingData("Set task assignee value to " + taskEntity.getAssignee(), taskEntity, planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
                    loggingNode.put("taskAssignee", taskEntity.getAssignee());
                    LoggingSessionUtil.addLoggingData((String)"humanTaskSetAssignee", (ObjectNode)loggingNode, (String)"cmmn");
                }
                if (StringUtils.isNotEmpty((CharSequence)taskEntity.getOwner())) {
                    loggingNode = CmmnLoggingSessionUtil.fillBasicTaskLoggingData("Set task owner value to " + taskEntity.getOwner(), taskEntity, planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
                    loggingNode.put("taskOwner", taskEntity.getOwner());
                    LoggingSessionUtil.addLoggingData((String)"humanTaskSetOwner", (ObjectNode)loggingNode, (String)"cmmn");
                }
            }
            this.handleCandidateUsers(commandContext, planItemInstanceEntity, expressionManager, taskEntity, beforeContext);
            this.handleCandidateGroups(commandContext, planItemInstanceEntity, expressionManager, taskEntity, beforeContext);
            this.handleTaskIdVariableStorage(planItemInstanceEntity, this.humanTask, expressionManager, taskEntity);
            planItemInstanceEntity.setReferenceId(taskEntity.getId());
            planItemInstanceEntity.setReferenceType("cmmn-1.1-to-cmmn-1.1-child-human-task");
            if (cmmnEngineConfiguration.isEnableEntityLinks()) {
                EntityLinkUtil.createEntityLinks(planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId(), planItemInstanceEntity.getPlanItemDefinitionId(), taskEntity.getId(), "task", cmmnEngineConfiguration);
            }
            if (cmmnEngineConfiguration.getCreateHumanTaskInterceptor() != null) {
                CreateHumanTaskAfterContext afterContext = new CreateHumanTaskAfterContext(this.humanTask, taskEntity, planItemInstanceEntity);
                cmmnEngineConfiguration.getCreateHumanTaskInterceptor().afterCreateHumanTask(afterContext);
            }
            CommandContextUtil.getCmmnHistoryManager(commandContext).recordTaskCreated(taskEntity);
            cmmnEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(this.humanTask, taskEntity, "create");
        } else {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
    }

    protected void handleTaskName(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        Object name;
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getName()) && (name = expressionManager.createExpression(beforeContext.getName()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (name instanceof String) {
                taskEntity.setName((String)name);
            } else {
                throw new FlowableIllegalArgumentException("name expression does not resolve to a string: " + beforeContext.getName());
            }
        }
    }

    protected void handleTaskDescription(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        Object description;
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getDescription()) && (description = expressionManager.createExpression(beforeContext.getDescription()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (description instanceof String) {
                taskEntity.setDescription((String)description);
            } else {
                throw new FlowableIllegalArgumentException("documentation expression does not resolve to a string: " + beforeContext.getDescription());
            }
        }
    }

    protected void handleAssignee(PlanItemInstanceEntity planItemInstanceEntity, TaskService taskService, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext, MigrationContext migrationContext) {
        String assigneeStringValue = null;
        if (migrationContext != null && migrationContext.getAssignee() != null) {
            assigneeStringValue = migrationContext.getAssignee();
        } else if (StringUtils.isNotEmpty((CharSequence)beforeContext.getAssignee())) {
            assigneeStringValue = beforeContext.getAssignee();
        }
        if (StringUtils.isNotEmpty((CharSequence)assigneeStringValue)) {
            Object assigneeExpressionValue = expressionManager.createExpression(assigneeStringValue).getValue((VariableContainer)planItemInstanceEntity);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            taskService.changeTaskAssignee(taskEntity, assigneeValue);
        }
    }

    protected void handleOwner(PlanItemInstanceEntity planItemInstanceEntity, TaskService taskService, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getOwner())) {
            Object ownerExpressionValue = expressionManager.createExpression(beforeContext.getOwner()).getValue((VariableContainer)planItemInstanceEntity);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            taskService.changeTaskOwner(taskEntity, ownerValue);
        }
    }

    protected void handlePriority(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        Object priority;
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getPriority()) && (priority = expressionManager.createExpression(beforeContext.getPriority()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (priority instanceof String) {
                try {
                    taskEntity.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new FlowableIllegalArgumentException("Priority does not resolve to a number: " + beforeContext.getPriority(), (Throwable)e);
                }
            } else if (priority instanceof Number) {
                taskEntity.setPriority(((Number)priority).intValue());
            } else {
                throw new FlowableIllegalArgumentException("Priority expression does not resolve to a number: " + beforeContext.getPriority());
            }
        }
    }

    protected void handleFormKey(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        Object formKey;
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getFormKey()) && (formKey = expressionManager.createExpression(beforeContext.getFormKey()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (formKey instanceof String) {
                taskEntity.setFormKey((String)formKey);
            } else {
                throw new FlowableIllegalArgumentException("FormKey expression does not resolve to a string: " + beforeContext.getFormKey());
            }
        }
    }

    protected void handleDueDate(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        Object dueDate;
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getDueDate()) && (dueDate = expressionManager.createExpression(beforeContext.getDueDate()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (dueDate instanceof Date) {
                taskEntity.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                String dueDateString = (String)dueDate;
                if (dueDateString.startsWith("P")) {
                    taskEntity.setDueDate(new DateTime((Object)CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock().getCurrentTime()).plus((ReadablePeriod)Period.parse((String)dueDateString)).toDate());
                } else {
                    taskEntity.setDueDate(DateTime.parse((String)dueDateString).toDate());
                }
            } else {
                throw new FlowableIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + beforeContext.getDueDate());
            }
        }
    }

    protected void handleCategory(PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        Object category;
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getCategory()) && (category = expressionManager.createExpression(beforeContext.getCategory()).getValue((VariableContainer)planItemInstanceEntity)) != null) {
            if (category instanceof String) {
                taskEntity.setCategory((String)category);
            } else {
                throw new FlowableIllegalArgumentException("Category expression does not resolve to a string: " + beforeContext.getCategory());
            }
        }
    }

    protected void handleCandidateUsers(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        List<String> candidateUsers = beforeContext.getCandidateUsers();
        if (candidateUsers != null && !candidateUsers.isEmpty()) {
            ArrayList<IdentityLinkEntity> allIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
            for (String candidateUser : candidateUsers) {
                Expression userIdExpr = expressionManager.createExpression(candidateUser);
                Object value = userIdExpr.getValue((VariableContainer)planItemInstanceEntity);
                Collection<String> candidates = this.extractCandidates(value);
                List identityLinkEntities = cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().addCandidateUsers(taskEntity.getId(), candidates);
                if (identityLinkEntities == null || identityLinkEntities.isEmpty()) continue;
                IdentityLinkUtil.handleTaskIdentityLinkAdditions(taskEntity, identityLinkEntities, cmmnEngineConfiguration);
                allIdentityLinkEntities.addAll(identityLinkEntities);
            }
            if (!allIdentityLinkEntities.isEmpty() && cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                CmmnLoggingSessionUtil.addTaskIdentityLinkData("humanTaskSetUserIdentityLinks", "Added " + allIdentityLinkEntities.size() + " candidate user identity links to task", true, allIdentityLinkEntities, taskEntity, planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
            }
        }
    }

    protected void handleCandidateGroups(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager, TaskEntity taskEntity, CreateHumanTaskBeforeContext beforeContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        List<String> candidateGroups = beforeContext.getCandidateGroups();
        if (candidateGroups != null && !candidateGroups.isEmpty()) {
            ArrayList<IdentityLinkEntity> allIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
            for (String candidateGroup : candidateGroups) {
                Expression groupIdExpr = expressionManager.createExpression(candidateGroup);
                Object value = groupIdExpr.getValue((VariableContainer)planItemInstanceEntity);
                Collection<String> candidates = this.extractCandidates(value);
                List identityLinkEntities = cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().addCandidateGroups(taskEntity.getId(), candidates);
                if (identityLinkEntities == null || identityLinkEntities.isEmpty()) continue;
                IdentityLinkUtil.handleTaskIdentityLinkAdditions(taskEntity, identityLinkEntities, cmmnEngineConfiguration);
                allIdentityLinkEntities.addAll(identityLinkEntities);
            }
            if (!allIdentityLinkEntities.isEmpty() && cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                CmmnLoggingSessionUtil.addTaskIdentityLinkData("humanTaskSetUserIdentityLinks", "Added " + allIdentityLinkEntities.size() + " candidate group identity links to task", true, allIdentityLinkEntities, taskEntity, planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
            }
        }
    }

    protected Collection<String> extractCandidates(Object value) {
        if (value instanceof String) {
            return Arrays.asList(value.toString().split("[\\s]*,[\\s]*"));
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof ArrayNode) {
            ArrayNode valueArrayNode = (ArrayNode)value;
            ArrayList<String> candidates = new ArrayList<String>(valueArrayNode.size());
            for (JsonNode node : valueArrayNode) {
                candidates.add(node.asText());
            }
            return candidates;
        }
        throw new FlowableException("Expression did not resolve to a string, collection of strings or an array node");
    }

    private void handleTaskIdVariableStorage(PlanItemInstanceEntity planItemInstanceEntity, HumanTask humanTask, ExpressionManager expressionManager, TaskEntity taskEntity) {
        Expression expression;
        String idVariableName;
        if (StringUtils.isNotEmpty((CharSequence)humanTask.getTaskIdVariableName()) && StringUtils.isNotEmpty((CharSequence)(idVariableName = (String)(expression = expressionManager.createExpression(humanTask.getTaskIdVariableName())).getValue((VariableContainer)planItemInstanceEntity)))) {
            planItemInstanceEntity.setVariable(idVariableName, taskEntity.getId());
        }
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (!"active".equals(planItemInstance.getState())) {
            throw new FlowableIllegalStateException("Can only trigger a human task plan item that is in the ACTIVE state");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        TaskService taskService = cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        List taskEntities = taskService.findTasksBySubScopeIdScopeType(planItemInstance.getId(), "cmmn");
        if (taskEntities == null || taskEntities.isEmpty()) {
            throw new FlowableException("No task entity found for plan item instance " + planItemInstance.getId());
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            TaskHelper.deleteTask(taskEntity, null, false, true, cmmnEngineConfiguration);
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("terminate".equals(transition) || "exit".equals(transition)) {
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            TaskService taskService = cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService();
            List taskEntities = taskService.findTasksBySubScopeIdScopeType(planItemInstance.getId(), "cmmn");
            for (TaskEntity taskEntity : taskEntities) {
                TaskHelper.deleteTask(taskEntity, "cmmn-state-transition-" + transition, false, true, cmmnEngineConfiguration);
            }
        }
    }
}

