/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.util.Collection;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.OutboundEventChannelAdapter;
import org.flowable.eventregistry.api.OutboundEventProcessingPipeline;
import org.flowable.eventregistry.api.OutboundEventProcessor;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.OutboundChannelModel;

public class DefaultOutboundEventProcessor
implements OutboundEventProcessor {
    protected EventRepositoryService eventRepositoryService;
    protected boolean fallbackToDefaultTenant;

    public DefaultOutboundEventProcessor(EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        this.eventRepositoryService = eventRepositoryService;
        this.fallbackToDefaultTenant = fallbackToDefaultTenant;
    }

    public void sendEvent(EventInstance eventInstance, Collection<ChannelModel> channelModels) {
        if (channelModels == null || channelModels.isEmpty()) {
            throw new FlowableException("No channel model set for outgoing event " + eventInstance.getEventKey());
        }
        for (ChannelModel channelModel : channelModels) {
            OutboundChannelModel outboundChannelModel = (OutboundChannelModel)channelModel;
            OutboundEventProcessingPipeline outboundEventProcessingPipeline = (OutboundEventProcessingPipeline)outboundChannelModel.getOutboundEventProcessingPipeline();
            Object rawEvent = outboundEventProcessingPipeline.run(eventInstance);
            OutboundEventChannelAdapter outboundEventChannelAdapter = (OutboundEventChannelAdapter)outboundChannelModel.getOutboundEventChannelAdapter();
            if (outboundEventChannelAdapter == null) {
                throw new FlowableException("Could not find an outbound channel adapter for channel " + channelModel.getKey());
            }
            outboundEventChannelAdapter.sendEvent(rawEvent);
        }
    }
}

