/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.factory;

import java.lang.annotation.Annotation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.annotation.MiniDao;
import org.jeecgframework.minidao.aop.MiniDaoHandler;
import org.jeecgframework.minidao.aspect.EmptyInterceptor;
import org.jeecgframework.minidao.factory.MiniDaoClassPathMapperScanner;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class MiniDaoBeanScannerConfigurer
implements BeanDefinitionRegistryPostProcessor {
    private static final Log logger = LogFactory.getLog(MiniDaoBeanScannerConfigurer.class);
    private String basePackage;
    private Class<? extends Annotation> annotation = MiniDao.class;
    private String keyType = "origin";
    private boolean formatSql = false;
    private boolean showSql = false;
    private String dbType;
    private ApplicationContext applicationContext;
    private EmptyInterceptor emptyInterceptor;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.initRegisterRequestProxyHandler(registry);
        MiniDaoClassPathMapperScanner scanner = new MiniDaoClassPathMapperScanner(registry, this.annotation);
        if (this.basePackage != null) {
            scanner.scan(StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n"));
        } else {
            logger.error((Object)"MiniDao \u626b\u63cf\u8def\u5f84\u672a\u914d\u7f6e\uff0c\u8bf7\u8bbe\u7f6e minidao.base-package \u5c5e\u6027\uff0c\u5426\u5219 MiniDao \u65e0\u6cd5\u4f7f\u7528\uff01");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void initRegisterRequestProxyHandler(BeanDefinitionRegistry registry) {
        GenericBeanDefinition jdbcDaoProxyDefinition = new GenericBeanDefinition();
        jdbcDaoProxyDefinition.setBeanClass(MiniDaoHandler.class);
        jdbcDaoProxyDefinition.getPropertyValues().add("formatSql", (Object)this.formatSql);
        jdbcDaoProxyDefinition.getPropertyValues().add("keyType", (Object)this.keyType);
        jdbcDaoProxyDefinition.getPropertyValues().add("showSql", (Object)this.showSql);
        jdbcDaoProxyDefinition.setRole(2);
        if (this.emptyInterceptor != null) {
            jdbcDaoProxyDefinition.getPropertyValues().add("emptyInterceptor", (Object)this.emptyInterceptor);
        }
        if (this.applicationContext != null) {
            jdbcDaoProxyDefinition.getPropertyValues().add("applicationContext", (Object)this.applicationContext);
        }
        registry.registerBeanDefinition("miniDaoHandler", (BeanDefinition)jdbcDaoProxyDefinition);
    }

    public void setAnnotation(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEmptyInterceptor(EmptyInterceptor emptyInterceptor) {
        this.emptyInterceptor = emptyInterceptor;
    }
}

