/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.introspectingfilter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nimbusds.jose.util.Base64;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.oauth2.introspectingfilter.OAuth2AccessTokenImpl;
import org.mitre.oauth2.introspectingfilter.service.IntrospectionAuthorityGranter;
import org.mitre.oauth2.introspectingfilter.service.IntrospectionConfigurationService;
import org.mitre.oauth2.introspectingfilter.service.impl.SimpleIntrospectionAuthorityGranter;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.RegisteredClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class IntrospectingTokenService
implements ResourceServerTokenServices {
    private IntrospectionConfigurationService introspectionConfigurationService;
    private IntrospectionAuthorityGranter introspectionAuthorityGranter = new SimpleIntrospectionAuthorityGranter();
    private int defaultExpireTime = 300000;
    private boolean forceCacheExpireTime = false;
    private boolean cacheNonExpiringTokens = false;
    private boolean cacheTokens = true;
    private HttpComponentsClientHttpRequestFactory factory;
    private Map<String, TokenCacheObject> authCache = new HashMap<String, TokenCacheObject>();
    private static final Logger logger = LoggerFactory.getLogger(IntrospectingTokenService.class);

    public IntrospectingTokenService() {
        this((HttpClient)HttpClientBuilder.create().useSystemProperties().build());
    }

    public IntrospectingTokenService(HttpClient httpClient) {
        this.factory = new HttpComponentsClientHttpRequestFactory(httpClient);
    }

    public IntrospectionConfigurationService getIntrospectionConfigurationService() {
        return this.introspectionConfigurationService;
    }

    public void setIntrospectionConfigurationService(IntrospectionConfigurationService introspectionUrlProvider) {
        this.introspectionConfigurationService = introspectionUrlProvider;
    }

    public void setIntrospectionAuthorityGranter(IntrospectionAuthorityGranter introspectionAuthorityGranter) {
        this.introspectionAuthorityGranter = introspectionAuthorityGranter;
    }

    public IntrospectionAuthorityGranter getIntrospectionAuthorityGranter() {
        return this.introspectionAuthorityGranter;
    }

    public int getDefaultExpireTime() {
        return this.defaultExpireTime;
    }

    public void setDefaultExpireTime(int defaultExpireTime) {
        this.defaultExpireTime = defaultExpireTime;
    }

    public boolean isForceCacheExpireTime() {
        return this.forceCacheExpireTime;
    }

    public void setForceCacheExpireTime(boolean forceCacheExpireTime) {
        this.forceCacheExpireTime = forceCacheExpireTime;
    }

    public boolean isCacheNonExpiringTokens() {
        return this.cacheNonExpiringTokens;
    }

    public void setCacheNonExpiringTokens(boolean cacheNonExpiringTokens) {
        this.cacheNonExpiringTokens = cacheNonExpiringTokens;
    }

    public boolean isCacheTokens() {
        return this.cacheTokens;
    }

    public void setCacheTokens(boolean cacheTokens) {
        this.cacheTokens = cacheTokens;
    }

    private TokenCacheObject checkCache(String key) {
        if (this.cacheTokens && this.authCache.containsKey(key)) {
            TokenCacheObject tco = this.authCache.get(key);
            if (tco != null && tco.cacheExpire != null && tco.cacheExpire.after(new Date())) {
                return tco;
            }
            this.authCache.remove(key);
        }
        return null;
    }

    private OAuth2Request createStoredRequest(JsonObject token) {
        String clientId = token.get("client_id").getAsString();
        HashSet scopes = new HashSet();
        if (token.has("scope")) {
            scopes.addAll(OAuth2Utils.parseParameterList((String)token.get("scope").getAsString()));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_id", clientId);
        parameters.put("scope", OAuth2Utils.formatParameterList(scopes));
        OAuth2Request storedRequest = new OAuth2Request(parameters, clientId, null, true, scopes, null, null, null, null);
        return storedRequest;
    }

    private Authentication createUserAuthentication(JsonObject token) {
        JsonElement userId = token.get("user_id");
        if (userId == null) {
            return null;
        }
        return new PreAuthenticatedAuthenticationToken((Object)userId.getAsString(), (Object)token, this.introspectionAuthorityGranter.getAuthorities(token));
    }

    private OAuth2AccessToken createAccessToken(JsonObject token, String tokenString) {
        OAuth2AccessTokenImpl accessToken = new OAuth2AccessTokenImpl(token, tokenString);
        return accessToken;
    }

    private TokenCacheObject parseToken(String accessToken) {
        RestTemplate restTemplate;
        RegisteredClient client;
        String introspectionUrl;
        try {
            introspectionUrl = this.introspectionConfigurationService.getIntrospectionUrl(accessToken);
            client = this.introspectionConfigurationService.getClientConfiguration(accessToken);
        }
        catch (IllegalArgumentException e) {
            logger.error("Unable to load introspection URL or client configuration", (Throwable)e);
            return null;
        }
        String validatedToken = null;
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        final String clientId = client.getClientId();
        final String clientSecret = client.getClientSecret();
        if (ClientDetailsEntity.AuthMethod.SECRET_BASIC.equals((Object)client.getTokenEndpointAuthMethod())) {
            restTemplate = new RestTemplate((ClientHttpRequestFactory)this.factory){

                protected ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
                    ClientHttpRequest httpRequest = super.createRequest(url, method);
                    httpRequest.getHeaders().add("Authorization", String.format("Basic %s", Base64.encode((String)String.format("%s:%s", clientId, clientSecret))));
                    return httpRequest;
                }
            };
        } else {
            restTemplate = new RestTemplate((ClientHttpRequestFactory)this.factory);
            form.add((Object)"client_id", (Object)clientId);
            form.add((Object)"client_secret", (Object)clientSecret);
        }
        form.add((Object)"token", (Object)accessToken);
        try {
            validatedToken = (String)restTemplate.postForObject(introspectionUrl, (Object)form, String.class, new Object[0]);
        }
        catch (RestClientException rce) {
            logger.error("validateToken", (Throwable)rce);
            return null;
        }
        if (validatedToken != null) {
            JsonElement jsonRoot = new JsonParser().parse(validatedToken);
            if (!jsonRoot.isJsonObject()) {
                return null;
            }
            JsonObject tokenResponse = jsonRoot.getAsJsonObject();
            if (tokenResponse.get("error") != null) {
                logger.error("Got an error back: " + tokenResponse.get("error") + ", " + tokenResponse.get("error_description"));
                return null;
            }
            if (!tokenResponse.get("active").getAsBoolean()) {
                logger.info("Server returned non-active token");
                return null;
            }
            OAuth2Authentication auth = new OAuth2Authentication(this.createStoredRequest(tokenResponse), this.createUserAuthentication(tokenResponse));
            OAuth2AccessToken token = this.createAccessToken(tokenResponse, accessToken);
            if (token.getExpiration() == null || token.getExpiration().after(new Date())) {
                TokenCacheObject tco = new TokenCacheObject(token, auth);
                if (this.cacheTokens && (this.cacheNonExpiringTokens || token.getExpiration() != null)) {
                    this.authCache.put(accessToken, tco);
                }
                return tco;
            }
        }
        return null;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException {
        TokenCacheObject cacheAuth = this.checkCache(accessToken);
        if (cacheAuth != null) {
            return cacheAuth.auth;
        }
        cacheAuth = this.parseToken(accessToken);
        if (cacheAuth != null) {
            return cacheAuth.auth;
        }
        return null;
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        TokenCacheObject cacheAuth = this.checkCache(accessToken);
        if (cacheAuth != null) {
            return cacheAuth.token;
        }
        cacheAuth = this.parseToken(accessToken);
        if (cacheAuth != null) {
            return cacheAuth.token;
        }
        return null;
    }

    private class TokenCacheObject {
        OAuth2AccessToken token;
        OAuth2Authentication auth;
        Date cacheExpire;

        private TokenCacheObject(OAuth2AccessToken token, OAuth2Authentication auth) {
            this.token = token;
            this.auth = auth;
            if (this.token.getExpiration() != null && (!IntrospectingTokenService.this.forceCacheExpireTime || IntrospectingTokenService.this.forceCacheExpireTime && this.token.getExpiration().getTime() - System.currentTimeMillis() <= (long)IntrospectingTokenService.this.defaultExpireTime)) {
                this.cacheExpire = this.token.getExpiration();
            } else {
                Calendar cal = Calendar.getInstance();
                cal.add(14, IntrospectingTokenService.this.defaultExpireTime);
                this.cacheExpire = cal.getTime();
            }
        }
    }
}

